/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;

public class Socks5BytestreamSession
implements BytestreamSession {
    private final Socket socket;
    private final boolean isDirect;

    public Socks5BytestreamSession(Socket socket, boolean bl) {
        this.socket = socket;
        this.isDirect = bl;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean isMediated() {
        return !this.isDirect;
    }

    @Override
    public InputStream getInputStream() {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.socket.getOutputStream();
    }

    @Override
    public int getReadTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException socketException) {
            throw new IOException("Error on underlying Socket");
        }
    }

    @Override
    public void setReadTimeout(int n) {
        try {
            this.socket.setSoTimeout(n);
            return;
        }
        catch (SocketException socketException) {
            throw new IOException("Error on underlying Socket");
        }
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

