/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.h;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.provider.JingleContentProviderManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider.JingleS5BTransportProvider;

public final class JingleS5BTransportManager
extends JingleTransportManager<JingleS5BTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportManager.class.getName());
    private static final WeakHashMap<XMPPConnection, JingleS5BTransportManager> INSTANCES = new WeakHashMap();
    private List<Bytestream.StreamHost> localStreamHosts = null;
    private List<Bytestream.StreamHost> availableStreamHosts = null;
    private static boolean useLocalCandidates = true;
    private static boolean useExternalCandidates = true;

    private JingleS5BTransportManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        JingleContentProviderManager.addJingleContentTransportProvider(((JingleTransportManager)this).getNamespace(), new JingleS5BTransportProvider());
    }

    public static synchronized JingleS5BTransportManager getInstanceFor(XMPPConnection xMPPConnection) {
        JingleS5BTransportManager jingleS5BTransportManager = INSTANCES.get(xMPPConnection);
        if (jingleS5BTransportManager == null) {
            jingleS5BTransportManager = new JingleS5BTransportManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, jingleS5BTransportManager);
        }
        return jingleS5BTransportManager;
    }

    @Override
    public final String getNamespace() {
        return "urn:xmpp:jingle:transports:s5b:1";
    }

    @Override
    public final JingleTransportSession<JingleS5BTransport> transportSession(JingleSession jingleSession) {
        return new JingleS5BTransportSession(jingleSession);
    }

    private List<Bytestream.StreamHost> queryAvailableStreamHosts() {
        Object object = Socks5BytestreamManager.getBytestreamManager(this.getConnection());
        object = ((Socks5BytestreamManager)object).determineProxies();
        return this.determineStreamHostInfo((List<i>)object);
    }

    private List<Bytestream.StreamHost> queryLocalStreamHosts() {
        return Socks5BytestreamManager.getBytestreamManager(this.getConnection()).getLocalStreamHost();
    }

    public final List<Bytestream.StreamHost> getAvailableStreamHosts() {
        if (this.availableStreamHosts == null) {
            this.availableStreamHosts = this.queryAvailableStreamHosts();
        }
        return this.availableStreamHosts;
    }

    public final List<Bytestream.StreamHost> getLocalStreamHosts() {
        if (this.localStreamHosts == null) {
            this.localStreamHosts = this.queryLocalStreamHosts();
        }
        return this.localStreamHosts;
    }

    public final List<Bytestream.StreamHost> determineStreamHostInfo(List<i> object) {
        XMPPConnection xMPPConnection = this.getConnection();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (i)object.next();
            Bytestream bytestream = new Bytestream();
            bytestream.setType(IQ.Type.get);
            bytestream.setTo((i)object2);
            try {
                object2 = (Bytestream)xMPPConnection.createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow();
                arrayList.addAll(((Bytestream)((Object)object2)).getStreamHosts());
            }
            catch (Exception exception) {
                object.remove();
            }
        }
        return arrayList;
    }

    public final void authenticated(XMPPConnection object, boolean bl) {
        if (!bl) {
            try {
                object = Socks5Proxy.getSocks5Proxy();
                if (!((Socks5Proxy)object).isRunning()) {
                    ((Socks5Proxy)object).start();
                }
                this.localStreamHosts = this.queryLocalStreamHosts();
                this.availableStreamHosts = this.queryAvailableStreamHosts();
                return;
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not query available StreamHosts: " + throwable, throwable);
            }
        }
    }

    public final Jingle createCandidateUsed(h h2, h object, String object2, JingleContent.Senders senders, JingleContent.Creator creator, String string, String string2, String string3) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId((String)object2).setInitiator((h)object).setAction(JingleAction.transport_info);
        object = JingleContent.getBuilder();
        object.setName(string).setCreator(creator).setSenders(senders);
        object2 = JingleS5BTransport.getBuilder();
        ((JingleS5BTransport.Builder)object2).setCandidateUsed(string3).setStreamId(string2);
        object = builder.addJingleContent(object.setTransport(((JingleS5BTransport.Builder)object2).build()).build()).build();
        object.setFrom((i)this.getConnection().getUser().u());
        object.setTo((i)h2);
        return object;
    }

    public final Jingle createCandidateError(h h2, h object, String object2, JingleContent.Senders senders, JingleContent.Creator creator, String string, String string2) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId((String)object2).setInitiator((h)object).setAction(JingleAction.transport_info);
        object = JingleContent.getBuilder();
        object.setName(string).setCreator(creator).setSenders(senders);
        object2 = JingleS5BTransport.getBuilder();
        ((JingleS5BTransport.Builder)object2).setCandidateError().setStreamId(string2);
        object = builder.addJingleContent(object.setTransport(((JingleS5BTransport.Builder)object2).build()).build()).build();
        object.setFrom((i)this.getConnection().getUser().u());
        object.setTo((i)h2);
        return object;
    }

    public final Jingle createProxyError(h h2, h object, String string, JingleContent.Senders object2, JingleContent.Creator creator, String string2, String string3) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setSessionId(string).setAction(JingleAction.transport_info).setInitiator((h)object);
        object = JingleContent.getBuilder();
        object.setSenders((JingleContent.Senders)((Object)object2)).setCreator(creator).setName(string2);
        object2 = JingleS5BTransport.getBuilder();
        ((JingleS5BTransport.Builder)object2).setStreamId(string).setProxyError().setStreamId(string3);
        object = builder.addJingleContent(object.setTransport(((JingleS5BTransport.Builder)object2).build()).build()).build();
        object.setTo((i)h2);
        object.setFrom((i)this.getConnection().getUser().u());
        return object;
    }

    public final Jingle createCandidateActivated(h h2, h object, String object2, JingleContent.Senders senders, JingleContent.Creator creator, String string, String string2, String string3) {
        Jingle.Builder builder = Jingle.builder(this.connection());
        builder.setInitiator((h)object).setSessionId((String)object2).setAction(JingleAction.transport_info);
        object = JingleContent.getBuilder();
        object.setName(string).setCreator(creator).setSenders(senders);
        object2 = JingleS5BTransport.getBuilder();
        ((JingleS5BTransport.Builder)object2).setStreamId(string2).setCandidateActivated(string3);
        object = builder.addJingleContent(object.setTransport(((JingleS5BTransport.Builder)object2).build()).build()).build();
        object.setFrom((i)this.getConnection().getUser().u());
        object.setTo((i)h2);
        return object;
    }

    public static void setUseLocalCandidates(boolean bl) {
        useLocalCandidates = bl;
    }

    public static void setUseExternalCandidates(boolean bl) {
        useExternalCandidates = bl;
    }

    public static boolean isUseLocalCandidates() {
        return useLocalCandidates;
    }

    public static boolean isUseExternalCandidates() {
        return useExternalCandidates;
    }
}

