/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Date;
import org.e.a.a.d;
import org.e.a.e;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.packet.MUCInitialPresence;

public final class MucEnterConfiguration {
    private final org.e.a.b.d nickname;
    private final String password;
    private final int maxChars;
    private final int maxStanzas;
    private final int seconds;
    private final Date since;
    private final long timeout;
    private final Presence joinPresence;

    MucEnterConfiguration(Builder builder) {
        this.nickname = builder.nickname;
        this.password = builder.password;
        this.maxChars = builder.maxChars;
        this.maxStanzas = builder.maxStanzas;
        this.seconds = builder.seconds;
        this.since = builder.since;
        this.timeout = builder.timeout;
        builder = builder.joinPresence == null ? builder.joinPresenceBuilder.ofType(Presence.Type.available) : builder.joinPresence.asBuilder();
        builder.addExtension(new MUCInitialPresence(this.password, this.maxChars, this.maxStanzas, this.seconds, this.since));
        this.joinPresence = builder.build();
    }

    final Presence getJoinPresence(MultiUserChat multiUserChat) {
        multiUserChat = d.b((e)multiUserChat.getRoom(), (org.e.a.b.d)this.nickname);
        this.joinPresence.setTo((i)multiUserChat);
        return this.joinPresence;
    }

    final long getTimeout() {
        return this.timeout;
    }

    public static final class Builder {
        private final org.e.a.b.d nickname;
        private String password;
        private int maxChars = -1;
        private int maxStanzas = -1;
        private int seconds = -1;
        private Date since;
        private long timeout;
        private final PresenceBuilder joinPresenceBuilder;
        private Presence joinPresence;

        Builder(org.e.a.b.d d2, XMPPConnection xMPPConnection) {
            this.nickname = (org.e.a.b.d)Objects.requireNonNull((Object)d2, (String)"Nickname must not be null");
            this.timeout = xMPPConnection.getReplyTimeout();
            Builder builder = this;
            builder.timeoutAfter(builder.timeout);
            this.joinPresenceBuilder = xMPPConnection.getStanzaFactory().buildPresenceStanza();
        }

        @Deprecated
        public final Builder withPresence(Presence presence) {
            if (presence.getType() != Presence.Type.available) {
                throw new IllegalArgumentException("Presence must be of type 'available'");
            }
            this.joinPresence = presence;
            return this;
        }

        public final Builder withPresence(Consumer<? super PresenceBuilder> consumer) {
            consumer.accept((Object)this.joinPresenceBuilder);
            if (this.joinPresenceBuilder.getType() != Presence.Type.available) {
                throw new IllegalArgumentException("Presence must be of type 'available'");
            }
            return this;
        }

        public final Builder withPassword(String string) {
            this.password = string;
            return this;
        }

        public final Builder timeoutAfter(long l) {
            if (l <= 0L) {
                throw new IllegalArgumentException("timeout must be positive");
            }
            this.timeout = l;
            return this;
        }

        public final Builder requestNoHistory() {
            this.maxChars = 0;
            this.maxStanzas = -1;
            this.seconds = -1;
            this.since = null;
            return this;
        }

        public final Builder requestMaxCharsHistory(int n) {
            this.maxChars = n;
            return this;
        }

        public final Builder requestMaxStanzasHistory(int n) {
            this.maxStanzas = n;
            return this;
        }

        public final Builder requestHistorySince(int n) {
            this.seconds = n;
            return this;
        }

        public final Builder requestHistorySince(Date date) {
            this.since = date;
            return this;
        }

        public final MucEnterConfiguration build() {
            return new MucEnterConfiguration(this);
        }
    }
}

