/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.e.a.b;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.muc.MultiUserChat;

public abstract class MultiUserChatException
extends SmackException {
    private static final long serialVersionUID = 1L;

    protected MultiUserChatException() {
    }

    protected MultiUserChatException(String string) {
        super(string);
    }

    public static class NotAMucServiceException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        NotAMucServiceException(b b2) {
            super("Can't perform operation because " + b2 + " does not provide a MUC (XEP-45) service.");
        }

        NotAMucServiceException(MultiUserChat multiUserChat) {
            super("Can not join '" + multiUserChat.getRoom() + "', because '" + multiUserChat.getRoom().v() + "' does not provide a MUC (XEP-45) service.");
        }
    }

    public static class MucConfigurationNotSupportedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        public MucConfigurationNotSupportedException(String string) {
            super("The MUC configuration '" + string + "' is not supported by the MUC service");
        }
    }

    public static class MissingMucCreationAcknowledgeException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;
    }

    public static class MucNotJoinedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        public MucNotJoinedException(MultiUserChat multiUserChat) {
            super("Client not currently joined " + multiUserChat.getRoom());
        }
    }

    public static class MucAlreadyJoinedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;
    }
}

