/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CleaningWeakReferenceMap;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.AutoJoinFailedCallback;
import org.jivesoftware.smackx.muc.AutoJoinSuccessCallback;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MucMessageInterceptor;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.packet.MUCUser;

public final class MultiUserChatManager
extends Manager {
    private static final String DISCO_NODE = "http://jabber.org/protocol/muc#rooms";
    private static final Logger LOGGER = Logger.getLogger(MultiUserChatManager.class.getName());
    private static final Map<XMPPConnection, MultiUserChatManager> INSTANCES;
    private static final StanzaFilter INVITATION_FILTER;
    private static final org.e.c.a.b<b, DiscoverInfo> KNOWN_MUC_SERVICES;
    private static final Set<MucMessageInterceptor> DEFAULT_MESSAGE_INTERCEPTORS;
    private final Set<InvitationListener> invitationsListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Set<e> joinedRooms = new CopyOnWriteArraySet<e>();
    private final Map<e, WeakReference<MultiUserChat>> multiUserChats = new CleaningWeakReferenceMap();
    private boolean autoJoinOnReconnect;
    private AutoJoinFailedCallback autoJoinFailedCallback;
    private AutoJoinSuccessCallback autoJoinSuccessCallback;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized MultiUserChatManager getInstanceFor(XMPPConnection xMPPConnection) {
        MultiUserChatManager multiUserChatManager = INSTANCES.get(xMPPConnection);
        if (multiUserChatManager == null) {
            multiUserChatManager = new MultiUserChatManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, multiUserChatManager);
        }
        return multiUserChatManager;
    }

    private MultiUserChatManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Object object = MUCUser.from(stanza = (Message)stanza);
                if (((MUCUser)object).getInvite() != null) {
                    Object object2 = stanza.getFrom().o();
                    if (object2 == null) {
                        LOGGER.warning("Invite to non bare JID: '" + stanza.toXML() + "'");
                        return;
                    }
                    object2 = MultiUserChatManager.this.getMultiUserChat((e)object2);
                    XMPPConnection xMPPConnection = MultiUserChatManager.this.connection();
                    MUCUser.Invite invite = ((MUCUser)object).getInvite();
                    g g2 = invite.getFrom();
                    String string = invite.getReason();
                    object = ((MUCUser)object).getPassword();
                    for (InvitationListener invitationListener : MultiUserChatManager.this.invitationsListeners) {
                        invitationListener.invitationReceived(xMPPConnection, (MultiUserChat)object2, g2, string, (String)object, (Message)stanza, invite);
                    }
                }
            }
        };
        xMPPConnection.addAsyncStanzaListener(stanzaListener, INVITATION_FILTER);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection object, boolean bl) {
                if (bl) {
                    return;
                }
                if (!MultiUserChatManager.this.autoJoinOnReconnect) {
                    return;
                }
                object = MultiUserChatManager.this.getJoinedRooms();
                if (object.isEmpty()) {
                    return;
                }
                Async.go((Runnable)new Runnable((Set)object){
                    final /* synthetic */ Set val$mucs;
                    {
                        this.val$mucs = set;
                    }

                    @Override
                    public void run() {
                        AutoJoinFailedCallback autoJoinFailedCallback = MultiUserChatManager.this.autoJoinFailedCallback;
                        AutoJoinSuccessCallback autoJoinSuccessCallback = MultiUserChatManager.this.autoJoinSuccessCallback;
                        for (Object object : this.val$mucs) {
                            if (!((MultiUserChat)(object = MultiUserChatManager.this.getMultiUserChat((e)object))).isJoined()) {
                                return;
                            }
                            d d2 = ((MultiUserChat)object).getNickname();
                            if (d2 == null) {
                                return;
                            }
                            try {
                                ((MultiUserChat)object).leave();
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException object2) {
                                if (autoJoinFailedCallback != null) {
                                    autoJoinFailedCallback.autoJoinFailed((MultiUserChat)object, (Exception)object2);
                                    return;
                                }
                                LOGGER.log(Level.WARNING, "Could not leave room", (Throwable)object2);
                                return;
                            }
                            try {
                                ((MultiUserChat)object).join(d2);
                                if (autoJoinSuccessCallback == null) continue;
                                autoJoinSuccessCallback.autoJoinSuccess((MultiUserChat)object, d2);
                            }
                            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException object3) {
                                if (autoJoinFailedCallback != null) {
                                    autoJoinFailedCallback.autoJoinFailed((MultiUserChat)object, (Exception)object3);
                                    return;
                                }
                                LOGGER.log(Level.WARNING, "Could not leave room", (Throwable)object3);
                                return;
                            }
                        }
                    }
                });
            }
        });
    }

    public final synchronized MultiUserChat getMultiUserChat(e e2) {
        WeakReference<MultiUserChat> weakReference = this.multiUserChats.get(e2);
        if (weakReference == null) {
            return this.createNewMucAndAddToMap(e2);
        }
        if ((weakReference = (MultiUserChat)weakReference.get()) == null) {
            return this.createNewMucAndAddToMap(e2);
        }
        return weakReference;
    }

    public static boolean addDefaultMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.add(mucMessageInterceptor);
        }
    }

    public static boolean removeDefaultMessageInterceptor(MucMessageInterceptor mucMessageInterceptor) {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return DEFAULT_MESSAGE_INTERCEPTORS.remove(mucMessageInterceptor);
        }
    }

    private MultiUserChat createNewMucAndAddToMap(e e2) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection(), e2, this);
        this.multiUserChats.put(e2, new WeakReference<MultiUserChat>(multiUserChat));
        return multiUserChat;
    }

    public final boolean isServiceEnabled(i i2) {
        return this.serviceDiscoveryManager.supportsFeature(i2, "http://jabber.org/protocol/muc");
    }

    public final Set<e> getJoinedRooms() {
        return Collections.unmodifiableSet(this.joinedRooms);
    }

    public final List<e> getJoinedRooms(f object) {
        object = this.serviceDiscoveryManager.discoverItems((i)object, DISCO_NODE);
        object = ((DiscoverItems)((Object)object)).getItems();
        ArrayList<e> arrayList = new ArrayList<e>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)object.next();
            e e2 = item.getEntityID().o();
            if (e2 == null) {
                LOGGER.warning("Not a bare JID: " + item.getEntityID());
                continue;
            }
            arrayList.add(e2);
        }
        return arrayList;
    }

    public final RoomInfo getRoomInfo(e object) {
        object = this.serviceDiscoveryManager.discoverInfo((i)object);
        return new RoomInfo((DiscoverInfo)object);
    }

    public final List<b> getMucServiceDomains() {
        return this.serviceDiscoveryManager.findServices("http://jabber.org/protocol/muc", false, false);
    }

    @Deprecated
    public final List<b> getXMPPServiceDomains() {
        return this.getMucServiceDomains();
    }

    public final boolean providesMucService(b b2) {
        return this.getMucServiceDiscoInfo(b2) != null;
    }

    final DiscoverInfo getMucServiceDiscoInfo(b b2) {
        DiscoverInfo discoverInfo = (DiscoverInfo)KNOWN_MUC_SERVICES.get((Object)b2);
        if (discoverInfo != null) {
            return discoverInfo;
        }
        discoverInfo = this.serviceDiscoveryManager.discoverInfo((i)b2);
        if (!discoverInfo.containsFeature("http://jabber.org/protocol/muc")) {
            return null;
        }
        KNOWN_MUC_SERVICES.put((Object)b2, (Object)discoverInfo);
        return discoverInfo;
    }

    public final Map<e, HostedRoom> getRoomsHostedBy(b object) {
        if (!this.providesMucService((b)object)) {
            throw new MultiUserChatException.NotAMucServiceException((b)object);
        }
        object = this.serviceDiscoveryManager.discoverItems((i)object);
        object = ((DiscoverItems)((Object)object)).getItems();
        HashMap<e, HostedRoom> hashMap = new HashMap<e, HostedRoom>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (DiscoverItems.Item)object.next();
            object2 = new HostedRoom((DiscoverItems.Item)object2);
            object2 = hashMap.put(((HostedRoom)object2).getJid(), (HostedRoom)object2);
            assert (object2 == null);
        }
        return hashMap;
    }

    public final void decline(e e2, e object, String string) {
        XMPPConnection xMPPConnection = this.connection();
        e2 = (MessageBuilder)xMPPConnection.getStanzaFactory().buildMessageStanza().to((i)e2);
        MUCUser mUCUser = new MUCUser();
        object = new MUCUser.Decline(string, (e)object);
        mUCUser.setDecline((MUCUser.Decline)object);
        e2.addExtension((ExtensionElement)mUCUser);
        xMPPConnection.sendStanza((Stanza)e2.build());
    }

    public final void addInvitationListener(InvitationListener invitationListener) {
        this.invitationsListeners.add(invitationListener);
    }

    public final void removeInvitationListener(InvitationListener invitationListener) {
        this.invitationsListeners.remove(invitationListener);
    }

    public final void setAutoJoinOnReconnect(boolean bl) {
        this.autoJoinOnReconnect = bl;
    }

    public final void setAutoJoinFailedCallback(AutoJoinFailedCallback autoJoinFailedCallback) {
        this.autoJoinFailedCallback = autoJoinFailedCallback;
        if (autoJoinFailedCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    public final void setAutoJoinSuccessCallback(AutoJoinSuccessCallback autoJoinSuccessCallback) {
        this.autoJoinSuccessCallback = autoJoinSuccessCallback;
        if (autoJoinSuccessCallback != null) {
            this.setAutoJoinOnReconnect(true);
        }
    }

    final void addJoinedRoom(e e2) {
        this.joinedRooms.add(e2);
    }

    final void removeJoinedRoom(e e2) {
        this.joinedRooms.remove(e2);
    }

    static CopyOnWriteArrayList<MucMessageInterceptor> getMessageInterceptors() {
        Set<MucMessageInterceptor> set = DEFAULT_MESSAGE_INTERCEPTORS;
        synchronized (set) {
            return new CopyOnWriteArrayList<MucMessageInterceptor>(DEFAULT_MESSAGE_INTERCEPTORS);
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature("http://jabber.org/protocol/muc");
                final WeakReference<XMPPConnection> weakReference = new WeakReference<XMPPConnection>(xMPPConnection);
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).setNodeInformationProvider(MultiUserChatManager.DISCO_NODE, new AbstractNodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        Object object = (XMPPConnection)weakReference.get();
                        if (object == null) {
                            return Collections.emptyList();
                        }
                        object = MultiUserChatManager.getInstanceFor((XMPPConnection)object).getJoinedRooms();
                        ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                        object = object.iterator();
                        while (object.hasNext()) {
                            e e2 = (e)object.next();
                            arrayList.add(new DiscoverItems.Item((i)e2));
                        }
                        return arrayList;
                    }
                });
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatManager>();
        INVITATION_FILTER = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter((ExtensionElement)new MUCUser()), new NotFilter(MessageTypeFilter.ERROR)});
        KNOWN_MUC_SERVICES = new org.e.c.a.b(100, 86400000L);
        DEFAULT_MESSAGE_INTERCEPTORS = new HashSet<MucMessageInterceptor>();
    }
}

