/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.e.a.a;
import org.e.a.a.d;
import org.e.a.b;
import org.e.a.i;
import org.e.b.c;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class PubSubManager
extends Manager {
    public static final String PLUS_NOTIFY = "+notify";
    public static final String AUTO_CREATE_FEATURE = "http://jabber.org/protocol/pubsub#auto-create";
    private static final Logger LOGGER = Logger.getLogger(PubSubManager.class.getName());
    private static final Map<XMPPConnection, Map<a, PubSubManager>> INSTANCES = new WeakHashMap<XMPPConnection, Map<a, PubSubManager>>();
    private final a pubSubService;
    private final Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public static PubSubManager getInstanceFor(XMPPConnection xMPPConnection) {
        b b2 = null;
        if (xMPPConnection.isAuthenticated()) {
            try {
                b2 = PubSubManager.getPubSubService(xMPPConnection);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not determine PubSub service", throwable);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "Interrupted while trying to determine PubSub service", interruptedException);
            }
        }
        if (b2 == null) {
            try {
                b2 = d.f((String)("pubsub." + xMPPConnection.getXMPPServiceDomain()));
            }
            catch (c c2) {
                throw new RuntimeException(c2);
            }
        }
        return PubSubManager.getInstanceFor(xMPPConnection, (a)b2);
    }

    public static PubSubManager getInstanceFor(XMPPConnection xMPPConnection, a a2) {
        PubSubManager pubSubManager;
        Map<a, PubSubManager> map;
        if (a2 != null && xMPPConnection.isAuthenticated() && xMPPConnection.getUser().n().a((CharSequence)a2)) {
            a2 = null;
        }
        Map<Object, Object> map2 = INSTANCES;
        synchronized (map2) {
            map = INSTANCES.get(xMPPConnection);
            if (map == null) {
                map = new HashMap<a, PubSubManager>();
                INSTANCES.put(xMPPConnection, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            pubSubManager = map.get(a2);
            if (pubSubManager == null) {
                pubSubManager = new PubSubManager(xMPPConnection, a2);
                map.put(a2, pubSubManager);
            }
        }
        return pubSubManager;
    }

    @Deprecated
    public static PubSubManager getInstance(XMPPConnection xMPPConnection) {
        return PubSubManager.getInstanceFor(xMPPConnection);
    }

    @Deprecated
    public static PubSubManager getInstance(XMPPConnection xMPPConnection, a a2) {
        return PubSubManager.getInstanceFor(xMPPConnection, a2);
    }

    PubSubManager(XMPPConnection xMPPConnection, a a2) {
        super(xMPPConnection);
        this.pubSubService = a2;
    }

    private void checkIfXmppErrorBecauseOfNotLeafNode(String string, XMPPException.XMPPErrorException xMPPErrorException) {
        StanzaError.Condition condition = xMPPErrorException.getStanzaError().getCondition();
        if (condition == StanzaError.Condition.feature_not_implemented) {
            throw new PubSubException.NotALeafNodeException(string, this.pubSubService);
        }
        throw xMPPErrorException;
    }

    public final LeafNode createNode() {
        Object object = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        QName qName = new QName(PubSubNamespace.basic.getXmlns(), "create");
        object = (NodeExtension)object.getExtension(qName);
        object = new LeafNode(this, ((NodeExtension)object).getNode());
        this.nodeMap.put(((Node)object).getId(), (Node)object);
        return object;
    }

    public final LeafNode createNode(String string) {
        return (LeafNode)this.createNode(string, null);
    }

    public final Node createNode(String string, FillableConfigureForm object) {
        PubSub pubSub = PubSub.createPubsubPacket((i)this.pubSubService, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, string));
        boolean bl = true;
        if (object != null) {
            DataForm dataForm = object.getDataFormToSubmit();
            pubSub.addExtension(new FormNode(FormNodeType.CONFIGURE, dataForm));
            object = object.getNodeType();
            bl = object == null || object == NodeType.leaf;
        }
        this.sendPubsubPacket(pubSub);
        Node node = bl ? new LeafNode(this, string) : new CollectionNode(this, string);
        this.nodeMap.put(node.getId(), node);
        return node;
    }

    public final Node getNode(String string) {
        StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"The node ID can not be null or the empty string");
        Object object = this.nodeMap.get(string);
        if (object == null) {
            object = this.connection();
            DiscoverInfo discoverInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder((XMPPConnection)object).to((i)this.pubSubService)).setNode(string).build();
            if (((DiscoverInfo)(object = (DiscoverInfo)object.createStanzaCollectorAndSend((IQ)discoverInfo).nextResultOrThrow())).hasIdentity("pubsub", "leaf")) {
                object = new LeafNode(this, string);
            } else if (((DiscoverInfo)object).hasIdentity("pubsub", "collection")) {
                object = new CollectionNode(this, string);
            } else {
                throw new PubSubException.NotAPubSubNodeException(string, (DiscoverInfo)object);
            }
            this.nodeMap.put(string, (Node)object);
        }
        return object;
    }

    public final LeafNode getOrCreateLeafNode(String string) {
        try {
            return this.getLeafNode(string);
        }
        catch (PubSubException.NotAPubSubNodeException notAPubSubNodeException) {
            return this.createNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            XMPPException.XMPPErrorException xMPPErrorException2 = xMPPErrorException;
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                try {
                    return this.createNode(string);
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException3) {
                    xMPPErrorException2 = xMPPErrorException3;
                    if (xMPPErrorException3.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                        try {
                            return this.getLeafNode(string);
                        }
                        catch (PubSubException.NotAPubSubNodeException notAPubSubNodeException) {
                            throw new IllegalStateException((Throwable)((Object)notAPubSubNodeException));
                        }
                    }
                    throw xMPPErrorException2;
                }
            }
            if (xMPPErrorException2.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                LOGGER.warning("The PubSub service " + this.pubSubService + " threw an DiscoInfoNodeAssertionError, trying workaround for Prosody bug #805 (https://prosody.im/issues/issue/805)");
                return this.getOrCreateLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException2;
        }
    }

    public final LeafNode getLeafNode(String string) {
        Node node;
        try {
            node = this.getNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            XMPPException.XMPPErrorException xMPPErrorException2 = xMPPErrorException;
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return this.getLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException2;
        }
        if (node instanceof LeafNode) {
            return (LeafNode)node;
        }
        throw new PubSubException.NotALeafNodeException(string, this.pubSubService);
    }

    private LeafNode getLeafNodeProsodyWorkaround(String string) {
        LeafNode leafNode = new LeafNode(this, string);
        try {
            leafNode.getItems(1);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(string, xMPPErrorException);
        }
        this.nodeMap.put(string, leafNode);
        return leafNode;
    }

    private LeafNode getOrCreateLeafNodeProsodyWorkaround(String string) {
        try {
            return this.createNode(string);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            XMPPException.XMPPErrorException xMPPErrorException2 = xMPPErrorException;
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                return this.getLeafNodeProsodyWorkaround(string);
            }
            throw xMPPErrorException2;
        }
    }

    public final <I extends Item> LeafNode tryToPublishAndPossibleAutoCreate(String string, I i2) {
        LeafNode leafNode = new LeafNode(this, string);
        try {
            leafNode.publish(i2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(string, xMPPErrorException);
        }
        this.nodeMap.put(string, leafNode);
        return leafNode;
    }

    public final DiscoverItems discoverNodes(String object) {
        DiscoverItems discoverItems = new DiscoverItems();
        if (object != null) {
            discoverItems.setNode((String)object);
        }
        discoverItems.setTo((i)this.pubSubService);
        object = (DiscoverItems)this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
        return object;
    }

    public final List<Subscription> getSubscriptions() {
        Object object = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        object = (SubscriptionsExtension)object.getExtensionElement(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return ((SubscriptionsExtension)object).getSubscriptions();
    }

    public final List<Affiliation> getAffiliations() {
        Object object = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        object = (AffiliationsExtension)object.getExtension(PubSubElementType.AFFILIATIONS);
        return ((AffiliationsExtension)object).getAffiliations();
    }

    public final boolean deleteNode(String string) {
        boolean bl = true;
        try {
            this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, string), PubSubElementType.DELETE.getNamespace());
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            XMPPException.XMPPErrorException xMPPErrorException2 = xMPPErrorException;
            if (xMPPErrorException.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                bl = false;
            }
            throw xMPPErrorException2;
        }
        this.nodeMap.remove(string);
        return bl;
    }

    public final ConfigureForm getDefaultConfiguration() {
        PubSub pubSub = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket((Stanza)pubSub, PubSubElementType.DEFAULT);
    }

    public final a getServiceJid() {
        return this.pubSubService;
    }

    public final DiscoverInfo getSupportedFeatures() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return serviceDiscoveryManager.discoverInfo((i)this.pubSubService);
    }

    public final boolean supportsAutomaticNodeCreation() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return serviceDiscoveryManager.supportsFeature((i)this.pubSubService, AUTO_CREATE_FEATURE);
    }

    public final boolean canCreateNodesAndPublishItems() {
        block5: {
            try {
                LeafNode leafNode = this.createNode();
                if (leafNode == null) break block5;
                this.deleteNode(leafNode.getId());
            }
            catch (XMPPException.XMPPErrorException xMPPErrorException) {
                XMPPException.XMPPErrorException xMPPErrorException2;
                block6: {
                    xMPPErrorException2 = xMPPErrorException;
                    if (xMPPErrorException.getStanzaError().getCondition() != StanzaError.Condition.forbidden) break block6;
                    return false;
                }
                throw xMPPErrorException2;
            }
        }
        return true;
    }

    private PubSub sendPubsubPacket(IQ.Type type, ExtensionElement extensionElement, PubSubNamespace pubSubNamespace) {
        PubSubManager pubSubManager = this;
        return pubSubManager.sendPubsubPacket((i)pubSubManager.pubSubService, type, Collections.singletonList(extensionElement), pubSubNamespace);
    }

    final XMPPConnection getConnection() {
        return this.connection();
    }

    final PubSub sendPubsubPacket(i object, IQ.Type object2, List<ExtensionElement> extensionElement2, PubSubNamespace pubSubNamespace) {
        object = new PubSub((i)object, (IQ.Type)object2, pubSubNamespace);
        for (ExtensionElement extensionElement2 : extensionElement2) {
            object.addExtension(extensionElement2);
        }
        return this.sendPubsubPacket((PubSub)((Object)object));
    }

    final PubSub sendPubsubPacket(PubSub pubSub) {
        pubSub = (IQ)this.connection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
        if (pubSub instanceof EmptyResultIQ) {
            return null;
        }
        return pubSub;
    }

    public static b getPubSubService(XMPPConnection xMPPConnection) {
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).findService("http://jabber.org/protocol/pubsub", true, "pubsub", "service");
    }
}

