/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.IntPriorityQueue;
import io.netty.buffer.LongLongHashMap;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int SIZE_BIT_LENGTH = 15;
    private static final int INUSED_BIT_LENGTH = 1;
    private static final int SUBPAGE_BIT_LENGTH = 1;
    private static final int BITMAP_IDX_BIT_LENGTH = 32;
    static final int IS_SUBPAGE_SHIFT = 32;
    static final int IS_USED_SHIFT = 33;
    static final int SIZE_SHIFT = 34;
    static final int RUN_OFFSET_SHIFT = 49;
    final PoolArena<T> arena;
    final Object base;
    final T memory;
    final boolean unpooled;
    private final LongLongHashMap runsAvailMap;
    private final IntPriorityQueue[] runsAvail;
    private final ReentrantLock runsAvailLock;
    private final PoolSubpage<T>[] subpages;
    private final LongCounter pinnedBytes = PlatformDependent.newLongCounter();
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int maxPageIdx;
    private final Deque<ByteBuffer> cachedNioBuffers;
    int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> poolArena, Object object, T t, int n, int n2, int n3, int n4) {
        this.unpooled = false;
        this.arena = poolArena;
        this.base = object;
        this.memory = t;
        this.pageSize = n;
        this.pageShifts = n2;
        this.chunkSize = n3;
        this.maxPageIdx = n4;
        this.freeBytes = n3;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(n4);
        this.runsAvailLock = new ReentrantLock();
        this.runsAvailMap = new LongLongHashMap(-1L);
        this.subpages = new PoolSubpage[n3 >> n2];
        int n5 = n3 >> n2;
        long l = (long)n5 << 34;
        this.insertAvailRun(0, n5, l);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    PoolChunk(PoolArena<T> poolArena, Object object, T t, int n) {
        this.unpooled = true;
        this.arena = poolArena;
        this.base = object;
        this.memory = t;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.maxPageIdx = 0;
        this.runsAvailMap = null;
        this.runsAvail = null;
        this.runsAvailLock = null;
        this.subpages = null;
        this.chunkSize = n;
        this.cachedNioBuffers = null;
    }

    private static IntPriorityQueue[] newRunsAvailqueueArray(int n) {
        IntPriorityQueue[] intPriorityQueueArray = new IntPriorityQueue[n];
        for (int i = 0; i < intPriorityQueueArray.length; ++i) {
            intPriorityQueueArray[i] = new IntPriorityQueue();
        }
        return intPriorityQueueArray;
    }

    private void insertAvailRun(int n, int n2, long l) {
        int n3 = this.arena.sizeClass.pages2pageIdxFloor(n2);
        IntPriorityQueue intPriorityQueue = this.runsAvail[n3];
        assert (PoolChunk.isRun(l));
        intPriorityQueue.offer((int)(l >> 32));
        this.insertAvailRun0(n, l);
        if (n2 > 1) {
            this.insertAvailRun0(PoolChunk.lastPage(n, n2), l);
        }
    }

    private void insertAvailRun0(int n, long l) {
        long l2 = this.runsAvailMap.put(n, l);
        assert (l2 == -1L);
    }

    private void removeAvailRun(long l) {
        int n = this.arena.sizeClass.pages2pageIdxFloor(PoolChunk.runPages(l));
        this.runsAvail[n].remove((int)(l >> 32));
        this.removeAvailRun0(l);
    }

    private void removeAvailRun0(long l) {
        int n = PoolChunk.runOffset(l);
        int n2 = PoolChunk.runPages(l);
        this.runsAvailMap.remove(n);
        if (n2 > 1) {
            this.runsAvailMap.remove(PoolChunk.lastPage(n, n2));
        }
    }

    private static int lastPage(int n, int n2) {
        return n + n2 - 1;
    }

    private long getAvailRunByOffset(int n) {
        return this.runsAvailMap.get(n);
    }

    @Override
    public final int usage() {
        int n;
        if (this.unpooled) {
            n = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                n = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return this.usage(n);
    }

    private int usage(int n) {
        if (n == 0) {
            return 100;
        }
        if ((n = (int)((long)n * 100L / (long)this.chunkSize)) == 0) {
            return 99;
        }
        return 100 - n;
    }

    final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n, int n2, PoolThreadCache poolThreadCache) {
        long l;
        block14: {
            if (n2 <= this.arena.sizeClass.smallMaxSizeIdx) {
                PoolSubpage poolSubpage = this.arena.smallSubpagePools[n2];
                poolSubpage.lock();
                try {
                    PoolSubpage poolSubpage2 = poolSubpage.next;
                    if (poolSubpage2 != poolSubpage) {
                        assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == this.arena.sizeClass.sizeIdx2size(n2)) : "doNotDestroy=" + poolSubpage2.doNotDestroy + ", elemSize=" + poolSubpage2.elemSize + ", sizeIdx=" + n2;
                        long l2 = poolSubpage2.allocate();
                        assert (l2 >= 0L);
                        assert (PoolChunk.isSubpage(l2));
                        poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l2, n, poolThreadCache);
                        return true;
                    }
                    l = this.allocateSubpage(n2, poolSubpage);
                    if (l < 0L) {
                        return false;
                    }
                    assert (PoolChunk.isSubpage(l));
                    break block14;
                }
                finally {
                    poolSubpage.unlock();
                }
            }
            int n3 = this.arena.sizeClass.sizeIdx2size(n2);
            l = this.allocateRun(n3);
            if (l < 0L) {
                return false;
            }
            assert (!PoolChunk.isSubpage(l));
        }
        ByteBuffer byteBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf(pooledByteBuf, byteBuffer, l, n, poolThreadCache);
        return true;
    }

    private long allocateRun(int n) {
        int n2 = this.arena.sizeClass.pages2pageIdx(n >>= this.pageShifts);
        this.runsAvailLock.lock();
        try {
            n2 = this.runFirstBestFit(n2);
            if (n2 == -1) {
                return -1L;
            }
            IntPriorityQueue intPriorityQueue = this.runsAvail[n2];
            long l = intPriorityQueue.poll();
            assert (l != -1L);
            assert (!PoolChunk.isUsed(l <<= 32)) : "invalid handle: " + l;
            this.removeAvailRun0(l);
            l = this.splitLargeRun(l, n);
            n = PoolChunk.runSize(this.pageShifts, l);
            this.freeBytes -= n;
            return l;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    private int calculateRunSize(int n) {
        int n2 = 1 << this.pageShifts - 4;
        int n3 = 0;
        int n4 = this.arena.sizeClass.sizeIdx2size(n);
        while ((n = (n3 += this.pageSize) / n4) < n2 && n3 != n * n4) {
        }
        while (n > n2) {
            n = (n3 -= this.pageSize) / n4;
        }
        assert (n > 0);
        assert (n3 <= this.chunkSize);
        assert (n3 >= n4);
        return n3;
    }

    private int runFirstBestFit(int n) {
        if (this.freeBytes == this.chunkSize) {
            return this.arena.sizeClass.nPSizes - 1;
        }
        while (n < this.arena.sizeClass.nPSizes) {
            IntPriorityQueue intPriorityQueue = this.runsAvail[n];
            if (intPriorityQueue != null && !intPriorityQueue.isEmpty()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private long splitLargeRun(long l, int n) {
        assert (n > 0);
        int n2 = PoolChunk.runPages(l);
        assert (n <= n2);
        if ((n2 -= n) > 0) {
            int n3 = PoolChunk.runOffset(l);
            int n4 = n3 + n;
            long l2 = PoolChunk.toRunHandle(n4, n2, 0);
            this.insertAvailRun(n4, n2, l2);
            return PoolChunk.toRunHandle(n3, n, 1);
        }
        return l |= 0x200000000L;
    }

    private long allocateSubpage(int n, PoolSubpage<T> poolSubpage) {
        int n2 = this.calculateRunSize(n);
        long l = this.allocateRun(n2);
        if (l < 0L) {
            return -1L;
        }
        n2 = PoolChunk.runOffset(l);
        assert (this.subpages[n2] == null);
        n = this.arena.sizeClass.sizeIdx2size(n);
        PoolChunk poolChunk = this;
        PoolSubpage<T> poolSubpage2 = new PoolSubpage<T>(poolSubpage, poolChunk, poolChunk.pageShifts, n2, PoolChunk.runSize(this.pageShifts, l), n);
        this.subpages[n2] = poolSubpage2;
        return poolSubpage2.allocate();
    }

    final void free(long l, int n, ByteBuffer byteBuffer) {
        if (PoolChunk.isSubpage(l)) {
            n = PoolChunk.runOffset(l);
            PoolSubpage poolSubpage = this.subpages[n];
            assert (poolSubpage != null);
            PoolSubpage poolSubpage2 = poolSubpage.chunk.arena.smallSubpagePools[poolSubpage.headIndex];
            poolSubpage2.lock();
            try {
                assert (poolSubpage.doNotDestroy);
                if (poolSubpage.free(poolSubpage2, PoolChunk.bitmapIdx(l))) {
                    return;
                }
                assert (!poolSubpage.doNotDestroy);
                this.subpages[n] = null;
            }
            finally {
                poolSubpage2.unlock();
            }
        }
        n = PoolChunk.runSize(this.pageShifts, l);
        this.runsAvailLock.lock();
        try {
            long l2 = this.collapseRuns(l);
            l2 &= 0xFFFFFFFDFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(l2 &= 0xFFFFFFFEFFFFFFFFL), PoolChunk.runPages(l2), l2);
            this.freeBytes += n;
        }
        finally {
            this.runsAvailLock.unlock();
        }
        if (byteBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
            this.cachedNioBuffers.offer(byteBuffer);
        }
    }

    private long collapseRuns(long l) {
        PoolChunk poolChunk = this;
        return poolChunk.collapseNext(poolChunk.collapsePast(l));
    }

    private long collapsePast(long l) {
        while (true) {
            int n = PoolChunk.runOffset(l);
            int n2 = PoolChunk.runPages(l);
            long l2 = this.getAvailRunByOffset(n - 1);
            if (l2 == -1L) {
                return l;
            }
            int n3 = PoolChunk.runOffset(l2);
            int n4 = PoolChunk.runPages(l2);
            if (l2 == l || n3 + n4 != n) break;
            this.removeAvailRun(l2);
            l = PoolChunk.toRunHandle(n3, n4 + n2, 0);
        }
        return l;
    }

    private long collapseNext(long l) {
        while (true) {
            int n;
            int n2;
            long l2;
            if ((l2 = this.getAvailRunByOffset((n2 = PoolChunk.runOffset(l)) + (n = PoolChunk.runPages(l)))) == -1L) {
                return l;
            }
            int n3 = PoolChunk.runOffset(l2);
            int n4 = PoolChunk.runPages(l2);
            if (l2 == l || n2 + n != n3) break;
            this.removeAvailRun(l2);
            l = PoolChunk.toRunHandle(n2, n + n4, 0);
        }
        return l;
    }

    private static long toRunHandle(int n, int n2, int n3) {
        return (long)n << 49 | (long)n2 << 34 | (long)n3 << 33;
    }

    final void initBuf(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l, int n, PoolThreadCache poolThreadCache) {
        if (PoolChunk.isSubpage(l)) {
            this.initBufWithSubpage(pooledByteBuf, byteBuffer, l, n, poolThreadCache);
            return;
        }
        int n2 = PoolChunk.runSize(this.pageShifts, l);
        long l2 = l;
        pooledByteBuf.init(this, byteBuffer, l2, PoolChunk.runOffset(l2) << this.pageShifts, n, n2, this.arena.parent.threadCache());
    }

    final void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l, int n, PoolThreadCache poolThreadCache) {
        int n2 = PoolChunk.runOffset(l);
        int n3 = PoolChunk.bitmapIdx(l);
        PoolSubpage<T> poolSubpage = this.subpages[n2];
        assert (poolSubpage.isDoNotDestroy());
        assert (n <= poolSubpage.elemSize) : n + "<=" + poolSubpage.elemSize;
        n2 = (n2 << this.pageShifts) + n3 * poolSubpage.elemSize;
        pooledByteBuf.init(this, byteBuffer, l, n2, n, poolSubpage.elemSize, poolThreadCache);
    }

    final void incrementPinnedMemory(int n) {
        assert (n > 0);
        this.pinnedBytes.add((long)n);
    }

    final void decrementPinnedMemory(int n) {
        assert (n > 0);
        this.pinnedBytes.add((long)(-n));
    }

    @Override
    public final int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public final int freeBytes() {
        if (this.unpooled) {
            return this.freeBytes;
        }
        this.runsAvailLock.lock();
        try {
            int n = this.freeBytes;
            return n;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    public final int pinnedBytes() {
        return (int)this.pinnedBytes.value();
    }

    public final String toString() {
        int n;
        if (this.unpooled) {
            n = this.freeBytes;
        } else {
            this.runsAvailLock.lock();
            try {
                n = this.freeBytes;
            }
            finally {
                this.runsAvailLock.unlock();
            }
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(n) + "%, " + (this.chunkSize - n) + '/' + this.chunkSize + ')';
    }

    final void destroy() {
        this.arena.destroyChunk(this);
    }

    static int runOffset(long l) {
        return (int)(l >> 49);
    }

    static int runSize(int n, long l) {
        return PoolChunk.runPages(l) << n;
    }

    static int runPages(long l) {
        return (int)(l >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long l) {
        return (l >> 33 & 1L) == 1L;
    }

    static boolean isRun(long l) {
        return !PoolChunk.isSubpage(l);
    }

    static boolean isSubpage(long l) {
        return (l >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long l) {
        return (int)l;
    }
}

