/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.ObjectPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledDirectByteBuf>(){

        public final PooledDirectByteBuf newObject(ObjectPool.Handle<PooledDirectByteBuf> handle) {
            return new PooledDirectByteBuf(handle, 0);
        }
    });

    static PooledDirectByteBuf newInstance(int n) {
        PooledDirectByteBuf pooledDirectByteBuf = (PooledDirectByteBuf)RECYCLER.get();
        pooledDirectByteBuf.reuse(n);
        return pooledDirectByteBuf;
    }

    private PooledDirectByteBuf(ObjectPool.Handle<PooledDirectByteBuf> handle, int n) {
        super(handle, n);
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    protected final byte _getByte(int n) {
        return ((ByteBuffer)this.memory).get(this.idx(n));
    }

    @Override
    protected final short _getShort(int n) {
        return ((ByteBuffer)this.memory).getShort(this.idx(n));
    }

    @Override
    protected final short _getShortLE(int n) {
        return ByteBufUtil.swapShort(this._getShort(n));
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        n = this.idx(n);
        return (((ByteBuffer)this.memory).get(n) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(n + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(n + 2) & 0xFF;
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        n = this.idx(n);
        return ((ByteBuffer)this.memory).get(n) & 0xFF | (((ByteBuffer)this.memory).get(n + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(n + 2) & 0xFF) << 16;
    }

    @Override
    protected final int _getInt(int n) {
        return ((ByteBuffer)this.memory).getInt(this.idx(n));
    }

    @Override
    protected final int _getIntLE(int n) {
        return ByteBufUtil.swapInt(this._getInt(n));
    }

    @Override
    protected final long _getLong(int n) {
        return ((ByteBuffer)this.memory).getLong(this.idx(n));
    }

    @Override
    protected final long _getLongLE(int n) {
        return ByteBufUtil.swapLong(this._getLong(n));
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBufferArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            ((ByteBuf)this).getBytes(n, byteBufferArray.array(), byteBufferArray.arrayOffset() + n2, n3);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n2, n3)) {
                int n4 = byteBuffer.remaining();
                ((ByteBuf)this).getBytes(n, byteBuffer);
                n += n4;
            }
        } else {
            byteBufferArray.setBytes(n2, this, n, n3);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        this._internalNioBuffer(n, n3, true).get(byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n, int n2) {
        this.checkDstIndex(n2, n, byArray.length);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf._internalNioBuffer(pooledDirectByteBuf.readerIndex, n2, false).get(byArray, n, n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        byteBuffer.put(this.duplicateInternalNioBuffer(n, byteBuffer.remaining()));
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.checkReadableBytes(n);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        byteBuffer.put(pooledDirectByteBuf._internalNioBuffer(pooledDirectByteBuf.readerIndex, n, false));
        this.readerIndex += n;
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.getBytes(n, outputStream, n2, false);
        return this;
    }

    private void getBytes(int n, OutputStream outputStream, int n2, boolean bl) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return;
        }
        ByteBufUtil.readBytes(((ByteBuf)this).alloc(), bl ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx(n), n2, outputStream);
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n) {
        this.checkReadableBytes(n);
        PooledDirectByteBuf pooledDirectByteBuf = this;
        pooledDirectByteBuf.getBytes(pooledDirectByteBuf.readerIndex, outputStream, n, true);
        this.readerIndex += n;
        return this;
    }

    @Override
    protected final void _setByte(int n, int n2) {
        ((ByteBuffer)this.memory).put(this.idx(n), (byte)n2);
    }

    @Override
    protected final void _setShort(int n, int n2) {
        ((ByteBuffer)this.memory).putShort(this.idx(n), (short)n2);
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        this._setShort(n, ByteBufUtil.swapShort((short)n2));
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        n = this.idx(n);
        ((ByteBuffer)this.memory).put(n, (byte)(n2 >>> 16));
        ((ByteBuffer)this.memory).put(n + 1, (byte)(n2 >>> 8));
        ((ByteBuffer)this.memory).put(n + 2, (byte)n2);
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        n = this.idx(n);
        ((ByteBuffer)this.memory).put(n, (byte)n2);
        ((ByteBuffer)this.memory).put(n + 1, (byte)(n2 >>> 8));
        ((ByteBuffer)this.memory).put(n + 2, (byte)(n2 >>> 16));
    }

    @Override
    protected final void _setInt(int n, int n2) {
        ((ByteBuffer)this.memory).putInt(this.idx(n), n2);
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        this._setInt(n, ByteBufUtil.swapInt(n2));
    }

    @Override
    protected final void _setLong(int n, long l) {
        ((ByteBuffer)this.memory).putLong(this.idx(n), l);
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        this._setLong(n, ByteBufUtil.swapLong(l));
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBufferArray, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            ((ByteBuf)this).setBytes(n, byteBufferArray.array(), byteBufferArray.arrayOffset() + n2, n3);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n2, n3)) {
                int n4 = byteBuffer.remaining();
                ((ByteBuf)this).setBytes(n, byteBuffer);
                n += n4;
            }
        } else {
            byteBufferArray.getBytes(n2, this, n, n3);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byArray.length);
        this._internalNioBuffer(n, n3, false).put(byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkIndex(n, n2);
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        n = this.idx(n);
        byteBuffer2.limit(n + n2).position(n);
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        byte[] byArray = ByteBufUtil.threadLocalTempArray(n2);
        int n3 = inputStream.read(byArray, 0, n2);
        if (n3 <= 0) {
            return n3;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.position(this.idx(n));
        byteBuffer.put(byArray, 0, n3);
        return n3;
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().directBuffer(n2, ((ByteBuf)this).maxCapacity());
        return byteBuf.writeBytes(this, n, n2);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

