/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBuffer.remaining());
        if (!byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName((Object)byteBuffer));
        }
        this.allocator = byteBufAllocator;
        this.buffer = byteBuffer.slice().order(ByteOrder.BIG_ENDIAN);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        ((ByteBuf)readOnlyByteBufferBuf).writerIndex(readOnlyByteBufferBuf.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int n) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int n, boolean bl) {
        return 1;
    }

    @Override
    public byte getByte(int n) {
        this.ensureAccessible();
        return this._getByte(n);
    }

    @Override
    protected byte _getByte(int n) {
        return this.buffer.get(n);
    }

    @Override
    public short getShort(int n) {
        this.ensureAccessible();
        return this._getShort(n);
    }

    @Override
    protected short _getShort(int n) {
        return this.buffer.getShort(n);
    }

    @Override
    public short getShortLE(int n) {
        this.ensureAccessible();
        return this._getShortLE(n);
    }

    @Override
    protected short _getShortLE(int n) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n));
    }

    @Override
    public int getUnsignedMedium(int n) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n);
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        return (((ByteBuf)this).getByte(n) & 0xFF) << 16 | (((ByteBuf)this).getByte(n + 1) & 0xFF) << 8 | ((ByteBuf)this).getByte(n + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int n) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n);
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        return ((ByteBuf)this).getByte(n) & 0xFF | (((ByteBuf)this).getByte(n + 1) & 0xFF) << 8 | (((ByteBuf)this).getByte(n + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n) {
        this.ensureAccessible();
        return this._getInt(n);
    }

    @Override
    protected int _getInt(int n) {
        return this.buffer.getInt(n);
    }

    @Override
    public int getIntLE(int n) {
        this.ensureAccessible();
        return this._getIntLE(n);
    }

    @Override
    protected int _getIntLE(int n) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n));
    }

    @Override
    public long getLong(int n) {
        this.ensureAccessible();
        return this._getLong(n);
    }

    @Override
    protected long _getLong(int n) {
        return this.buffer.getLong(n);
    }

    @Override
    public long getLongLE(int n) {
        this.ensureAccessible();
        return this._getLongLE(n);
    }

    @Override
    protected long _getLongLE(int n) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n));
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        return this.getBytes(n, byteBuf, n2, n3, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        this.checkReadableBytes(n2);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, byteBuf, n, n2, true);
        this.readerIndex += n2;
        return this;
    }

    protected ByteBuf getBytes(int n, ByteBuf byteBufferArray, int n2, int n3, boolean bl) {
        this.checkDstIndex(n, n3, n2, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            ((ByteBuf)this).getBytes(n, byteBufferArray.array(), byteBufferArray.arrayOffset() + n2, n3);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n2, n3)) {
                int n4 = byteBuffer.remaining();
                this.getBytes(n, byteBuffer, bl);
                n += n4;
            }
        } else {
            byteBufferArray.setBytes(n2, this, n, n3);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        return this.getBytes(n, byArray, n2, n3, false);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n, int n2) {
        this.checkReadableBytes(n2);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, byArray, n, n2, true);
        this.readerIndex += n2;
        return this;
    }

    protected ByteBuf getBytes(int n, byte[] byArray, int n2, int n3, boolean bl) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        ByteBuffer byteBuffer = this.nioBuffer(bl);
        byteBuffer.clear().position(n).limit(n + n3);
        byteBuffer.get(byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        return this.getBytes(n, byteBuffer, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.checkReadableBytes(n);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, byteBuffer, true);
        this.readerIndex += n;
        return this;
    }

    private ByteBuf getBytes(int n, ByteBuffer byteBuffer, boolean bl) {
        this.checkIndex(n, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.nioBuffer(bl);
        byteBuffer2.clear().position(n).limit(n + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
        return this;
    }

    @Override
    public ByteBuf setByte(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShortLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMediumLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setIntLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLongLE(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return ((ByteBuf)this).maxCapacity();
    }

    @Override
    public ByteBuf capacity(int n) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        return this.getBytes(n, outputStream, n2, false);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n) {
        this.checkReadableBytes(n);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, outputStream, n, true);
        this.readerIndex += n;
        return this;
    }

    private ByteBuf getBytes(int n, OutputStream outputStream, int n2, boolean bl) {
        this.ensureAccessible();
        if (n2 == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            outputStream.write(this.buffer.array(), n + this.buffer.arrayOffset(), n2);
        } else {
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n2);
            ByteBuffer byteBuffer = this.nioBuffer(bl);
            byteBuffer.clear().position(n);
            byteBuffer.get(byArray, 0, n2);
            outputStream.write(byArray, 0, n2);
        }
        return this;
    }

    @Override
    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        return this.getBytes(n, gatheringByteChannel, n2, false);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        this.checkReadableBytes(n);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        int n2 = readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, gatheringByteChannel, n, true);
        this.readerIndex += n2;
        return n2;
    }

    private int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2, boolean bl) {
        this.ensureAccessible();
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.nioBuffer(bl);
        byteBuffer.clear().position(n).limit(n + n2);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        return this.getBytes(n, fileChannel, l, n2, false);
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l, int n) {
        this.checkReadableBytes(n);
        ReadOnlyByteBufferBuf readOnlyByteBufferBuf = this;
        int n2 = readOnlyByteBufferBuf.getBytes(readOnlyByteBufferBuf.readerIndex, fileChannel, l, n, true);
        this.readerIndex += n2;
        return n2;
    }

    private int getBytes(int n, FileChannel fileChannel, long l, int n2, boolean bl) {
        this.ensureAccessible();
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.nioBuffer(bl);
        byteBuffer.clear().position(n).limit(n + n2);
        return fileChannel.write(byteBuffer, l);
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n, InputStream inputStream, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuf copy(int n, int n2) {
        ByteBuffer byteBuffer;
        this.ensureAccessible();
        try {
            byteBuffer = (ByteBuffer)this.buffer.duplicate().clear().position(n).limit(n + n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (n + n2));
        }
        ByteBuf byteBuf = byteBuffer.isDirect() ? ((ByteBuf)this).alloc().directBuffer(n2) : ((ByteBuf)this).alloc().heapBuffer(n2);
        byteBuf.writeBytes(byteBuffer);
        return byteBuf;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n, int n2) {
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer(n, n2)};
    }

    @Override
    public ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return (ByteBuffer)this.buffer.duplicate().position(n).limit(n + n2);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n, int n2) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(n).limit(n + n2);
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    private ByteBuffer nioBuffer(boolean bl) {
        if (bl) {
            return this.internalNioBuffer();
        }
        return this.buffer.duplicate();
    }

    @Override
    public ByteBuf duplicate() {
        return new ReadOnlyDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf slice(int n, int n2) {
        return new ReadOnlySlicedByteBuf(this, n, n2);
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    private static final class ReadOnlyDuplicatedByteBuf
    extends DuplicatedByteBuf {
        ReadOnlyDuplicatedByteBuf(ByteBuf byteBuf) {
            super(byteBuf);
        }

        @Override
        public final ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public final ByteBuf slice(int n, int n2) {
            return new ReadOnlySlicedByteBuf(this, n, n2);
        }

        @Override
        public final ByteBuf duplicate() {
            return new ReadOnlyDuplicatedByteBuf(this);
        }

        @Override
        public final boolean isWritable() {
            return false;
        }

        @Override
        public final boolean isWritable(int n) {
            return false;
        }

        @Override
        public final int ensureWritable(int n, boolean bl) {
            return 1;
        }
    }

    private static final class ReadOnlySlicedByteBuf
    extends SlicedByteBuf {
        ReadOnlySlicedByteBuf(ByteBuf byteBuf, int n, int n2) {
            super(byteBuf, n, n2);
        }

        @Override
        public final ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public final ByteBuf slice(int n, int n2) {
            return new ReadOnlySlicedByteBuf(this, n, n2);
        }

        @Override
        public final ByteBuf duplicate() {
            return ((ByteBuf)this).slice(0, ((ByteBuf)this).capacity()).setIndex(((ByteBuf)this).readerIndex(), ((ByteBuf)this).writerIndex());
        }

        @Override
        public final boolean isWritable() {
            return false;
        }

        @Override
        public final boolean isWritable(int n) {
            return false;
        }

        @Override
        public final int ensureWritable(int n, boolean bl) {
            return 1;
        }
    }
}

