/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class NamedConverter
extends ClassicConverter {
    private static final String DISABLE_CACHE_SYSTEM_PROPERTY = "logback.namedConverter.disableCache";
    private static final int INITIAL_CACHE_SIZE = 512;
    private static final double LOAD_FACTOR = 0.75;
    private static final int MAX_ALLOWED_REMOVAL_THRESHOLD = 1536;
    private static final double CACHE_MISSRATE_TRIGGER = 0.3;
    private static final int MIN_SAMPLE_SIZE = 1024;
    private static final double NEGATIVE = -1.0;
    private volatile boolean cacheEnabled = true;
    private final NameCache cache = new NameCache(512);
    private Abbreviator abbreviator = null;
    private volatile int cacheMisses = 0;
    private volatile int totalCalls = 0;

    protected abstract String getFullyQualifiedName(ILoggingEvent var1);

    public void start() {
        String string;
        String string2 = OptionHelper.getSystemProperty((String)DISABLE_CACHE_SYSTEM_PROPERTY);
        boolean bl = OptionHelper.toBoolean((String)string2, (boolean)false);
        if (bl) {
            this.addInfo("Disabling name cache via System.properties");
            this.cacheEnabled = false;
        }
        if ((string = this.getFirstOption()) != null) {
            try {
                int n = Integer.parseInt(string);
                if (n == 0) {
                    this.abbreviator = new ClassNameOnlyAbbreviator();
                } else if (n > 0) {
                    this.abbreviator = new TargetLengthBasedClassNameAbbreviator(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("failed to parse integer string [" + string + "]", numberFormatException);
            }
        }
        super.start();
    }

    public String convert(ILoggingEvent object) {
        object = this.getFullyQualifiedName((ILoggingEvent)object);
        if (this.abbreviator == null) {
            return object;
        }
        if (this.cacheEnabled) {
            return this.viaCache((String)object);
        }
        return this.abbreviator.abbreviate((String)object);
    }

    private synchronized String viaCache(String string) {
        ++this.totalCalls;
        String string2 = (String)this.cache.get(string);
        if (string2 == null) {
            ++this.cacheMisses;
            string2 = this.abbreviator.abbreviate(string);
            this.cache.put(string, string2);
        }
        return string2;
    }

    private void disableCache() {
        if (!this.cacheEnabled) {
            return;
        }
        this.cacheEnabled = false;
        this.cache.clear();
        NamedConverter namedConverter = this;
        namedConverter.addInfo("Disabling cache at totalCalls=" + namedConverter.totalCalls);
    }

    public double getCacheMissRate() {
        return this.cache.cacheMissCalculator.getCacheMissRate();
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    private class NameCache
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1050866539278406045L;
        int removalThreshold;
        CacheMissCalculator cacheMissCalculator;

        NameCache(int n) {
            super(n);
            this.cacheMissCalculator = new CacheMissCalculator();
            this.removalThreshold = (int)((double)n * 0.75);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
            if (this.shouldDoubleRemovalThreshold()) {
                this.removalThreshold <<= 1;
                int n = (int)(this.cacheMissCalculator.getCacheMissRate() * 100.0);
                NamedConverter.this.addInfo("Doubling nameCache removalThreshold to " + this.removalThreshold + " previous cacheMissRate=" + n + "%");
                this.cacheMissCalculator.updateMilestones();
            }
            return this.size() >= this.removalThreshold;
        }

        private boolean shouldDoubleRemovalThreshold() {
            double d;
            double d2 = this.cacheMissCalculator.getCacheMissRate();
            if (d < 0.0) {
                return false;
            }
            if (d2 < 0.3) {
                return false;
            }
            if (this.removalThreshold >= 1536) {
                NamedConverter.this.disableCache();
                return false;
            }
            return true;
        }
    }

    class CacheMissCalculator {
        int totalsMilestone = 0;
        int cacheMissesMilestone = 0;

        CacheMissCalculator() {
        }

        void updateMilestones() {
            this.totalsMilestone = NamedConverter.this.totalCalls;
            this.cacheMissesMilestone = NamedConverter.this.cacheMisses;
        }

        double getCacheMissRate() {
            int n = NamedConverter.this.totalCalls - this.totalsMilestone;
            if (n < 1024) {
                return -1.0;
            }
            int n2 = NamedConverter.this.cacheMisses - this.cacheMissesMilestone;
            return 1.0 * (double)n2 / (double)n;
        }
    }
}

