/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.tyler.TylerConfiguratorBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class VariableModelHelper
extends ContextAwareBase {
    TylerConfiguratorBase tylerConfiguratorBase;
    VariableSubstitutionsHelper variableSubstitutionsHelper;

    VariableModelHelper(Context context, TylerConfiguratorBase tylerConfiguratorBase) {
        super((ContextAware)tylerConfiguratorBase);
        this.context = context;
        this.tylerConfiguratorBase = tylerConfiguratorBase;
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateProperties(PropertyModel object) {
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)object.getScopeStr());
        if (PropertyModelHandlerHelper.checkFileAttributeSanity((PropertyModel)object)) {
            String string = object.getFile();
            string = this.tylerConfiguratorBase.subst(string);
            try {
                object = new FileInputStream(string);
                try {
                    this.loadAndSetProperties((InputStream)object, scope);
                    return;
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string + "].");
                return;
            }
            catch (IOException | IllegalArgumentException exception) {
                this.addError("Could not read properties file [" + string + "].", exception);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkResourceAttributeSanity((PropertyModel)object)) {
            String string = object.getResource();
            object = Loader.getResourceBySelfClassLoader((String)(string = this.tylerConfiguratorBase.subst(string)));
            if (object == null) {
                this.addError("Could not find resource [" + string + "].");
                return;
            }
            try {
                InputStream inputStream = ((URL)object).openStream();
                try {
                    this.loadAndSetProperties(inputStream, scope);
                    return;
                }
                finally {
                    if (inputStream == null) return;
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.addError("Could not read resource file [" + string + "].", iOException);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkValueNameAttributesSanity((PropertyModel)object)) {
            String string = object.getValue();
            string = string.trim();
            string = this.tylerConfiguratorBase.subst(string);
            this.setProperty(object.getName(), string, scope);
            return;
        }
        this.addError("In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.");
    }

    void loadAndSetProperties(InputStream inputStream, ActionUtil.Scope scope) {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setProperties(properties, scope);
    }

    public void setProperties(Properties properties, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                this.variableSubstitutionsHelper.addSubstitutionProperties(properties);
                return;
            }
            case CONTEXT: {
                scope = new ContextUtil(this.getContext());
                scope.addProperties(properties);
                return;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties((ContextAware)this, (Properties)properties);
            }
        }
    }

    public void setProperty(String string, String string2, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
                return;
            }
            case CONTEXT: {
                this.getContext().putProperty(string, string2);
                return;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty((ContextAware)this, (String)string, (String)string2);
            }
        }
    }
}

