/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.util.logging.Logger;
import org.e.a.f;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;

public abstract class AbstractDebugger
extends SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(AbstractDebugger.class.getName());
    public static boolean printInterpreted = false;
    private final ConnectionListener connListener;
    private final ReconnectionListener reconnectionListener;
    private final ReaderListener readerListener;
    private final WriterListener writerListener;
    private ObservableWriter writer;
    private ObservableReader reader;

    public AbstractDebugger(final XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.reader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            @Override
            public void read(String string) {
                AbstractDebugger.this.log("RECV (" + xMPPConnection.getConnectionCounter() + "): " + string);
            }
        };
        this.reader.addReaderListener(this.readerListener);
        this.writer = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            @Override
            public void write(String string) {
                AbstractDebugger.this.log("SENT (" + xMPPConnection.getConnectionCounter() + "): " + string);
            }
        };
        this.writer.addWriterListener(this.writerListener);
        this.connListener = new ConnectionListener(){

            @Override
            public void connected(XMPPConnection xMPPConnection2) {
                AbstractDebugger.this.log("XMPPConnection connected (" + xMPPConnection2 + ")");
            }

            @Override
            public void authenticated(XMPPConnection object, boolean bl) {
                object = "XMPPConnection authenticated (" + object + ")";
                if (bl) {
                    object = (String)object + " and resumed";
                }
                AbstractDebugger.this.log((String)object);
            }

            @Override
            public void connectionClosed() {
                AbstractDebugger.this.log("XMPPConnection closed (" + xMPPConnection + ")");
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                AbstractDebugger.this.log("XMPPConnection closed due to an exception (" + xMPPConnection + ")", exception);
            }
        };
        this.reconnectionListener = new ReconnectionListener(){

            @Override
            public void reconnectionFailed(Exception exception) {
                AbstractDebugger.this.log("Reconnection failed due to an exception (" + xMPPConnection + ")", exception);
            }

            @Override
            public void reconnectingIn(int n) {
                AbstractDebugger.this.log("XMPPConnection (" + xMPPConnection + ") will reconnect in " + n);
            }
        };
        if (xMPPConnection instanceof AbstractXMPPConnection) {
            xMPPConnection = (AbstractXMPPConnection)xMPPConnection;
            ReconnectionManager.getInstanceFor((AbstractXMPPConnection)xMPPConnection).addReconnectionListener(this.reconnectionListener);
            return;
        }
        LOGGER.info("The connection instance " + xMPPConnection + " is not an instance of AbstractXMPPConnection, thus we can not install the ReconnectionListener");
    }

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    @Override
    public final void outgoingStreamSink(CharSequence charSequence) {
        this.log("SENT (" + this.connection.getConnectionCounter() + "): " + charSequence);
    }

    @Override
    public final void incomingStreamSink(CharSequence charSequence) {
        this.log("RECV (" + this.connection.getConnectionCounter() + "): " + charSequence);
    }

    @Override
    public void userHasLogged(f f2) {
        String string = f2.a().toString();
        boolean bl = "".equals(string);
        string = "User logged (" + this.connection.getConnectionCounter() + "): " + (bl ? "" : string) + "@" + this.connection.getXMPPServiceDomain() + ":" + this.connection.getPort();
        string = string + "/" + f2.d();
        this.log(string);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public void onIncomingStreamElement(TopLevelStreamElement topLevelStreamElement) {
        if (printInterpreted) {
            this.log("RCV PKT (" + this.connection.getConnectionCounter() + "): " + topLevelStreamElement.toXML());
        }
    }

    @Override
    public void onOutgoingStreamElement(TopLevelStreamElement topLevelStreamElement) {
    }
}

