/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.ToStringUtil;

public abstract class AbstractIqBuilder<IB extends AbstractIqBuilder<IB>>
extends StanzaBuilder<IB>
implements IqView {
    protected IQ.Type type = IQ.Type.get;

    AbstractIqBuilder(IQ iQ, String string) {
        super((Stanza)iQ, string);
    }

    AbstractIqBuilder(AbstractIqBuilder<?> abstractIqBuilder) {
        super(abstractIqBuilder);
        this.type = abstractIqBuilder.type;
    }

    AbstractIqBuilder(StanzaIdSource stanzaIdSource) {
        super(stanzaIdSource);
    }

    AbstractIqBuilder(String string) {
        super(string);
    }

    public static IqData createResponse(IqView iqView) {
        return AbstractIqBuilder.createResponse(iqView, IQ.ResponseType.result);
    }

    public static IqData createErrorResponse(IqView iqView) {
        return AbstractIqBuilder.createResponse(iqView, IQ.ResponseType.error);
    }

    protected static IqData createResponse(IqView iqView, IQ.ResponseType responseType) {
        if (!iqView.isRequestIQ()) {
            throw new IllegalArgumentException("IQ request must be of type 'set' or 'get'. Original IQ: " + iqView);
        }
        iqView = AbstractIqBuilder.buildResponse(iqView, string -> StanzaBuilder.buildIqData(string));
        ((IqData)iqView).ofType(responseType.getType());
        return iqView;
    }

    @Override
    protected final void addStanzaSpecificAttributes(ToStringUtil.Builder builder) {
        builder.addValue("type", (Object)this.getType());
    }

    @Override
    public final IQ.Type getType() {
        return this.type;
    }
}

