/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.util.stringencoder.Base64;

class HTTPProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    HTTPProxySocketConnection(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    @Override
    public void connect(Socket object, String string, int n, int n2) {
        Object object2;
        String string2 = this.proxy.getProxyAddress();
        int n3 = this.proxy.getProxyPort();
        ((Socket)object).connect(new InetSocketAddress(string2, n3));
        String string3 = "CONNECT " + string + ":" + n;
        String string4 = this.proxy.getProxyUsername();
        if (string4 == null) {
            string4 = "";
        } else {
            object2 = this.proxy.getProxyPassword();
            string4 = "\r\nProxy-Authorization: Basic " + Base64.encode(string4 + ":" + (String)object2);
        }
        ((Socket)object).getOutputStream().write((string3 + " HTTP/1.1\r\nHost: " + string + ":" + n + string4 + "\r\n\r\n").getBytes("UTF-8"));
        object2 = ((Socket)object).getInputStream();
        object = new StringBuilder(100);
        int n4 = 0;
        do {
            if ((n = ((InputStream)object2).read()) == -1) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            n = (char)n;
            ((StringBuilder)object).append((char)n);
            if (((StringBuilder)object).length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Received header of >1024 characters from " + string2 + ", cancelling connection");
            }
            if ((n4 == 0 || n4 == 2) && n == 13) {
                ++n4;
                continue;
            }
            if ((n4 == 1 || n4 == 3) && n == 10) {
                ++n4;
                continue;
            }
            n4 = 0;
        } while (n4 != 4);
        if (n4 != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + string2 + ", cancelling connection");
        }
        Object object3 = ((StringBuilder)object).toString();
        object = ((BufferedReader)(object3 = new BufferedReader(new StringReader((String)object3)))).readLine();
        if (object == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + string2 + ", cancelling");
        }
        Matcher matcher = RESPONSE_PATTERN.matcher((CharSequence)object);
        if (!matcher.matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + string2 + ": " + (String)object);
        }
        int n5 = Integer.parseInt(matcher.group(1));
        if (n5 != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Error code in proxy response: " + n5);
        }
    }
}

