/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import org.e.c.a.a;
import org.e.c.a.c;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramHmac;
import org.jivesoftware.smack.util.ByteUtils;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class ScramMechanism
extends SASLMechanism {
    private static final int RANDOM_ASCII_BYTE_COUNT = 32;
    private static final byte[] CLIENT_KEY_BYTES = ScramMechanism.toBytes("Client Key");
    private static final byte[] SERVER_KEY_BYTES = ScramMechanism.toBytes("Server Key");
    private static final byte[] ONE = new byte[]{0, 0, 0, 1};
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    private static final a<String, Keys> CACHE = new c(10);
    private final ScramHmac scramHmac;
    private State state = State.INITIAL;
    private String clientRandomAscii;
    private String clientFirstMessageBare;
    private byte[] serverSignature;

    protected ScramMechanism(ScramHmac scramHmac) {
        this.scramHmac = scramHmac;
    }

    @Override
    protected void authenticateInternal(CallbackHandler callbackHandler) {
        throw new UnsupportedOperationException("CallbackHandler not (yet) supported");
    }

    @Override
    protected byte[] getAuthenticationText() {
        this.clientRandomAscii = this.getRandomAscii();
        String string = ScramMechanism.saslPrep(this.authenticationId);
        this.clientFirstMessageBare = "n=" + ScramMechanism.escape(string) + ",r=" + this.clientRandomAscii;
        string = this.getGS2Header() + this.clientFirstMessageBare;
        this.state = State.AUTH_TEXT_SENT;
        return ScramMechanism.toBytes(string);
    }

    @Override
    public String getName() {
        String string = "SCRAM-" + this.scramHmac.getHmacName();
        return string;
    }

    @Override
    public void checkIfSuccessfulOrThrow() {
        if (this.state != State.VALID_SERVER_RESPONSE) {
            throw new SmackException.SmackSaslException("SCRAM-SHA1 is missing valid server response");
        }
    }

    @Override
    public boolean authzidSupported() {
        return true;
    }

    @Override
    protected byte[] evaluateChallenge(byte[] object) {
        object = new String((byte[])object, StandardCharsets.UTF_8);
        switch (this.state) {
            case AUTH_TEXT_SENT: {
                byte[] byArray;
                int n;
                Object object2 = object;
                Map<Character, String> map = ScramMechanism.parseAttributes((String)object);
                object = map;
                String string = map.get(Character.valueOf('r'));
                if (string == null) {
                    throw new SmackException.SmackSaslException("Server random ASCII is null");
                }
                if (string.length() <= this.clientRandomAscii.length()) {
                    throw new SmackException.SmackSaslException("Server random ASCII is shorter then client random ASCII");
                }
                String string2 = string.substring(0, this.clientRandomAscii.length());
                if (!string2.equals(this.clientRandomAscii)) {
                    throw new SmackException.SmackSaslException("Received client random ASCII does not match client random ASCII");
                }
                string2 = (String)object.get(Character.valueOf('i'));
                if (string2 == null) {
                    throw new SmackException.SmackSaslException("Iterations attribute not set");
                }
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SmackException.SmackSaslException("Exception parsing iterations", numberFormatException);
                }
                object = (String)object.get(Character.valueOf('s'));
                if (object == null) {
                    throw new SmackException.SmackSaslException("SALT not send");
                }
                String string3 = "c=" + Base64.encodeToString(this.getCBindInput());
                string = string3 + ",r=" + string;
                object2 = ScramMechanism.toBytes(this.clientFirstMessageBare + ',' + (String)object2 + ',' + string);
                string3 = this.password + ',' + (String)object + ',' + ((SASLMechanism)this).getName();
                Object object3 = (Keys)CACHE.a((Object)string3);
                if (object3 == null) {
                    ScramMechanism scramMechanism = this;
                    object3 = scramMechanism.hi(ScramMechanism.saslPrep(scramMechanism.password), Base64.decode((String)object), n);
                    object = this.hmac((byte[])object3, SERVER_KEY_BYTES);
                    byArray = this.hmac((byte[])object3, CLIENT_KEY_BYTES);
                    object3 = new Keys(byArray, (byte[])object);
                    CACHE.put((Object)string3, object3);
                } else {
                    object = ((Keys)object3).serverKey;
                    byArray = ((Keys)object3).clientKey;
                }
                this.serverSignature = this.hmac((byte[])object, (byte[])object2);
                object3 = SHA1.bytes(byArray);
                object = this.hmac((byte[])object3, (byte[])object2);
                object2 = new byte[byArray.length];
                for (int k = 0; k < ((byte[])object2).length; ++k) {
                    object2[k] = (byte)(byArray[k] ^ object[k]);
                }
                String string4 = string + ",p=" + Base64.encodeToString(object2);
                this.state = State.RESPONSE_SENT;
                return ScramMechanism.toBytes(string4);
            }
            case RESPONSE_SENT: {
                String string = "v=" + Base64.encodeToString(this.serverSignature);
                if (!string.equals(object)) {
                    throw new SmackException.SmackSaslException("Server final message does not match calculated one");
                }
                this.state = State.VALID_SERVER_RESPONSE;
                break;
            }
            default: {
                throw new SmackException.SmackSaslException("Invalid state");
            }
        }
        return null;
    }

    private String getGS2Header() {
        String string = "";
        if (this.authorizationId != null) {
            string = "a=" + this.authorizationId;
        }
        String string2 = this.getGs2CbindFlag();
        assert (StringUtils.isNotEmpty((CharSequence)string2));
        return string2 + ',' + string + ",";
    }

    private byte[] getCBindInput() {
        byte[] byArray = this.getChannelBindingData();
        byte[] byArray2 = ScramMechanism.toBytes(this.getGS2Header());
        if (byArray == null) {
            return byArray2;
        }
        return ByteUtils.concat(byArray2, byArray);
    }

    protected String getGs2CbindFlag() {
        if (this.sslSession != null && this.connectionConfiguration.isEnabledSaslMechanism(((SASLMechanism)this).getName() + "-PLUS")) {
            return "y";
        }
        return "n";
    }

    protected byte[] getChannelBindingData() {
        return null;
    }

    private static Map<Character, String> parseAttributes(String stringArray) {
        if (stringArray.length() == 0) {
            return Collections.emptyMap();
        }
        stringArray = stringArray.split(",");
        HashMap<Character, String> hashMap = new HashMap<Character, String>(stringArray.length, 1.0f);
        for (String string : stringArray) {
            if (string.length() < 3) {
                throw new SmackException.SmackSaslException("Invalid Key-Value pair: " + string);
            }
            char c2 = string.charAt(0);
            if (string.charAt(1) != '=') {
                throw new SmackException.SmackSaslException("Invalid Key-Value pair: " + string);
            }
            string = string.substring(2);
            hashMap.put(Character.valueOf(c2), string);
        }
        return hashMap;
    }

    String getRandomAscii() {
        int n = 0;
        char[] cArray = new char[32];
        Random random = SECURE_RANDOM.get();
        while (n < 32) {
            int n2 = random.nextInt(128);
            char c2 = (char)n2;
            n2 = c2;
            if (!ScramMechanism.isPrintableNonCommaAsciiChar(c2)) continue;
            cArray[n++] = n2;
        }
        return new String(cArray);
    }

    private static boolean isPrintableNonCommaAsciiChar(char c2) {
        if (c2 == ',') {
            return false;
        }
        return c2 > ' ' && c2 < '\u007f';
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.1));
        block4: for (int k = 0; k < string.length(); ++k) {
            char c2 = string.charAt(k);
            switch (c2) {
                case ',': {
                    stringBuilder.append("=2C");
                    continue block4;
                }
                case '=': {
                    stringBuilder.append("=3D");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private byte[] hmac(byte[] byArray, byte[] byArray2) {
        try {
            return this.scramHmac.hmac(byArray, byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SmackException.SmackSaslException(((SASLMechanism)this).getName() + " Exception", invalidKeyException);
        }
    }

    private byte[] hi(String object, byte[] byArray, int n) {
        object = ((String)object).getBytes(StandardCharsets.UTF_8);
        byArray = this.hmac((byte[])object, ByteUtils.concat(byArray, ONE));
        byte[] byArray2 = (byte[])byArray.clone();
        for (int k = 1; k < n; ++k) {
            byArray = this.hmac((byte[])object, byArray);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = i2;
                byArray2[n2] = (byte)(byArray2[n2] ^ byArray[i2]);
            }
        }
        return byArray2;
    }

    private static class Keys {
        private final byte[] clientKey;
        private final byte[] serverKey;

        Keys(byte[] byArray, byte[] byArray2) {
            this.clientKey = byArray;
            this.serverKey = byArray2;
        }
    }

    private static enum State {
        INITIAL,
        AUTH_TEXT_SENT,
        RESPONSE_SENT,
        VALID_SERVER_RESPONSE;

    }
}

