/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.packet;

import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public interface SaslNonza
extends Nonza {
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-sasl";

    @Override
    default public String getNamespace() {
        return NAMESPACE;
    }

    public static class SASLFailure
    extends AbstractError
    implements SaslNonza {
        public static final String ELEMENT = "failure";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "failure");
        private final SASLError saslError;
        private final String saslErrorString;

        public SASLFailure(String string) {
            this(string, null);
        }

        public SASLFailure(String string, Map<String, String> object) {
            super((Map<String, String>)object);
            object = SASLError.fromString(string);
            this.saslError = object == null ? SASLError.not_authorized : object;
            this.saslErrorString = string;
        }

        public SASLError getSASLError() {
            return this.saslError;
        }

        public String getSASLErrorString() {
            return this.saslErrorString;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment object) {
            object = new XmlStringBuilder();
            ((XmlStringBuilder)object).halfOpenElement(ELEMENT).xmlnsAttribute(SaslNonza.NAMESPACE).rightAngleBracket();
            ((XmlStringBuilder)object).emptyElement(this.saslErrorString);
            this.addDescriptiveTextsAndExtensions((XmlStringBuilder)object);
            ((XmlStringBuilder)object).closeElement(ELEMENT);
            return object;
        }

        public String toString() {
            return this.toXML().toString();
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Success
    implements SaslNonza {
        public static final String ELEMENT = "success";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "success");
        private final String data;

        public Success(String string) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(string);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment object) {
            object = new XmlStringBuilder(this, (XmlEnvironment)object);
            ((XmlStringBuilder)object).optTextChild(this.data, this);
            return object;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Response
    implements SaslNonza {
        public static final String ELEMENT = "response";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "response");
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String string) {
            this.authenticationText = StringUtils.returnIfNotEmptyTrimmed(string);
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment object) {
            object = new XmlStringBuilder(this, (XmlEnvironment)object);
            ((XmlStringBuilder)object).optTextChild(this.authenticationText, this);
            return object;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Challenge
    implements SaslNonza {
        public static final String ELEMENT = "challenge";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "challenge");
        private final String data;

        public Challenge(String string) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(string);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment object) {
            object = new XmlStringBuilder(this, (XmlEnvironment)object);
            ((XmlStringBuilder)object).optTextChild(this.data, this);
            return object;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class AuthMechanism
    implements SaslNonza {
        public static final String ELEMENT = "auth";
        public static final QName QNAME = new QName("urn:ietf:params:xml:ns:xmpp-sasl", "auth");
        private final String mechanism;
        private final String authenticationText;

        public AuthMechanism(String string, String string2) {
            this.mechanism = Objects.requireNonNull(string, "SASL mechanism shouldn't be null.");
            this.authenticationText = StringUtils.requireNotNullNorEmpty(string2, "SASL authenticationText must not be null nor empty (RFC6120 6.4.2)");
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment object) {
            object = new XmlStringBuilder(this, (XmlEnvironment)object);
            ((XmlStringBuilder)object).attribute("mechanism", this.mechanism).rightAngleBracket();
            ((XmlStringBuilder)object).escape(this.authenticationText);
            ((XmlStringBuilder)object).closeElement(this);
            return object;
        }

        public String getMechanism() {
            return this.mechanism;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }
}

