/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.t;
import kotlinx.b.v;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljava/security/SecureRandom;", "", "generateClientSeed", "(Ljava/security/SecureRandom;)[B", "Lio/ktor/network/tls/extensions/NamedCurve;", "curve", "Ljava/security/spec/ECPoint;", "serverPoint", "Lio/ktor/network/tls/EncryptionInfo;", "generateECKeys", "(Lio/ktor/network/tls/extensions/NamedCurve;Ljava/security/spec/ECPoint;)Lio/ktor/network/tls/EncryptionInfo;", "Lkotlinx/io/Source;", "packet", "Lio/ktor/network/tls/CertificateInfo;", "readClientCertificateRequest", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/CertificateInfo;", "ktor-network-tls"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(SecureRandom object) {
        byte[] byArray = new byte[32];
        ((SecureRandom)object).nextBytes(byArray);
        object = byArray;
        long l = System.currentTimeMillis() / 1000L;
        byArray[0] = (byte)(l >> 24);
        byArray[1] = (byte)(l >> 16);
        byArray[2] = (byte)(l >> 8);
        byArray[3] = (byte)l;
        return object;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve object, ECPoint object2) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        Object object3 = keyPairGenerator;
        keyPairGenerator.initialize(new ECGenParameterSpec(((Enum)object).name()));
        KeyPair keyPair = ((KeyPairGenerator)object3).generateKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        object = keyPair;
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey);
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyFactory);
        object3 = keyFactory;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        Intrinsics.checkNotNull((Object)eCParameterSpec);
        PublicKey publicKey2 = keyFactory.generatePublic(new ECPublicKeySpec((ECPoint)object2, eCParameterSpec));
        Intrinsics.checkNotNull((Object)publicKey2);
        object2 = publicKey2;
        PublicKey publicKey3 = ((KeyPair)object).getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey3, (String)"");
        PrivateKey privateKey = ((KeyPair)object).getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"");
        return new EncryptionInfo((PublicKey)object2, publicKey3, privateKey);
    }

    public static final CertificateInfo readClientCertificateRequest(t t2) {
        Collection collection;
        int n;
        Collection collection2;
        int n2;
        Intrinsics.checkNotNullParameter((Object)t2, (String)"");
        int n3 = t2.f() & 0xFF;
        byte[] byArray = v.a((t)t2, (int)n3);
        int n4 = t2.g() & 0xFFFF;
        List list = new ArrayList();
        n4 /= 2;
        for (int i = 0; i < n4; ++i) {
            n2 = t2.f();
            byte by = t2.f();
            collection2 = list;
            HashAndSign hashAndSign = SignatureAlgorithmKt.byCode(HashAndSign.Companion, (byte)n2, by);
            if (hashAndSign == null) continue;
            collection2.add(hashAndSign);
        }
        n4 = t2.g() & 0xFFFF;
        Set set = new LinkedHashSet();
        for (n2 = 0; n2 < n4; n2 += n + 2) {
            n = t2.g() & 0xFFFF;
            byte[] byArray2 = v.a((t)t2, (int)n);
            ((Collection)set).add(new X500Principal(byArray2));
        }
        collection2 = collection = (Collection)list;
        CertificateInfo certificateInfo = new CertificateInfo(byArray, collection.toArray(new HashAndSign[0]), set);
        if (!t2.e()) {
            throw new IllegalStateException("Check failed.");
        }
        return certificateInfo;
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom secureRandom) {
        return TLSClientHandshakeKt.generateClientSeed(secureRandom);
    }

    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve namedCurve, ECPoint eCPoint) {
        return TLSClientHandshakeKt.generateECKeys(namedCurve, eCPoint);
    }
}

