/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    PemValue(ByteBuf byteBuf, boolean bl) {
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"content");
        this.sensitive = bl;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    public ByteBuf content() {
        int n = this.refCnt();
        if (n <= 0) {
            throw new IllegalReferenceCountException(n);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.copy());
    }

    @Override
    public PemValue duplicate() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.duplicate());
    }

    @Override
    public PemValue retainedDuplicate() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.retainedDuplicate());
    }

    @Override
    public PemValue replace(ByteBuf byteBuf) {
        return new PemValue(byteBuf, this.sensitive);
    }

    @Override
    public PemValue touch() {
        return (PemValue)super.touch();
    }

    @Override
    public PemValue touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    public PemValue retain(int n) {
        return (PemValue)super.retain(n);
    }

    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

