/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel, int n, boolean bl) {
        super(channel, n);
        this.wantsDirectBuffer = bl;
    }

    protected abstract int wrapDataSize();

    protected ByteBuf compose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(byteBuf, byteBuf2, this.wrapDataSize())) {
            return byteBuf;
        }
        return this.copyAndCompose(byteBufAllocator, byteBuf, byteBuf2);
    }

    protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n) {
        byteBufAllocator = this.wantsDirectBuffer ? byteBufAllocator.directBuffer(n) : byteBufAllocator.heapBuffer(n);
        try {
            byteBufAllocator.writeBytes(byteBuf);
        }
        catch (Throwable throwable) {
            byteBufAllocator.release();
            PlatformDependent.throwException((Throwable)throwable);
        }
        assert (!byteBuf.isReadable());
        byteBuf.release();
        return byteBufAllocator;
    }

    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n) {
        int n2 = byteBuf2.readableBytes();
        if (n2 == 0) {
            byteBuf2.release();
            return true;
        }
        int n3 = byteBuf.capacity();
        if (n - byteBuf.readableBytes() >= n2 && (byteBuf.isWritable(n2) && n3 >= n || n3 < n && ByteBufUtil.ensureWritableSuccess((int)byteBuf.ensureWritable(n2, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }
}

