/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AbstractConstant;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    private static int searchAttributeByKey(DefaultAttribute[] defaultAttributeArray, AttributeKey<?> attributeKey) {
        int n = 0;
        int n2 = defaultAttributeArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Object object = defaultAttributeArray[n3];
            if ((object = ((DefaultAttribute)object).key) == attributeKey) {
                return n3;
            }
            int n4 = ((AbstractConstant)object).id();
            int n5 = attributeKey.id();
            assert (n4 != n5);
            if ((n4 = n4 < n5 ? 1 : 0) != 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return -(n + 1);
    }

    private static void orderedCopyOnInsert(DefaultAttribute[] defaultAttributeArray, int n, DefaultAttribute[] defaultAttributeArray2, DefaultAttribute defaultAttribute) {
        int n2 = defaultAttribute.key.id();
        --n;
        while (n >= 0) {
            DefaultAttribute defaultAttribute2 = defaultAttributeArray[n];
            assert (defaultAttribute2.key.id() != n2);
            if (defaultAttribute2.key.id() < n2) break;
            defaultAttributeArray2[n + 1] = defaultAttributeArray[n];
            --n;
        }
        defaultAttributeArray2[n + 1] = defaultAttribute;
        int n3 = n + 1;
        if (n3 > 0) {
            System.arraycopy(defaultAttributeArray, 0, defaultAttributeArray2, 0, n3);
        }
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        DefaultAttribute[] defaultAttributeArray;
        DefaultAttribute[] defaultAttributeArray2;
        ObjectUtil.checkNotNull(attributeKey, "key");
        DefaultAttribute<T> defaultAttribute = null;
        do {
            defaultAttributeArray2 = this.attributes;
            int n = DefaultAttributeMap.searchAttributeByKey(this.attributes, attributeKey);
            if (n >= 0) {
                DefaultAttribute defaultAttribute2 = defaultAttributeArray2[n];
                assert (defaultAttribute2.key() == attributeKey);
                if (!defaultAttribute2.isRemoved()) {
                    return defaultAttribute2;
                }
                if (defaultAttribute == null) {
                    defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
                }
                int n2 = defaultAttributeArray2.length;
                DefaultAttribute[] defaultAttributeArray3 = Arrays.copyOf(defaultAttributeArray2, n2);
                defaultAttributeArray = defaultAttributeArray3;
                defaultAttributeArray3[n] = defaultAttribute;
                continue;
            }
            if (defaultAttribute == null) {
                defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
            }
            int n3 = defaultAttributeArray2.length;
            defaultAttributeArray = new DefaultAttribute[n3 + 1];
            DefaultAttributeMap.orderedCopyOnInsert(defaultAttributeArray2, n3, defaultAttributeArray, defaultAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, defaultAttributeArray2, defaultAttributeArray));
        return defaultAttribute;
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        ObjectUtil.checkNotNull(attributeKey, "key");
        return DefaultAttributeMap.searchAttributeByKey(this.attributes, attributeKey) >= 0;
    }

    private <T> void removeAttributeIfMatch(AttributeKey<T> attributeKey, DefaultAttribute<T> defaultAttribute) {
        DefaultAttribute[] defaultAttributeArray;
        DefaultAttribute[] defaultAttributeArray2;
        do {
            defaultAttributeArray2 = this.attributes;
            int n = DefaultAttributeMap.searchAttributeByKey(this.attributes, attributeKey);
            if (n < 0) {
                return;
            }
            DefaultAttribute defaultAttribute2 = defaultAttributeArray2[n];
            assert (defaultAttribute2.key() == attributeKey);
            if (defaultAttribute2 != defaultAttribute) {
                return;
            }
            int n2 = defaultAttributeArray2.length;
            int n3 = n2 - 1;
            defaultAttributeArray = n3 == 0 ? EMPTY_ATTRIBUTES : new DefaultAttribute[n3];
            System.arraycopy(defaultAttributeArray2, 0, defaultAttributeArray, 0, n);
            n2 = n2 - n - 1;
            if (n2 <= 0) continue;
            System.arraycopy(defaultAttributeArray2, n + 1, defaultAttributeArray, n, n2);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, defaultAttributeArray2, defaultAttributeArray));
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final AtomicReferenceFieldUpdater<DefaultAttribute, DefaultAttributeMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttribute.class, DefaultAttributeMap.class, "attributeMap");
        private static final long serialVersionUID = -2661411462200283011L;
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        DefaultAttribute(DefaultAttributeMap defaultAttributeMap, AttributeKey<T> attributeKey) {
            this.attributeMap = defaultAttributeMap;
            this.key = attributeKey;
        }

        @Override
        public final AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }

        @Override
        public final T setIfAbsent(T t) {
            while (!this.compareAndSet(null, t)) {
                Object v = this.get();
                if (v == null) continue;
                return (T)v;
            }
            return null;
        }

        @Override
        public final T getAndRemove() {
            DefaultAttributeMap defaultAttributeMap = this.attributeMap;
            boolean bl = defaultAttributeMap != null && MAP_UPDATER.compareAndSet(this, defaultAttributeMap, null);
            T t = this.getAndSet(null);
            if (bl) {
                defaultAttributeMap.removeAttributeIfMatch(this.key, this);
            }
            return t;
        }

        @Override
        public final void remove() {
            DefaultAttributeMap defaultAttributeMap = this.attributeMap;
            boolean bl = defaultAttributeMap != null && MAP_UPDATER.compareAndSet(this, defaultAttributeMap, null);
            this.set(null);
            if (bl) {
                defaultAttributeMap.removeAttributeIfMatch(this.key, this);
            }
        }
    }
}

