/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.LongObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LongCollections {
    private static final LongObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private LongCollections() {
    }

    public static <V> LongObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> LongObjectMap<V> unmodifiableMap(LongObjectMap<V> longObjectMap) {
        return new UnmodifiableMap<V>(longObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements LongObjectMap<V> {
        private final LongObjectMap<V> map;
        private Set<Long> keySet;
        private Set<Map.Entry<Long, V>> entrySet;
        private Collection<V> values;
        private Iterable<LongObjectMap.PrimitiveEntry<V>> entries;

        UnmodifiableMap(LongObjectMap<V> longObjectMap) {
            this.map = longObjectMap;
        }

        @Override
        public final V get(long l) {
            return this.map.get(l);
        }

        @Override
        public final V put(long l, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(long l) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public final boolean containsKey(long l) {
            return this.map.containsKey(l);
        }

        @Override
        public final boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public final V get(Object object) {
            return this.map.get(object);
        }

        @Override
        public final V put(Long l, V v) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object object) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Long, ? extends V> map) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<LongObjectMap.PrimitiveEntry<V>>(){

                    @Override
                    public Iterator<LongObjectMap.PrimitiveEntry<V>> iterator() {
                        return new IteratorImpl(UnmodifiableMap.this.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Long> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Long, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements LongObjectMap.PrimitiveEntry<V> {
            private final LongObjectMap.PrimitiveEntry<V> entry;

            EntryImpl(LongObjectMap.PrimitiveEntry<V> primitiveEntry) {
                this.entry = primitiveEntry;
            }

            @Override
            public long key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V v) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<LongObjectMap.PrimitiveEntry<V>> {
            final Iterator<LongObjectMap.PrimitiveEntry<V>> iter;

            IteratorImpl(Iterator<LongObjectMap.PrimitiveEntry<V>> iterator) {
                this.iter = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public LongObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements LongObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(long l) {
            return null;
        }

        @Override
        public final Object put(long l, Object object) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(long l) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object object) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Long> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(long l) {
            return false;
        }

        @Override
        public final boolean containsValue(Object object) {
            return false;
        }

        @Override
        public final Iterable<LongObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object object) {
            return null;
        }

        @Override
        public final Object put(Long l, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object object) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Long, ?> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Long, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

