/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.Cleaner;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class CleanerJava6
implements Cleaner {
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;
    private static final Field CLEANER_FIELD;
    private static final InternalLogger logger;

    CleanerJava6() {
    }

    static boolean isSupported() {
        return CLEANER_FIELD_OFFSET != -1L || CLEANER_FIELD != null;
    }

    @Override
    public final void freeDirectBuffer(ByteBuffer object) {
        if (!((ByteBuffer)object).isDirect()) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                CleanerJava6.freeDirectBuffer0((ByteBuffer)object);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                PlatformDependent0.throwException(throwable);
                return;
            }
        }
        CleanerJava6.freeDirectBufferPrivileged((ByteBuffer)object);
    }

    private static void freeDirectBufferPrivileged(ByteBuffer object) {
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Throwable>((ByteBuffer)object){
            final /* synthetic */ ByteBuffer val$buffer;
            {
                this.val$buffer = byteBuffer;
            }

            @Override
            public final Throwable run() {
                try {
                    CleanerJava6.freeDirectBuffer0(this.val$buffer);
                    return null;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    return throwable;
                }
            }
        })) != null) {
            PlatformDependent0.throwException((Throwable)object);
        }
    }

    private static void freeDirectBuffer0(ByteBuffer object) {
        object = CLEANER_FIELD_OFFSET == -1L ? CLEANER_FIELD.get(object) : PlatformDependent0.getObject(object, CLEANER_FIELD_OFFSET);
        if (object != null) {
            CLEAN_METHOD.invoke(object, new Object[0]);
        }
    }

    static {
        long l;
        Object object;
        logger = InternalLoggerFactory.getInstance(CleanerJava6.class);
        Throwable throwable = null;
        Object object2 = ByteBuffer.allocateDirect(1);
        try {
            Object object3;
            object = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                final /* synthetic */ ByteBuffer val$direct;
                {
                    this.val$direct = byteBuffer;
                }

                @Override
                public final Object run() {
                    try {
                        Field field = this.val$direct.getClass().getDeclaredField("cleaner");
                        if (!PlatformDependent.hasUnsafe()) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        return throwable;
                    }
                }
            });
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            object = (Field)object;
            if (PlatformDependent.hasUnsafe()) {
                l = PlatformDependent0.objectFieldOffset((Field)object);
                object3 = PlatformDependent0.getObject(object2, l);
            } else {
                l = -1L;
                object3 = ((Field)object).get(object2);
            }
            object2 = object3.getClass().getDeclaredMethod("clean", new Class[0]);
            ((Method)object2).invoke(object3, new Object[0]);
        }
        catch (Throwable throwable2) {
            l = -1L;
            object2 = null;
            throwable = throwable2;
            object = null;
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        CLEANER_FIELD = object;
        CLEANER_FIELD_OFFSET = l;
        CLEAN_METHOD = object2;
    }
}

