/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final ObjectPool<RecyclableArrayList> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<RecyclableArrayList>(){

        @Override
        public final RecyclableArrayList newObject(ObjectPool.Handle<RecyclableArrayList> handle) {
            return new RecyclableArrayList(handle);
        }
    });
    private boolean insertSinceRecycled;
    private final ObjectPool.Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    public static RecyclableArrayList newInstance(int n) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n);
        return recyclableArrayList;
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle) {
        this(handle, 8);
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle, int n) {
        super(n);
        this.handle = handle;
    }

    @Override
    public final boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(int n, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> object) {
        if (object instanceof RandomAccess && object instanceof List) {
            object = (List)object;
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                if (object.get(i) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e != null) continue;
            throw new IllegalArgumentException("c contains null values");
        }
    }

    @Override
    public final boolean add(Object object) {
        if (super.add(ObjectUtil.checkNotNull(object, "element"))) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final void add(int n, Object object) {
        super.add(n, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
    }

    @Override
    public final Object set(int n, Object object) {
        Object object2 = super.set(n, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
        return object2;
    }

    public final boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public final boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }
}

