/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.unpadded;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.unpadded.MpscUnpaddedArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpscUnpaddedArrayQueue<E>
extends MpscUnpaddedArrayQueueL3Pad<E> {
    public MpscUnpaddedArrayQueue(int n) {
        super(n);
    }

    public boolean offerIfBelowThreshold(E e, int n) {
        long l;
        long l2;
        long l3;
        if (e == null) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerLimit();
        do {
            long l7;
            if ((l7 = l5 - (l2 = l6 - (l = this.lvProducerIndex()))) >= (long)n) {
                long l8 = this.lvConsumerIndex();
                l7 = l - l8;
                if (l7 >= (long)n) {
                    return false;
                }
                l6 = l8 + l5;
                this.soProducerLimit(l6);
            }
            l3 = l;
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l, l4);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l2, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long l;
        long l2;
        long l3;
        if (e == null) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = this.lvProducerLimit();
        do {
            if ((l2 = this.lvProducerIndex()) >= l5) {
                l = this.lvConsumerIndex();
                l5 = l + l4 + 1L;
                if (l2 >= l5) {
                    return false;
                }
                this.soProducerLimit(l5);
            }
            l3 = l2;
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l4);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l, e);
        return true;
    }

    public final int failFastOffer(E e) {
        long l;
        long l2;
        if (e == null) {
            throw new NullPointerException();
        }
        long l3 = this.mask;
        long l4 = l3 + 1L;
        long l5 = this.lvProducerIndex();
        if (l5 >= (l2 = this.lvProducerLimit())) {
            l = this.lvConsumerIndex();
            l2 = l + l4;
            if (l5 >= l2) {
                return 1;
            }
            this.soProducerLimit(l2);
        }
        long l6 = l5;
        if (!this.casProducerIndex(l6, l6 + 1L)) {
            return -1;
        }
        l = UnsafeRefArrayAccess.calcCircularRefElementOffset(l5, l3);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l, e);
        return 0;
    }

    @Override
    public E poll() {
        long l = this.lpConsumerIndex();
        long l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l, this.mask);
        E[] EArray = this.buffer;
        Object e = UnsafeRefArrayAccess.lvRefElement(this.buffer, l2);
        if (e == null) {
            if (l != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(EArray, l2)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spRefElement(EArray, l2, null);
        this.soConsumerIndex(l + 1L);
        return e;
    }

    @Override
    public E peek() {
        E[] EArray = this.buffer;
        long l = this.lpConsumerIndex();
        long l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        if (e == null) {
            if (l != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(EArray, l2)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        E[] EArray = this.buffer;
        long l = this.lpConsumerIndex();
        long l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        if (e == null) {
            return null;
        }
        UnsafeRefArrayAccess.spRefElement(EArray, l2, null);
        this.soConsumerIndex(l + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        E[] EArray = this.buffer;
        long l = this.mask;
        long l2 = this.lpConsumerIndex();
        return UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        E[] EArray = this.buffer;
        long l = this.mask;
        long l2 = this.lpConsumerIndex();
        for (int i = 0; i < n; ++i) {
            long l3 = l2 + (long)i;
            long l4 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l);
            Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l4);
            if (e == null) {
                return i;
            }
            UnsafeRefArrayAccess.spRefElement(EArray, l4, null);
            this.soConsumerIndex(l3 + 1L);
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long l;
        long l2;
        int n2;
        long l3;
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerLimit();
        do {
            long l7;
            if ((l7 = l6 - (l2 = this.lvProducerIndex())) <= 0L) {
                l = this.lvConsumerIndex();
                l6 = l + l5;
                l7 = l6 - l2;
                if (l7 <= 0L) {
                    return 0;
                }
                this.soProducerLimit(l6);
            }
            n2 = Math.min((int)l7, n);
            l3 = l2;
        } while (!this.casProducerIndex(l3, l3 + (long)n2));
        E[] EArray = this.buffer;
        for (int i = 0; i < n2; ++i) {
            l = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2 + (long)i, l4);
            UnsafeRefArrayAccess.soRefElement(EArray, l, supplier.get());
        }
        return n2;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

