/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.ContentInViewNode;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.geometry.Rect;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006J<\u0010\u000f\u001a\u00020\u00102#\u0010\u0011\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00100\u0012H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0006\u0010\u0017\u001a\u00020\u0010J<\u0010\u0018\u001a\u00020\u00102#\u0010\u0011\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\f0\u0012H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0010\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Landroidx/compose/foundation/gestures/BringIntoViewRequestPriorityQueue;", "", "<init>", "()V", "requests", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/gestures/ContentInViewNode$Request;", "size", "", "getSize", "()I", "isEmpty", "", "enqueue", "request", "forEachFromSmallest", "", "block", "Lkotlin/Function1;", "Landroidx/compose/ui/geometry/Rect;", "Lkotlin/ParameterName;", "name", "bounds", "resumeAndRemoveAll", "resumeAndRemoveWhile", "cancelAndRemoveAll", "cause", "", "foundation"})
public final class BringIntoViewRequestPriorityQueue {
    private final MutableVector<ContentInViewNode.Request> requests = new MutableVector((Object[])new ContentInViewNode.Request[16], 0);
    public static final int $stable = MutableVector.$stable;

    public final int getSize() {
        return this.requests.getSize();
    }

    public final boolean isEmpty() {
        MutableVector<ContentInViewNode.Request> mutableVector = this.requests;
        return mutableVector.getSize() == 0;
    }

    public final boolean enqueue(ContentInViewNode.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"");
        Rect rect = (Rect)request.getCurrentBounds().invoke();
        if (rect == null) {
            ((Continuation)request.getContinuation()).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            return false;
        }
        Rect rect2 = rect;
        request.getContinuation().a(arg_0 -> BringIntoViewRequestPriorityQueue.enqueue$lambda$1(this, request, arg_0));
        MutableVector<ContentInViewNode.Request> mutableVector = this.requests;
        IntRange intRange = RangesKt.until((int)0, (int)mutableVector.getSize());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                Object object = this.requests;
                object = (ContentInViewNode.Request)object.content[n2];
                Rect rect3 = (Rect)object.getCurrentBounds().invoke();
                if (rect3 != null) {
                    object = rect3;
                    Rect rect4 = rect2.intersect(object);
                    if (Intrinsics.areEqual((Object)rect4, (Object)rect2)) {
                        this.requests.add(n2 + 1, (Object)request);
                        return true;
                    }
                    if (!Intrinsics.areEqual((Object)rect4, (Object)object)) {
                        object = new CancellationException("bringIntoView call interrupted by a newer, non-overlapping call");
                        int n3 = this.requests.getSize() - 1;
                        if (n3 <= n2) {
                            while (true) {
                                MutableVector<ContentInViewNode.Request> mutableVector2 = this.requests;
                                ((ContentInViewNode.Request)mutableVector2.content[n2]).getContinuation().b((Throwable)object);
                                if (n3 == n2) break;
                                ++n3;
                            }
                        }
                    }
                }
                if (n2 == n) break;
                --n2;
            }
        }
        this.requests.add(0, (Object)request);
        return true;
    }

    public final void forEachFromSmallest(Function1<? super Rect, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Object[] objectArray = this.requests;
        int n = objectArray.getSize() - 1;
        objectArray = objectArray.content;
        if (n < objectArray.length) {
            while (n >= 0) {
                ContentInViewNode.Request request = (ContentInViewNode.Request)objectArray[n];
                function1.invoke(request.getCurrentBounds().invoke());
                --n;
            }
        }
    }

    public final void resumeAndRemoveAll() {
        int n;
        MutableVector<ContentInViewNode.Request> mutableVector = this.requests;
        IntRange intRange = RangesKt.until((int)0, (int)mutableVector.getSize());
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                Continuation continuation = this.requests;
                continuation = (Continuation)((ContentInViewNode.Request)continuation.content[n2]).getContinuation();
                Unit unit = Unit.INSTANCE;
                continuation.resumeWith(Result.constructor-impl((Object)unit));
                if (n2 == n) break;
                ++n2;
            }
        }
        this.requests.clear();
    }

    public final void resumeAndRemoveWhile(Function1<? super Rect, Boolean> function1) {
        MutableVector mutableVector;
        Intrinsics.checkNotNullParameter(function1, (String)"");
        while ((mutableVector = this.requests).getSize() != 0) {
            if (((Boolean)function1.invoke(((ContentInViewNode.Request)this.requests.last()).getCurrentBounds().invoke())).booleanValue()) {
                mutableVector = this.requests;
                mutableVector = (Continuation)((ContentInViewNode.Request)this.requests.removeAt(mutableVector.getSize() - 1)).getContinuation();
                Unit unit = Unit.INSTANCE;
                mutableVector.resumeWith(Result.constructor-impl((Object)unit));
                continue;
            }
            return;
        }
    }

    public final void cancelAndRemoveAll(Throwable throwable) {
        CancellableContinuation cancellableContinuation;
        CancellableContinuation cancellableContinuation2 = this.requests;
        int n = 0;
        int n2 = cancellableContinuation2.getSize();
        CancellableContinuation cancellableContinuation3 = new CancellableContinuation[n2];
        while (n < n2) {
            int n3 = n++;
            CancellableContinuation cancellableContinuation4 = cancellableContinuation2;
            cancellableContinuation = (CancellableContinuation)cancellableContinuation4.content[n3];
            int n4 = n3;
            cancellableContinuation4 = cancellableContinuation3;
            cancellableContinuation4[n4] = cancellableContinuation = cancellableContinuation.getContinuation();
        }
        cancellableContinuation2 = cancellableContinuation3;
        n2 = ((CancellableContinuation[])cancellableContinuation2).length;
        for (n = 0; n < n2; ++n) {
            cancellableContinuation = cancellableContinuation3 = cancellableContinuation2[n];
            cancellableContinuation3.b(throwable);
        }
        cancellableContinuation2 = this.requests;
        boolean bl = cancellableContinuation2.getSize() == 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("uncancelled requests present");
        }
    }

    private static final Unit enqueue$lambda$1(BringIntoViewRequestPriorityQueue bringIntoViewRequestPriorityQueue, ContentInViewNode.Request request, Throwable throwable) {
        bringIntoViewRequestPriorityQueue.requests.remove((Object)request);
        return Unit.INSTANCE;
    }
}

