/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.foundation.text.UndoManager_jvmKt;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001aB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/foundation/text/UndoManager;", "", "maxStoredCharacters", "", "<init>", "(I)V", "getMaxStoredCharacters", "()I", "undoStack", "Landroidx/compose/foundation/text/UndoManager$Entry;", "redoStack", "storedCharacters", "lastSnapshot", "", "Ljava/lang/Long;", "forceNextSnapshot", "", "snapshotIfNeeded", "", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "now", "makeSnapshot", "removeLastUndo", "undo", "redo", "Entry", "foundation"})
public final class UndoManager {
    private final int maxStoredCharacters;
    private Entry undoStack;
    private Entry redoStack;
    private int storedCharacters;
    private Long lastSnapshot;
    private boolean forceNextSnapshot;
    public static final int $stable = 8;

    public UndoManager(int n2) {
        this.maxStoredCharacters = n2;
    }

    public /* synthetic */ UndoManager(int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n2 = 100000;
        }
        this(n2);
    }

    public final int getMaxStoredCharacters() {
        return this.maxStoredCharacters;
    }

    public final void snapshotIfNeeded(TextFieldValue textFieldValue, long l2) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
                if (this.forceNextSnapshot) break block2;
                Long l3 = this.lastSnapshot;
                if (l2 <= (l3 != null ? l3 : 0L) + (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) break block3;
            }
            this.lastSnapshot = l2;
            this.makeSnapshot(textFieldValue);
        }
    }

    public static /* synthetic */ void snapshotIfNeeded$default(UndoManager undoManager, TextFieldValue textFieldValue, long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l2 = UndoManager_jvmKt.timeNowMillis();
        }
        undoManager.snapshotIfNeeded(textFieldValue, l2);
    }

    public final void forceNextSnapshot() {
        this.forceNextSnapshot = true;
    }

    public final void makeSnapshot(TextFieldValue textFieldValue) {
        Entry entry;
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
        this.forceNextSnapshot = false;
        Entry entry2 = this.undoStack;
        if (Intrinsics.areEqual((Object)textFieldValue, (Object)(entry2 != null ? entry2.getValue() : null))) {
            return;
        }
        if (Intrinsics.areEqual((Object)textFieldValue.getText(), (entry = this.undoStack) != null && (entry = entry.getValue()) != null ? entry.getText() : null)) {
            Entry entry3 = this.undoStack;
            if (entry3 != null) {
                entry3.setValue(textFieldValue);
                return;
            }
            return;
        }
        Entry entry4 = this.undoStack;
        this.undoStack = new Entry(entry4, textFieldValue);
        this.redoStack = null;
        this.storedCharacters += textFieldValue.getText().length();
        if (this.storedCharacters > this.maxStoredCharacters) {
            this.removeLastUndo();
        }
    }

    private final void removeLastUndo() {
        Entry entry;
        Entry entry2 = this.undoStack;
        if ((entry2 != null ? entry2.getNext() : null) == null) {
            return;
        }
        while (((entry = entry2) != null && (entry = entry.getNext()) != null ? entry.getNext() : null) != null) {
            entry2 = entry2.getNext();
        }
        Entry entry3 = entry2;
        if (entry3 != null) {
            entry3.setNext(null);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TextFieldValue undo() {
        Entry entry;
        Entry entry2 = this.undoStack;
        if (entry2 == null) return null;
        Entry entry3 = entry2;
        Entry entry4 = entry2.getNext();
        if (entry4 == null) return null;
        this.undoStack = entry = entry4;
        this.storedCharacters -= entry3.getValue().getText().length();
        entry3 = entry3.getValue();
        Entry entry5 = this.redoStack;
        this.redoStack = new Entry(entry5, (TextFieldValue)entry3);
        TextFieldValue textFieldValue = entry.getValue();
        return textFieldValue;
    }

    public final TextFieldValue redo() {
        Entry entry = this.redoStack;
        if (entry != null) {
            Entry entry2 = entry;
            this.redoStack = entry2.getNext();
            TextFieldValue textFieldValue = entry2.getValue();
            Entry entry3 = this.undoStack;
            this.undoStack = new Entry(entry3, textFieldValue);
            this.storedCharacters += entry2.getValue().getText().length();
            return entry2.getValue();
        }
        return null;
    }

    public UndoManager() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/compose/foundation/text/UndoManager$Entry;", "", "next", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "<init>", "(Landroidx/compose/foundation/text/UndoManager$Entry;Landroidx/compose/ui/text/input/TextFieldValue;)V", "getNext", "()Landroidx/compose/foundation/text/UndoManager$Entry;", "setNext", "(Landroidx/compose/foundation/text/UndoManager$Entry;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "foundation"})
    private static final class Entry {
        private Entry next;
        private TextFieldValue value;

        public Entry(Entry entry, TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            this.next = entry;
            this.value = textFieldValue;
        }

        public /* synthetic */ Entry(Entry entry, TextFieldValue textFieldValue, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                entry = null;
            }
            this(entry, textFieldValue);
        }

        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(Entry entry) {
            this.next = entry;
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            this.value = textFieldValue;
        }
    }
}

