/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatHelpButtonIcon;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class FlatButtonUI
extends BasicButtonUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    protected int iconTextGap;
    protected Color background;
    protected Color foreground;
    protected Color startBackground;
    protected Color endBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedForeground;
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBackground;
    protected Color defaultEndBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected boolean defaultBoldText;
    @FlatStylingSupport.Styleable
    protected boolean paintShadow;
    @FlatStylingSupport.Styleable
    protected int shadowWidth;
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultShadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedForeground;
    @FlatStylingSupport.Styleable
    protected String buttonType;
    @FlatStylingSupport.Styleable
    protected boolean squareSize;
    @FlatStylingSupport.Styleable
    protected int minimumHeight;
    private Icon helpButtonIcon;
    private Insets defaultMargin;
    private final boolean shared;
    private boolean helpButtonIconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    static final int TYPE_OTHER = -1;
    static final int TYPE_SQUARE = 0;
    static final int TYPE_ROUND_RECT = 1;
    private static Rectangle viewR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle iconR = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        if (FlatUIUtils.canUseSharedUI(jComponent) && !FlatUIUtils.needsLightAWTPeer(jComponent)) {
            return FlatUIUtils.createSharedUI(FlatButtonUI.class, () -> new FlatButtonUI(true));
        }
        return new FlatButtonUI(false);
    }

    protected FlatButtonUI(boolean bl) {
        this.shared = bl;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
            return;
        }
        this.installUIImpl(jComponent);
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((AbstractButton)jComponent);
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.minimumWidth = UIManager.getInt((String)object + "minimumWidth");
            this.iconTextGap = FlatUIUtils.getUIInt((String)object + "iconTextGap", 4);
            this.background = UIManager.getColor((String)object + "background");
            this.foreground = UIManager.getColor((String)object + "foreground");
            this.startBackground = UIManager.getColor((String)object + "startBackground");
            this.endBackground = UIManager.getColor((String)object + "endBackground");
            this.focusedBackground = UIManager.getColor((String)object + "focusedBackground");
            this.focusedForeground = UIManager.getColor((String)object + "focusedForeground");
            this.hoverBackground = UIManager.getColor((String)object + "hoverBackground");
            this.hoverForeground = UIManager.getColor((String)object + "hoverForeground");
            this.pressedBackground = UIManager.getColor((String)object + "pressedBackground");
            this.pressedForeground = UIManager.getColor((String)object + "pressedForeground");
            this.selectedBackground = UIManager.getColor((String)object + "selectedBackground");
            this.selectedForeground = UIManager.getColor((String)object + "selectedForeground");
            this.disabledBackground = UIManager.getColor((String)object + "disabledBackground");
            this.disabledText = UIManager.getColor((String)object + "disabledText");
            this.disabledSelectedBackground = UIManager.getColor((String)object + "disabledSelectedBackground");
            this.disabledSelectedForeground = UIManager.getColor((String)object + "disabledSelectedForeground");
            this.defaultBackground = FlatUIUtils.getUIColor("Button.default.startBackground", "Button.default.background");
            this.defaultEndBackground = UIManager.getColor("Button.default.endBackground");
            this.defaultForeground = UIManager.getColor("Button.default.foreground");
            this.defaultFocusedBackground = UIManager.getColor("Button.default.focusedBackground");
            this.defaultFocusedForeground = UIManager.getColor("Button.default.focusedForeground");
            this.defaultHoverBackground = UIManager.getColor("Button.default.hoverBackground");
            this.defaultHoverForeground = UIManager.getColor("Button.default.hoverForeground");
            this.defaultPressedBackground = UIManager.getColor("Button.default.pressedBackground");
            this.defaultPressedForeground = UIManager.getColor("Button.default.pressedForeground");
            this.defaultBoldText = UIManager.getBoolean("Button.default.boldText");
            this.paintShadow = UIManager.getBoolean("Button.paintShadow");
            this.shadowWidth = FlatUIUtils.getUIInt("Button.shadowWidth", 2);
            this.shadowColor = UIManager.getColor("Button.shadowColor");
            this.defaultShadowColor = UIManager.getColor("Button.default.shadowColor");
            this.toolbarHoverBackground = UIManager.getColor((String)object + "toolbar.hoverBackground");
            this.toolbarHoverForeground = UIManager.getColor((String)object + "toolbar.hoverForeground");
            this.toolbarPressedBackground = UIManager.getColor((String)object + "toolbar.pressedBackground");
            this.toolbarPressedForeground = UIManager.getColor((String)object + "toolbar.pressedForeground");
            this.toolbarSelectedBackground = UIManager.getColor((String)object + "toolbar.selectedBackground");
            this.toolbarSelectedForeground = UIManager.getColor((String)object + "toolbar.selectedForeground");
            this.toolbarDisabledSelectedBackground = UIManager.getColor((String)object + "toolbar.disabledSelectedBackground");
            this.toolbarDisabledSelectedForeground = UIManager.getColor((String)object + "toolbar.disabledSelectedForeground");
            this.helpButtonIcon = UIManager.getIcon("HelpButton.icon");
            this.defaultMargin = UIManager.getInsets((String)object + "margin");
            this.helpButtonIconShared = true;
            this.defaults_initialized = true;
        }
        if (this.startBackground != null && ((object = abstractButton.getBackground()) == null || object instanceof UIResource)) {
            abstractButton.setBackground(this.startBackground);
        }
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(abstractButton);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new FlatButtonListener(abstractButton);
    }

    protected void propertyChange(AbstractButton abstractButton, PropertyChangeEvent object) {
        switch (((PropertyChangeEvent)object).getPropertyName()) {
            case "JButton.squareSize": 
            case "JComponent.minimumWidth": 
            case "JComponent.minimumHeight": {
                abstractButton.revalidate();
                return;
            }
            case "JButton.buttonType": {
                abstractButton.revalidate();
                abstractButton.repaint();
                return;
            }
            case "JComponent.outline": {
                abstractButton.repaint();
                return;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(abstractButton)) {
                    abstractButton.updateUI();
                } else {
                    this.installStyle(abstractButton);
                }
                abstractButton.revalidate();
                abstractButton.repaint();
            }
        }
    }

    protected void installStyle(AbstractButton abstractButton) {
        try {
            AbstractButton abstractButton2 = abstractButton;
            this.applyStyle(abstractButton2, FlatStylingSupport.getResolvedStyle(abstractButton2, this.getStyleType()));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    String getStyleType() {
        return "Button";
    }

    protected void applyStyle(AbstractButton abstractButton, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(abstractButton, (String)string, object));
    }

    protected Object applyStyleProperty(AbstractButton abstractButton, String string, Object object) {
        if (string.startsWith("help.")) {
            if (!(this.helpButtonIcon instanceof FlatHelpButtonIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.helpButtonIconShared) {
                this.helpButtonIcon = FlatStylingSupport.cloneIcon(this.helpButtonIcon);
                this.helpButtonIconShared = false;
            }
            string = string.substring(5);
            return ((FlatHelpButtonIcon)this.helpButtonIcon).applyStyleProperty(string, object);
        }
        if ("iconTextGap".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, abstractButton, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent object) {
        object = FlatStylingSupport.getAnnotatedStyleableInfos(this, ((JComponent)object).getBorder());
        if (this.helpButtonIcon instanceof FlatHelpButtonIcon) {
            FlatStylingSupport.putAllPrefixKey(object, "help.", ((FlatHelpButtonIcon)this.helpButtonIcon).getStyleableInfos());
        }
        return object;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.startsWith("help.")) {
            if (this.helpButtonIcon instanceof FlatHelpButtonIcon) {
                return ((FlatHelpButtonIcon)this.helpButtonIcon).getStyleableValue(string.substring(5));
            }
            return null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, jComponent.getBorder(), string);
    }

    static boolean isContentAreaFilled(Component component) {
        return !(component instanceof AbstractButton) || ((AbstractButton)component).isContentAreaFilled();
    }

    public static boolean isFocusPainted(Component component) {
        return !(component instanceof AbstractButton) || ((AbstractButton)component).isFocusPainted();
    }

    static boolean isDefaultButton(Component component) {
        return component instanceof JButton && ((JButton)component).isDefaultButton();
    }

    static boolean isIconOnlyOrSingleCharacterButton(Component object) {
        if (!(object instanceof JButton) && !(object instanceof JToggleButton)) {
            return false;
        }
        Icon icon = ((AbstractButton)object).getIcon();
        object = ((AbstractButton)object).getText();
        return icon != null && (object == null || ((String)object).isEmpty()) || icon == null && object != null && ("...".equals(object) || ((String)object).length() == 1 || ((String)object).length() == 2 && Character.isSurrogatePair(((String)object).charAt(0), ((String)object).charAt(1)));
    }

    static int getButtonType(Component object) {
        if (!(object instanceof AbstractButton)) {
            return -1;
        }
        if ((object = FlatButtonUI.getButtonTypeStr((AbstractButton)object)) == null) {
            return -1;
        }
        int n = -1;
        switch (((String)object).hashCode()) {
            case -894674659: {
                if (!((String)object).equals("square")) break;
                n = 0;
                break;
            }
            case -5109614: {
                if (!((String)object).equals("roundRect")) break;
                n = 1;
            }
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    static boolean isHelpButton(Component component) {
        return component instanceof JButton && "help".equals(FlatButtonUI.getButtonTypeStr((JButton)component));
    }

    static boolean isToolBarButton(Component component) {
        return component.getParent() instanceof JToolBar || component instanceof AbstractButton && "toolBarButton".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)component));
    }

    static boolean isBorderlessButton(Component component) {
        return component instanceof AbstractButton && "borderless".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)component));
    }

    static String getButtonTypeStr(AbstractButton object) {
        Object object2 = ((JComponent)object).getClientProperty("JButton.buttonType");
        if (object2 instanceof String) {
            return (String)object2;
        }
        if ((object = ((AbstractButton)object).getUI()) instanceof FlatButtonUI) {
            return ((FlatButtonUI)object).buttonType;
        }
        return null;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        if (FlatButtonUI.isHelpButton(jComponent)) {
            this.helpButtonIcon.paintIcon(jComponent, graphics, 0, 0);
            return;
        }
        if (FlatButtonUI.isContentAreaFilled(jComponent)) {
            this.paintBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Color color = this.getBackground(jComponent);
        if (color == null) {
            return;
        }
        graphics = (Graphics2D)graphics.create();
        try {
            Color color2;
            Serializable serializable;
            JTextField jTextField;
            FlatUIUtils.setRenderingHints(graphics);
            boolean bl = FlatButtonUI.isDefaultButton(jComponent);
            boolean bl2 = FlatButtonUI.isToolBarButton(jComponent);
            float f = bl2 ? 0.0f : FlatUIUtils.getBorderFocusWidth(jComponent);
            float f2 = FlatUIUtils.getBorderArc(jComponent);
            float f3 = 0.0f;
            if (bl2 && FlatClientProperties.clientProperty(jComponent, "FlatLaf.styleClass", "", String.class).contains("inTextField") && (jTextField = (JTextField)SwingUtilities.getAncestorOfClass(JTextField.class, jComponent)) != null) {
                f3 = FlatUIUtils.getBorderArc(jTextField);
            }
            int n = 0;
            int n2 = 0;
            int n3 = jComponent.getWidth();
            int n4 = jComponent.getHeight();
            if (bl2 && jComponent.getBorder() instanceof FlatButtonBorder) {
                serializable = UIScale.scale(((FlatButtonBorder)jComponent.getBorder()).toolbarSpacingInsets);
                n = 0 + ((Insets)serializable).left;
                n2 = 0 + ((Insets)serializable).top;
                n3 -= ((Insets)serializable).left + ((Insets)serializable).right;
                n4 -= ((Insets)serializable).top + ((Insets)serializable).bottom;
                f3 -= (float)(((Insets)serializable).top + ((Insets)serializable).bottom);
            }
            if (f2 < f3) {
                f2 = f3;
            }
            Color color3 = serializable = bl ? this.defaultShadowColor : this.shadowColor;
            if (!(!this.paintShadow || serializable == null || this.shadowWidth <= 0 || !(f > 0.0f) || !jComponent.isEnabled() || bl2 || FlatButtonUI.isBorderlessButton(jComponent) || FlatButtonUI.isFocusPainted(jComponent) && FlatUIUtils.isPermanentFocusOwner(jComponent))) {
                graphics.setColor((Color)serializable);
                float f4 = f;
                float f5 = f2;
                ((Graphics2D)graphics).fill(new RoundRectangle2D.Float(f4, f4 + UIScale.scale((float)this.shadowWidth), (float)n3 - f * 2.0f, (float)n4 - f * 2.0f, f5, f5));
            }
            Color color4 = bl ? this.defaultBackground : this.startBackground;
            Color color5 = color2 = bl ? this.defaultEndBackground : this.endBackground;
            if (color == color4 && color2 != null && !color4.equals(color2)) {
                ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, color4, 0.0f, n4, color2));
            } else {
                graphics.setColor(FlatUIUtils.deriveColor(color, this.getBackgroundBase(jComponent, bl)));
            }
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, n, n2, n3, n4, f, f2);
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        graphics = FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent);
        jComponent = (AbstractButton)jComponent;
        String string = FlatButtonUI.layout((AbstractButton)jComponent, jComponent.getFontMetrics(jComponent.getFont()), jComponent.getWidth(), jComponent.getHeight());
        this.clearTextShiftOffset();
        Object object = ((AbstractButton)jComponent).getModel();
        if (object.isArmed() && object.isPressed()) {
            this.paintButtonPressed(graphics, (AbstractButton)jComponent);
        }
        if (((AbstractButton)jComponent).getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconR);
        }
        if (string != null && !string.isEmpty()) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, textR);
            } else {
                this.paintText(graphics, (AbstractButton)jComponent, textR, string);
            }
        }
        if (((AbstractButton)jComponent).isFocusPainted() && jComponent.hasFocus()) {
            this.paintFocus(graphics, (AbstractButton)jComponent, viewR, textR, iconR);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void paintIcon(Graphics var1_1, JComponent var2_2, Rectangle var3_3) {
        block6: {
            var4_4 = this.defaultBoldPlainWidthDiff(var2_2) / 2;
            if (var4_4 <= 0) break block6;
            var5_5 = var2_2.getComponentOrientation().isLeftToRight();
            switch (((AbstractButton)var2_2).getHorizontalTextPosition()) {
                case 4: {
                    var3_3.x -= var4_4;
                    break;
                }
                case 2: {
                    v0 = var3_3;
                    v1 = v0;
                    v2 = v0.x;
                    v3 = var4_4;
                    ** GOTO lbl22
                }
                case 11: {
                    var3_3.x = var3_3.x - (var5_5 != false ? var4_4 : -var4_4);
                    break;
                }
                case 10: {
                    v4 = var3_3;
                    v1 = v4;
                    v2 = v4.x;
                    v3 = var5_5 != false ? var4_4 : -var4_4;
lbl22:
                    // 2 sources

                    v1.x = v2 + v3;
                }
            }
        }
        super.paintIcon(var1_1, var2_2, var3_3);
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (FlatButtonUI.isHelpButton(abstractButton)) {
            return;
        }
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(abstractButton) && abstractButton.getFont() instanceof UIResource) {
            Font font = graphics.getFont().deriveFont(1);
            graphics.setFont(font);
            int n = abstractButton.getFontMetrics(font).stringWidth(string);
            if (n > rectangle.width) {
                rectangle.x -= (n - rectangle.width) / 2;
                rectangle.width = n;
            }
        }
        FlatButtonUI.paintText(graphics, abstractButton, rectangle, string, this.getForeground(abstractButton));
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, Color color) {
        if (color == null) {
            color = Color.red;
        }
        AbstractButton abstractButton2 = abstractButton;
        FontMetrics fontMetrics = abstractButton2.getFontMetrics(abstractButton2.getFont());
        int n = FlatLaf.isShowMnemonics() ? abstractButton.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(color);
        FlatUIUtils.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected Color getBackground(JComponent jComponent) {
        boolean bl;
        boolean bl2 = bl = FlatButtonUI.isToolBarButton(jComponent) || FlatButtonUI.isBorderlessButton(jComponent);
        if (((AbstractButton)jComponent).isSelected()) {
            return FlatButtonUI.buttonStateColor(jComponent, bl ? this.toolbarSelectedBackground : this.selectedBackground, bl ? (this.toolbarDisabledSelectedBackground != null ? this.toolbarDisabledSelectedBackground : this.toolbarSelectedBackground) : this.disabledSelectedBackground, null, null, bl ? this.toolbarPressedBackground : this.pressedBackground);
        }
        if (bl) {
            Color color = jComponent.getBackground();
            return FlatButtonUI.buttonStateColor(jComponent, this.isCustomBackground(color) ? color : null, null, null, this.toolbarHoverBackground, this.toolbarPressedBackground);
        }
        bl = FlatButtonUI.isDefaultButton(jComponent);
        return FlatButtonUI.buttonStateColor(jComponent, this.getBackgroundBase(jComponent, bl), this.disabledBackground, this.isCustomBackground(jComponent.getBackground()) ? null : (bl ? this.defaultFocusedBackground : this.focusedBackground), bl ? this.defaultHoverBackground : this.hoverBackground, bl ? this.defaultPressedBackground : this.pressedBackground);
    }

    protected Color getBackgroundBase(JComponent serializable, boolean bl) {
        if (FlatUIUtils.isAWTPeer(serializable)) {
            return this.background;
        }
        if (this.isCustomBackground((Color)(serializable = serializable.getBackground()))) {
            return serializable;
        }
        if (bl) {
            return this.defaultBackground;
        }
        return serializable;
    }

    protected boolean isCustomBackground(Color color) {
        return color != this.background && (this.startBackground == null || color != this.startBackground);
    }

    public static Color buttonStateColor(Component component, Color color, Color object, Color color2, Color color3, Color color4) {
        if (component == null) {
            return color;
        }
        if (!component.isEnabled()) {
            return object;
        }
        if (component instanceof AbstractButton) {
            object = ((AbstractButton)component).getModel();
            if (color4 != null && object.isPressed()) {
                return color4;
            }
            if (color3 != null && object.isRollover()) {
                return color3;
            }
        }
        if (color2 != null && FlatButtonUI.isFocusPainted(component) && FlatUIUtils.isPermanentFocusOwner(component)) {
            return color2;
        }
        return color;
    }

    protected Color getForeground(JComponent jComponent) {
        boolean bl;
        Color color = jComponent.getForeground();
        boolean bl2 = bl = FlatButtonUI.isToolBarButton(jComponent) || FlatButtonUI.isBorderlessButton(jComponent);
        if (((AbstractButton)jComponent).isSelected()) {
            return FlatButtonUI.buttonStateColor(jComponent, bl ? (this.toolbarSelectedForeground != null ? this.toolbarSelectedForeground : color) : (this.isCustomForeground(color) ? color : this.selectedForeground), bl ? (this.toolbarDisabledSelectedForeground != null ? this.toolbarDisabledSelectedForeground : this.disabledText) : (this.disabledSelectedForeground != null ? this.disabledSelectedForeground : this.disabledText), null, null, bl ? this.toolbarPressedForeground : this.pressedForeground);
        }
        if (bl) {
            return FlatButtonUI.buttonStateColor(jComponent, color, this.disabledText, null, this.toolbarHoverForeground, this.toolbarPressedForeground);
        }
        bl = FlatButtonUI.isDefaultButton(jComponent);
        return FlatButtonUI.buttonStateColor(jComponent, this.getForegroundBase(jComponent, bl), this.disabledText, this.isCustomForeground(color) ? null : (bl ? this.defaultFocusedForeground : this.focusedForeground), bl ? this.defaultHoverForeground : this.hoverForeground, bl ? this.defaultPressedForeground : this.pressedForeground);
    }

    protected Color getForegroundBase(JComponent serializable, boolean bl) {
        if (this.isCustomForeground((Color)(serializable = serializable.getForeground()))) {
            return serializable;
        }
        if (bl) {
            return this.defaultForeground;
        }
        return serializable;
    }

    protected boolean isCustomForeground(Color color) {
        return color != this.foreground;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (FlatButtonUI.isHelpButton(jComponent)) {
            return new Dimension(this.helpButtonIcon.getIconWidth(), this.helpButtonIcon.getIconHeight());
        }
        Dimension dimension = super.getPreferredSize(jComponent);
        if (dimension == null) {
            return null;
        }
        dimension.width += this.defaultBoldPlainWidthDiff(jComponent);
        int n = FlatButtonUI.isIconOnlyOrSingleCharacterButton(jComponent);
        if (FlatClientProperties.clientPropertyBoolean(jComponent, "JButton.squareSize", this.squareSize)) {
            Dimension dimension2 = dimension;
            dimension2.width = dimension2.height = Math.max(dimension.width, dimension.height);
        } else if (n != 0 && ((AbstractButton)jComponent).getIcon() == null) {
            dimension.width = Math.max(dimension.width, dimension.height);
        } else if (n == 0 && !FlatButtonUI.isToolBarButton(jComponent) && jComponent.getBorder() instanceof FlatButtonBorder && this.hasDefaultMargins(jComponent)) {
            n = Math.round(FlatUIUtils.getBorderFocusWidth(jComponent) * 2.0f);
            dimension.width = Math.max(dimension.width, UIScale.scale(FlatUIUtils.minimumWidth(jComponent, this.minimumWidth)) + n);
            dimension.height = Math.max(dimension.height, UIScale.scale(FlatUIUtils.minimumHeight(jComponent, this.minimumHeight)) + n);
        }
        return dimension;
    }

    private int defaultBoldPlainWidthDiff(JComponent jComponent) {
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(jComponent) && jComponent.getFont() instanceof UIResource) {
            int n;
            String string = ((AbstractButton)jComponent).getText();
            if (string == null || string.isEmpty()) {
                return 0;
            }
            Font font = jComponent.getFont();
            Font font2 = font.deriveFont(1);
            int n2 = jComponent.getFontMetrics(font2).stringWidth(string);
            if (n2 > (n = jComponent.getFontMetrics(font).stringWidth(string))) {
                return n2 - n;
            }
        }
        return 0;
    }

    private boolean hasDefaultMargins(JComponent serializable) {
        return (serializable = ((AbstractButton)serializable).getMargin()) instanceof UIResource && Objects.equals(serializable, this.defaultMargin);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        return FlatButtonUI.getBaselineImpl(jComponent, n, n2);
    }

    static int getBaselineImpl(JComponent object, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        Object object2 = ((AbstractButton)(object = (AbstractButton)object)).getText();
        if (object2 == null || ((String)object2).isEmpty()) {
            return -1;
        }
        JComponent jComponent = object;
        object2 = jComponent.getFontMetrics(jComponent.getFont());
        FlatButtonUI.layout((AbstractButton)object, (FontMetrics)object2, n, n2);
        object = (View)((JComponent)object).getClientProperty("html");
        if (object != null) {
            int n3 = BasicHTML.getHTMLBaseline((View)object, FlatButtonUI.textR.width, FlatButtonUI.textR.height);
            if (n3 >= 0) {
                return FlatButtonUI.textR.y + n3;
            }
            return n3;
        }
        return FlatButtonUI.textR.y + ((FontMetrics)object2).getAscent();
    }

    private static String layout(AbstractButton abstractButton, FontMetrics fontMetrics, int n, int n2) {
        Insets insets = abstractButton.getInsets();
        viewR.setBounds(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        textR.setBounds(0, 0, 0, 0);
        iconR.setBounds(0, 0, 0, 0);
        String string = abstractButton.getText();
        return SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewR, iconR, textR, string != null ? abstractButton.getIconTextGap() : 0);
    }

    protected class FlatButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            FlatButtonUI.this.propertyChange(this.b, propertyChangeEvent);
        }

        @Override
        public void stateChanged(ChangeEvent serializable) {
            super.stateChanged((ChangeEvent)serializable);
            serializable = (AbstractButton)serializable.getSource();
            Object object = ((Component)serializable).getParent();
            if (object instanceof JToolBar) {
                object = (JToolBar)object;
                if ((object = ((JToolBar)object).getUI()) instanceof FlatToolBarUI) {
                    ((FlatToolBarUI)object).repaintButtonGroup((AbstractButton)serializable);
                }
            }
        }
    }
}

