/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowsNativeWindowBorder;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.function.Predicate;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;

public class FlatNativeWindowBorder {
    private static final boolean canUseWindowDecorations = SystemInfo.isWindows_10_orLater && (SystemInfo.isWindows_11_orLater || !FlatSystemProperties.getBoolean("sun.java2d.opengl", false)) && !SystemInfo.isProjector && !SystemInfo.isWebswing && !SystemInfo.isWinPE && FlatSystemProperties.getBoolean("flatlaf.useWindowDecorations", true);
    private static Boolean supported;
    private static Provider nativeProvider;

    public static boolean isSupported() {
        FlatNativeWindowBorder.initialize();
        return supported;
    }

    static Object install(JRootPane jRootPane) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return null;
        }
        Object object = jRootPane.getParent();
        if (object != null && !(object instanceof Window)) {
            return null;
        }
        if (object instanceof Window && ((Component)object).isDisplayable()) {
            FlatNativeWindowBorder.install((Window)object);
        }
        object = propertyChangeEvent -> {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Window) {
                FlatNativeWindowBorder.install((Window)object);
                return;
            }
            if (object == null && propertyChangeEvent.getOldValue() instanceof Window) {
                FlatNativeWindowBorder.uninstall((Window)propertyChangeEvent.getOldValue());
            }
        };
        jRootPane.addPropertyChangeListener("ancestor", (PropertyChangeListener)object);
        return object;
    }

    static void install(Window window) {
        if (FlatNativeWindowBorder.hasCustomDecoration(window)) {
            return;
        }
        if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            return;
        }
        if (window instanceof JFrame) {
            JRootPane jRootPane = ((JFrame)(window = (JFrame)window)).getRootPane();
            if (!FlatNativeWindowBorder.useWindowDecorations(jRootPane)) {
                return;
            }
            if (((Frame)window).isUndecorated()) {
                return;
            }
            FlatNativeWindowBorder.setHasCustomDecoration(window, true);
            if (!FlatNativeWindowBorder.hasCustomDecoration(window)) {
                return;
            }
            jRootPane.setWindowDecorationStyle(1);
            return;
        }
        if (window instanceof JDialog) {
            JRootPane jRootPane = ((JDialog)(window = (JDialog)window)).getRootPane();
            if (!FlatNativeWindowBorder.useWindowDecorations(jRootPane)) {
                return;
            }
            if (((Dialog)window).isUndecorated()) {
                return;
            }
            FlatNativeWindowBorder.setHasCustomDecoration(window, true);
            if (!FlatNativeWindowBorder.hasCustomDecoration(window)) {
                return;
            }
            jRootPane.setWindowDecorationStyle(2);
        }
    }

    static void uninstall(JRootPane container, Object object) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        if (object instanceof PropertyChangeListener) {
            container.removePropertyChangeListener("ancestor", (PropertyChangeListener)object);
        }
        if (UIManager.getLookAndFeel() instanceof FlatLaf && FlatNativeWindowBorder.useWindowDecorations(container)) {
            return;
        }
        if ((container = container.getParent()) instanceof Window) {
            FlatNativeWindowBorder.uninstall((Window)container);
        }
    }

    private static void uninstall(Window window) {
        if (!FlatNativeWindowBorder.hasCustomDecoration(window)) {
            return;
        }
        FlatNativeWindowBorder.setHasCustomDecoration(window, false);
        if (window instanceof JFrame) {
            window = (JFrame)window;
            ((JFrame)window).getRootPane().setWindowDecorationStyle(0);
            return;
        }
        if (window instanceof JDialog) {
            window = (JDialog)window;
            ((JDialog)window).getRootPane().setWindowDecorationStyle(0);
        }
    }

    private static boolean useWindowDecorations(JRootPane jRootPane) {
        return FlatUIUtils.getBoolean(jRootPane, "flatlaf.useWindowDecorations", "JRootPane.useWindowDecorations", "TitlePane.useWindowDecorations", false);
    }

    public static boolean hasCustomDecoration(Window window) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return nativeProvider.hasCustomDecoration(window);
    }

    public static void setHasCustomDecoration(Window window, boolean bl) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        nativeProvider.setHasCustomDecoration(window, bl);
    }

    static void setTitleBarHeightAndHitTestSpots(Window window, int n, Predicate<Point> predicate, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        nativeProvider.updateTitleBarInfo(window, n, predicate, rectangle, rectangle2, rectangle3, rectangle4);
    }

    static boolean showWindow(Window window, int n) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return nativeProvider.showWindow(window, n);
    }

    private static void initialize() {
        if (supported != null) {
            return;
        }
        supported = Boolean.FALSE;
        if (!canUseWindowDecorations) {
            return;
        }
        try {
            FlatNativeWindowBorder.setNativeProvider(FlatWindowsNativeWindowBorder.getInstance());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void setNativeProvider(Provider provider) {
        if (nativeProvider != null) {
            throw new IllegalStateException();
        }
        nativeProvider = provider;
        supported = nativeProvider != null;
    }

    static class WindowTopBorder
    extends BorderUIResource.EmptyBorderUIResource {
        private static WindowTopBorder instance;
        private final Color activeLightColor = new Color(0x707070);
        private final Color activeDarkColor = new Color(2960943);
        private final Color inactiveLightColor = new Color(0xAAAAAA);
        private final Color inactiveDarkColor = new Color(4803147);
        private boolean colorizationAffectsBorders;
        private Color activeColor;

        static WindowTopBorder getInstance() {
            if (instance == null) {
                instance = new WindowTopBorder();
            }
            return instance;
        }

        WindowTopBorder() {
            super(1, 0, 0, 0);
            this.update();
            this.installListeners();
        }

        void update() {
            this.colorizationAffectsBorders = this.isColorizationColorAffectsBorders();
            this.activeColor = this.calculateActiveBorderColor();
        }

        void installListeners() {
            nativeProvider.addChangeListener(windowArray -> {
                this.update();
                for (Window window : Window.getWindows()) {
                    if (!window.isDisplayable()) continue;
                    window.repaint(0, 0, window.getWidth(), 1);
                }
            });
        }

        boolean isColorizationColorAffectsBorders() {
            return nativeProvider.isColorizationColorAffectsBorders();
        }

        Color getColorizationColor() {
            return nativeProvider.getColorizationColor();
        }

        int getColorizationColorBalance() {
            return nativeProvider.getColorizationColorBalance();
        }

        private Color calculateActiveBorderColor() {
            if (!this.colorizationAffectsBorders) {
                return null;
            }
            Color color = this.getColorizationColor();
            if (color != null) {
                int n = this.getColorizationColorBalance();
                if (n < 0 || n > 100) {
                    n = 100;
                }
                if (n == 0) {
                    return new Color(0xD9D9D9);
                }
                if (n == 100) {
                    return color;
                }
                float f = (float)n / 100.0f;
                float f2 = 1.0f - f;
                int n2 = Math.round((float)color.getRed() * f + 217.0f * f2);
                int n3 = Math.round((float)color.getGreen() * f + 217.0f * f2);
                int n4 = Math.round((float)color.getBlue() * f + 217.0f * f2);
                n2 = Math.min(Math.max(n2, 0), 255);
                n3 = Math.min(Math.max(n3, 0), 255);
                n4 = Math.min(Math.max(n4, 0), 255);
                return new Color(n2, n3, n4);
            }
            Color color2 = (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.activeBorderColor");
            if (color2 != null) {
                return color2;
            }
            return UIManager.getColor("MenuBar.borderColor");
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = (component = SwingUtilities.windowForComponent(component)) != null && ((Window)component).isActive();
            boolean bl2 = FlatLaf.isLafDark();
            graphics.setColor(bl ? (this.activeColor != null ? this.activeColor : (bl2 ? this.activeDarkColor : this.activeLightColor)) : (bl2 ? this.inactiveDarkColor : this.inactiveLightColor));
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n, n2, n3, n4, this::paintImpl);
        }

        private void paintImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
            graphics2D.fillRect(n, n2, n3, 1);
        }

        void repaintBorder(Component component) {
            component.repaint(0, 0, component.getWidth(), 1);
        }
    }

    public static interface Provider {
        public static final int SW_MAXIMIZE = 3;
        public static final int SW_MINIMIZE = 6;
        public static final int SW_RESTORE = 9;

        public boolean hasCustomDecoration(Window var1);

        public void setHasCustomDecoration(Window var1, boolean var2);

        public void updateTitleBarInfo(Window var1, int var2, Predicate<Point> var3, Rectangle var4, Rectangle var5, Rectangle var6, Rectangle var7);

        public boolean showWindow(Window var1, int var2);

        public boolean isColorizationColorAffectsBorders();

        public Color getColorizationColor();

        public int getColorizationColorBalance();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

