/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowResizer;
import com.formdev.flatlaf.ui.FullWindowContentSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class FlatRootPaneUI
extends BasicRootPaneUI {
    protected final Color borderColor = UIManager.getColor("TitlePane.borderColor");
    protected JRootPane rootPane;
    protected FlatTitlePane titlePane;
    protected FlatWindowResizer windowResizer;
    private Object nativeWindowBorderData;
    private LayoutManager oldLayout;
    private ComponentListener macFullWindowContentListener;
    private PropertyChangeListener macWindowBackgroundListener;
    protected static final Integer TITLE_PANE_LAYER = JLayeredPane.FRAME_CONTENT_LAYER - 1;
    private static final Integer TITLE_PANE_MOUSE_LAYER = JLayeredPane.FRAME_CONTENT_LAYER - 2;
    private static final Integer WINDOW_TOP_BORDER_LAYER = Integer.MAX_VALUE;
    protected static final Integer TITLE_PANE_FULL_WINDOW_CONTENT_LAYER = JLayeredPane.FRAME_CONTENT_LAYER + 1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.rootPane = (JRootPane)jComponent;
        if (this.rootPane.getWindowDecorationStyle() != 0) {
            this.installClientDecorations();
        } else {
            this.installBorder();
        }
        this.installNativeWindowBorder();
        this.macInstallFullWindowContentSupport();
    }

    protected void installBorder() {
        Border border;
        if (this.borderColor != null && ((border = this.rootPane.getBorder()) == null || border instanceof UIResource)) {
            this.rootPane.setBorder(new FlatWindowTitleBorder(this.borderColor));
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallNativeWindowBorder();
        this.uninstallClientDecorations();
        this.macUninstallFullWindowContentSupport();
        this.rootPane = null;
    }

    @Override
    protected void installDefaults(JRootPane jRootPane) {
        Color color;
        Container container;
        super.installDefaults(jRootPane);
        if (!jRootPane.isBackgroundSet() || jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(UIManager.getColor("RootPane.background"));
        }
        if (!jRootPane.isForegroundSet() || jRootPane.getForeground() instanceof UIResource) {
            jRootPane.setForeground(UIManager.getColor("RootPane.foreground"));
        }
        if (!jRootPane.isFontSet() || jRootPane.getFont() instanceof UIResource) {
            jRootPane.setFont(UIManager.getFont("RootPane.font"));
        }
        if (((container = jRootPane.getParent()) instanceof JFrame || container instanceof JDialog) && ((color = container.getBackground()) == null || color instanceof UIResource)) {
            container.setBackground(UIManager.getColor("control"));
        }
        this.macClearBackgroundForTranslucentWindow(jRootPane);
    }

    @Override
    protected void uninstallDefaults(JRootPane jRootPane) {
        super.uninstallDefaults(jRootPane);
        if (jRootPane.isBackgroundSet() && jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(null);
        }
        if (jRootPane.isForegroundSet() && jRootPane.getForeground() instanceof UIResource) {
            jRootPane.setForeground(null);
        }
        if (jRootPane.isFontSet() && jRootPane.getFont() instanceof UIResource) {
            jRootPane.setFont(null);
        }
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        if (SystemInfo.isMacFullWindowContentSupported) {
            this.macFullWindowContentListener = FullWindowContentSupport.macInstallListeners(jRootPane);
        }
        this.macInstallWindowBackgroundListener(jRootPane);
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        super.uninstallListeners(jRootPane);
        if (SystemInfo.isMacFullWindowContentSupported) {
            FullWindowContentSupport.macUninstallListeners(jRootPane, this.macFullWindowContentListener);
            this.macFullWindowContentListener = null;
        }
        this.macUninstallWindowBackgroundListener(jRootPane);
    }

    protected void installNativeWindowBorder() {
        this.nativeWindowBorderData = FlatNativeWindowBorder.install(this.rootPane);
    }

    protected void uninstallNativeWindowBorder() {
        FlatNativeWindowBorder.uninstall(this.rootPane, this.nativeWindowBorderData);
        this.nativeWindowBorderData = null;
    }

    public static void updateNativeWindowBorder(JRootPane object) {
        if (!((object = ((JRootPane)object).getUI()) instanceof FlatRootPaneUI)) {
            return;
        }
        object = (FlatRootPaneUI)object;
        ((FlatRootPaneUI)object).uninstallNativeWindowBorder();
        ((FlatRootPaneUI)object).installNativeWindowBorder();
    }

    protected void installClientDecorations() {
        boolean bl = FlatNativeWindowBorder.isSupported();
        if (this.rootPane.getWindowDecorationStyle() != 0 && !bl) {
            LookAndFeel.installBorder(this.rootPane, "RootPane.border");
        } else {
            LookAndFeel.uninstallBorder(this.rootPane);
        }
        FlatRootPaneUI flatRootPaneUI = this;
        flatRootPaneUI.setTitlePane(flatRootPaneUI.createTitlePane());
        this.oldLayout = this.rootPane.getLayout();
        this.rootPane.setLayout(this.createRootLayout());
        if (!bl) {
            this.windowResizer = this.createWindowResizer();
        }
    }

    protected void uninstallClientDecorations() {
        LookAndFeel.uninstallBorder(this.rootPane);
        this.setTitlePane(null);
        if (this.windowResizer != null) {
            this.windowResizer.uninstall();
            this.windowResizer = null;
        }
        if (this.oldLayout != null) {
            this.rootPane.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
        if (this.rootPane.getWindowDecorationStyle() == 0) {
            this.rootPane.revalidate();
            this.rootPane.repaint();
        }
    }

    protected FlatRootLayout createRootLayout() {
        return new FlatRootLayout();
    }

    protected FlatWindowResizer createWindowResizer() {
        return new FlatWindowResizer.WindowResizer(this.rootPane);
    }

    protected FlatTitlePane createTitlePane() {
        return new FlatTitlePane(this.rootPane);
    }

    private Integer getLayerForTitlePane() {
        if (FlatRootPaneUI.isFullWindowContent(this.rootPane)) {
            return TITLE_PANE_FULL_WINDOW_CONTENT_LAYER;
        }
        return TITLE_PANE_LAYER;
    }

    protected void setTitlePane(FlatTitlePane flatTitlePane) {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        if (this.titlePane != null) {
            jLayeredPane.remove(this.titlePane);
            jLayeredPane.remove(this.titlePane.mouseLayer);
            if (this.titlePane.windowTopBorderLayer != null) {
                jLayeredPane.remove(this.titlePane.windowTopBorderLayer);
            }
        }
        if (flatTitlePane != null) {
            jLayeredPane.add((Component)flatTitlePane, this.getLayerForTitlePane());
            jLayeredPane.add((Component)flatTitlePane.mouseLayer, TITLE_PANE_MOUSE_LAYER);
            if (flatTitlePane.windowTopBorderLayer != null && flatTitlePane.isWindowTopBorderNeeded() && FlatRootPaneUI.isFullWindowContent(this.rootPane)) {
                jLayeredPane.add((Component)flatTitlePane.windowTopBorderLayer, WINDOW_TOP_BORDER_LAYER);
            }
        }
        this.titlePane = flatTitlePane;
    }

    private void macInstallFullWindowContentSupport() {
        if (!SystemInfo.isMacOS) {
            return;
        }
        if (this.isMacButtonsSpacingSupported() && this.rootPane.isDisplayable()) {
            int n = 0;
            String string = (String)this.rootPane.getClientProperty("FlatLaf.macOS.windowButtonsSpacing");
            if (string != null) {
                int n2 = -1;
                switch (string.hashCode()) {
                    case -1078030475: {
                        if (!string.equals("medium")) break;
                        n2 = 0;
                        break;
                    }
                    case 102742843: {
                        if (!string.equals("large")) break;
                        n2 = 1;
                    }
                }
                switch (n2) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                    }
                }
            }
            FlatRootPaneUI flatRootPaneUI = this;
            FlatNativeMacLibrary.setWindowButtonsSpacing(flatRootPaneUI.getParentWindow(flatRootPaneUI.rootPane), n);
        }
        FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(this.rootPane);
    }

    private void macUninstallFullWindowContentSupport() {
        if (!SystemInfo.isMacOS) {
            return;
        }
        if (UIManager.getLookAndFeel() instanceof FlatLaf) {
            return;
        }
        if (this.isMacButtonsSpacingSupported()) {
            FlatRootPaneUI flatRootPaneUI = this;
            FlatNativeMacLibrary.setWindowButtonsSpacing(flatRootPaneUI.getParentWindow(flatRootPaneUI.rootPane), 0);
        }
        FullWindowContentSupport.macUninstallFullWindowContentButtonsBoundsProperty(this.rootPane);
    }

    private boolean isMacButtonsSpacingSupported() {
        return SystemInfo.isMacOS && SystemInfo.isJava_17_orLater && FlatNativeMacLibrary.isLoaded();
    }

    private void macInstallWindowBackgroundListener(JRootPane jRootPane) {
        if (!SystemInfo.isMacOS) {
            return;
        }
        Window window = this.getParentWindow(jRootPane);
        if (window != null && this.macWindowBackgroundListener == null) {
            this.macWindowBackgroundListener = propertyChangeEvent -> this.macClearBackgroundForTranslucentWindow(jRootPane);
            window.addPropertyChangeListener("background", this.macWindowBackgroundListener);
        }
    }

    private void macUninstallWindowBackgroundListener(JRootPane container) {
        if (!SystemInfo.isMacOS) {
            return;
        }
        if ((container = this.getParentWindow((JRootPane)container)) != null && this.macWindowBackgroundListener != null) {
            container.removePropertyChangeListener("background", this.macWindowBackgroundListener);
            this.macWindowBackgroundListener = null;
        }
    }

    private void macClearBackgroundForTranslucentWindow(JRootPane jRootPane) {
        if (!SystemInfo.isMacOS) {
            return;
        }
        Serializable serializable = this.getParentWindow(jRootPane);
        if (serializable != null && (serializable = ((Window)serializable).getBackground()) != null && ((Color)serializable).getAlpha() < 255 && jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(null);
        }
    }

    private Window getParentWindow(JRootPane container) {
        if ((container = container.getParent()) instanceof Window) {
            return (Window)container;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent serializable) {
        super.propertyChange((PropertyChangeEvent)serializable);
        switch (((PropertyChangeEvent)serializable).getPropertyName()) {
            case "windowDecorationStyle": {
                this.uninstallClientDecorations();
                if (this.rootPane.getWindowDecorationStyle() != 0) {
                    this.installClientDecorations();
                    return;
                }
                this.installBorder();
                return;
            }
            case "JRootPane.useWindowDecorations": {
                FlatRootPaneUI.updateNativeWindowBorder(this.rootPane);
                return;
            }
            case "JRootPane.menuBarEmbedded": {
                if (this.titlePane == null) break;
                this.titlePane.menuBarChanged();
                this.rootPane.revalidate();
                this.rootPane.repaint();
                return;
            }
            case "JRootPane.titleBarShowIcon": {
                if (this.titlePane == null) break;
                this.titlePane.updateIcon();
                return;
            }
            case "JRootPane.titleBarShowTitle": 
            case "JRootPane.titleBarShowIconify": 
            case "JRootPane.titleBarShowMaximize": 
            case "JRootPane.titleBarShowClose": {
                if (this.titlePane == null) break;
                this.titlePane.updateVisibility();
                return;
            }
            case "JRootPane.titleBarBackground": 
            case "JRootPane.titleBarForeground": {
                if (this.titlePane == null) break;
                this.titlePane.titleBarColorsChanged();
                return;
            }
            case "FlatLaf.fullWindowContent": {
                if (this.titlePane != null) {
                    this.rootPane.getLayeredPane().setLayer(this.titlePane, this.getLayerForTitlePane());
                    if (this.titlePane.windowTopBorderLayer != null) {
                        serializable = this.rootPane.getLayeredPane();
                        if (this.titlePane.isWindowTopBorderNeeded() && FlatRootPaneUI.isFullWindowContent(this.rootPane)) {
                            ((Container)serializable).add((Component)this.titlePane.windowTopBorderLayer, WINDOW_TOP_BORDER_LAYER);
                        } else {
                            ((Container)serializable).remove(this.titlePane.windowTopBorderLayer);
                        }
                    }
                    this.titlePane.updateIcon();
                    this.titlePane.updateVisibility();
                    this.titlePane.updateFullWindowContentButtonsBoundsProperty();
                }
                FullWindowContentSupport.revalidatePlaceholders(this.rootPane);
                this.rootPane.revalidate();
                return;
            }
            case "FlatLaf.fullWindowContent.buttonsBounds": {
                FullWindowContentSupport.revalidatePlaceholders(this.rootPane);
                return;
            }
            case "JRootPane.glassPaneFullHeight": {
                this.rootPane.revalidate();
                return;
            }
            case "Window.style": {
                if (!this.rootPane.isDisplayable()) break;
                throw new IllegalComponentStateException("The client property 'Window.style' must be set before the window becomes displayable.");
            }
            case "ancestor": {
                if (((PropertyChangeEvent)serializable).getNewValue() instanceof Window) {
                    FlatRootPaneUI flatRootPaneUI = this;
                    flatRootPaneUI.macClearBackgroundForTranslucentWindow(flatRootPaneUI.rootPane);
                }
                FlatRootPaneUI flatRootPaneUI = this;
                flatRootPaneUI.macUninstallWindowBackgroundListener(flatRootPaneUI.rootPane);
                FlatRootPaneUI flatRootPaneUI2 = this;
                flatRootPaneUI2.macInstallWindowBackgroundListener(flatRootPaneUI2.rootPane);
                if (!(((PropertyChangeEvent)serializable).getNewValue() instanceof Window)) break;
                this.macInstallFullWindowContentSupport();
                return;
            }
            case "FlatLaf.macOS.windowButtonsSpacing": {
                this.macInstallFullWindowContentSupport();
                return;
            }
            case "apple.awt.fullWindowContent": {
                if (!SystemInfo.isMacFullWindowContentSupported) break;
                FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(this.rootPane);
            }
        }
    }

    protected static boolean isFullWindowContent(JRootPane jRootPane) {
        return FlatClientProperties.clientPropertyBoolean(jRootPane, "FlatLaf.fullWindowContent", false);
    }

    protected static boolean isMenuBarEmbedded(JRootPane jComponent) {
        return (jComponent = FlatRootPaneUI.getTitlePane((JRootPane)jComponent)) != null && ((FlatTitlePane)jComponent).isMenuBarEmbedded();
    }

    protected static FlatTitlePane getTitlePane(JRootPane object) {
        if ((object = ((JRootPane)object).getUI()) instanceof FlatRootPaneUI) {
            return ((FlatRootPaneUI)object).titlePane;
        }
        return null;
    }

    private static class FlatWindowTitleBorder
    extends BorderUIResource.EmptyBorderUIResource {
        private final Color borderColor;

        FlatWindowTitleBorder(Color color) {
            super(0, 0, 0, 0);
            this.borderColor = color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.showBorder(component)) {
                float f = UIScale.scale(1.0f);
                FlatUIUtils.paintFilledRectangle(graphics, this.borderColor, n, n2, n3, f);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(this.showBorder(component) ? 1 : 0, 0, 0, 0);
            return insets;
        }

        private boolean showBorder(Component component) {
            return (component = component.getParent()) instanceof JFrame && (((JFrame)component).getJMenuBar() == null || !((JFrame)component).getJMenuBar().isVisible()) || component instanceof JDialog && (((JDialog)component).getJMenuBar() == null || !((JDialog)component).getJMenuBar().isVisible());
        }
    }

    public static class FlatWindowBorder
    extends BorderUIResource.EmptyBorderUIResource {
        protected final Color activeBorderColor = UIManager.getColor("RootPane.activeBorderColor");
        protected final Color inactiveBorderColor = UIManager.getColor("RootPane.inactiveBorderColor");
        protected final Color baseBorderColor = UIManager.getColor("Panel.background");

        public FlatWindowBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (this.isWindowMaximized(component) || FlatUIUtils.isFullScreen(component)) {
                Insets insets2 = insets;
                Insets insets3 = insets;
                insets3.right = 0;
                insets3.bottom = 0;
                insets2.left = 0;
                insets2.top = 0;
                return insets;
            }
            return super.getBorderInsets(component, insets);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.isWindowMaximized(component) || FlatUIUtils.isFullScreen(component)) {
                return;
            }
            boolean bl = (component = component.getParent()) instanceof Window && ((Window)component).isActive();
            graphics.setColor(FlatUIUtils.deriveColor(bl ? this.activeBorderColor : this.inactiveBorderColor, this.baseBorderColor));
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n, n2, n3, n4, this::paintImpl);
        }

        private void paintImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        protected boolean isWindowMaximized(Component component) {
            return (component = component.getParent()) instanceof Frame && (((Frame)component).getExtendedState() & 6) == 6;
        }
    }

    protected class FlatRootLayout
    implements LayoutManager2 {
        protected FlatRootLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.computeLayoutSize(container, component -> component.getPreferredSize());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.computeLayoutSize(container, component -> component.getMinimumSize());
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private Dimension computeLayoutSize(Container container, Function<Component, Dimension> object) {
            Serializable serializable;
            Dimension dimension = ((JRootPane)(container = (JRootPane)container)).getContentPane() != null ? object.apply((Component)((JRootPane)container).getContentPane()) : container.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (FlatRootPaneUI.this.titlePane != null && !FlatRootPaneUI.isFullWindowContent((JRootPane)container)) {
                n2 += object.apply((Component)FlatRootPaneUI.this.titlePane).height;
            }
            if ((FlatRootPaneUI.this.titlePane == null || !FlatRootPaneUI.this.titlePane.isMenuBarEmbedded()) && (serializable = ((JRootPane)container).getJMenuBar()) != null && serializable.isVisible()) {
                object = object.apply((Component)serializable);
                n = Math.max(n, ((Dimension)object).width);
                n2 += ((Dimension)object).height;
            }
            serializable = ((JComponent)container).getInsets();
            return new Dimension(n + ((Insets)serializable).left + ((Insets)serializable).right, n2 + ((Insets)serializable).top + ((Insets)serializable).bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            Container container2;
            JMenuBar jMenuBar;
            int n;
            int n2;
            int n3;
            int n4;
            container = (JRootPane)container;
            int n5 = FlatUIUtils.isFullScreen(container);
            Insets insets = ((JComponent)container).getInsets();
            int n6 = insets.left;
            int n7 = insets.top;
            int n8 = ((JComponent)container).getWidth() - insets.left - insets.right;
            int n9 = ((JComponent)container).getHeight() - insets.top - insets.bottom;
            if (((JRootPane)container).getLayeredPane() != null) {
                ((JRootPane)container).getLayeredPane().setBounds(n6, n7, n8, n9);
            }
            int n10 = 0;
            if (FlatRootPaneUI.this.titlePane != null) {
                n4 = n5 == 0 ? FlatRootPaneUI.this.titlePane.getPreferredSize().height : 0;
                n3 = FlatRootPaneUI.isFullWindowContent((JRootPane)container) ? 1 : 0;
                if (n3 != 0 && !UIManager.getBoolean("FlatLaf.debug.titlebar.showRectangles")) {
                    n2 = Math.min(FlatRootPaneUI.this.titlePane.getPreferredSize().width, n8);
                    n = FlatRootPaneUI.this.titlePane.getComponentOrientation().isLeftToRight() ? n8 - n2 : 0;
                    FlatRootPaneUI.this.titlePane.setBounds(n, 0, n2, n4);
                } else {
                    FlatRootPaneUI.this.titlePane.setBounds(0, 0, n8, n4);
                }
                FlatRootPaneUI.this.titlePane.mouseLayer.setBounds(0, 0, n8, n4);
                if (FlatRootPaneUI.this.titlePane.windowTopBorderLayer != null) {
                    n2 = n3 != 0 && !FlatRootPaneUI.this.titlePane.isWindowMaximized() && n5 == 0 ? 1 : 0;
                    if (n2 != 0) {
                        FlatRootPaneUI.this.titlePane.windowTopBorderLayer.setBounds(0, 0, n8, 1);
                    }
                    FlatRootPaneUI.this.titlePane.windowTopBorderLayer.setVisible(n2 != 0);
                }
                if (n3 == 0) {
                    n10 = n4 + 0;
                }
            }
            if (((JRootPane)container).getGlassPane() != null) {
                boolean bl = FlatClientProperties.clientPropertyBoolean((JComponent)container, "JRootPane.glassPaneFullHeight", false);
                n4 = bl ? 1 : 0;
                n3 = bl ? 0 : n10;
                ((JRootPane)container).getGlassPane().setBounds(n6, n7 + n3, n8, n9 - n3);
            }
            if ((jMenuBar = ((JRootPane)container).getJMenuBar()) != null && jMenuBar.isVisible()) {
                n3 = n5 == 0 && FlatRootPaneUI.this.titlePane != null && FlatRootPaneUI.this.titlePane.isMenuBarEmbedded() ? 1 : 0;
                if (n3 != 0) {
                    FlatRootPaneUI.this.titlePane.validate();
                    jMenuBar.setBounds(FlatRootPaneUI.this.titlePane.getMenuBarBounds());
                } else {
                    n2 = 0;
                    n = n8;
                    if (FlatRootPaneUI.this.titlePane != null && FlatRootPaneUI.isFullWindowContent((JRootPane)container)) {
                        n5 = Math.min(FlatRootPaneUI.this.titlePane.getPreferredSize().width, n8);
                        n = n8 - n5;
                        if (!FlatRootPaneUI.this.titlePane.getComponentOrientation().isLeftToRight()) {
                            n2 = n5;
                        }
                    }
                    Dimension dimension = jMenuBar.getPreferredSize();
                    jMenuBar.setBounds(n2, n10, n, dimension.height);
                    n10 += dimension.height;
                }
            }
            if ((container2 = ((JRootPane)container).getContentPane()) != null) {
                container2.setBounds(0, n10, n8, Math.max(n9 - n10, 0));
            }
            if (FlatRootPaneUI.this.titlePane != null) {
                FlatRootPaneUI.this.titlePane.menuBarLayouted();
            }
        }

        @Override
        public void invalidateLayout(Container container) {
            if (FlatRootPaneUI.this.titlePane != null) {
                FlatRootPaneUI.this.titlePane.menuBarInvalidate();
            }
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }
    }
}

