/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FlatTableHeaderUI
extends BasicTableHeaderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color bottomSeparatorColor;
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable(type=String.class)
    protected int sortIconPosition;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    @FlatStylingSupport.Styleable
    protected Boolean showTrailingVerticalLine;
    @FlatStylingSupport.Styleable
    public String arrowType;
    @FlatStylingSupport.Styleable
    public Color sortIconColor;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.header.remove(this.rendererPane);
        this.rendererPane = new FlatTableHeaderCellRendererPane();
        this.header.add(this.rendererPane);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hoverBackground = UIManager.getColor("TableHeader.hoverBackground");
        this.hoverForeground = UIManager.getColor("TableHeader.hoverForeground");
        this.pressedBackground = UIManager.getColor("TableHeader.pressedBackground");
        this.pressedForeground = UIManager.getColor("TableHeader.pressedForeground");
        this.bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
        this.height = UIManager.getInt("TableHeader.height");
        this.sortIconPosition = FlatTableHeaderUI.parseSortIconPosition(UIManager.getString("TableHeader.sortIconPosition"));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverBackground = null;
        this.hoverForeground = null;
        this.pressedBackground = null;
        this.pressedForeground = null;
        this.bottomSeparatorColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.header, this::installStyle, null);
        this.header.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.header.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            FlatTableHeaderUI flatTableHeaderUI = this;
            flatTableHeaderUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatTableHeaderUI.header, "TableHeader"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("sortIconPosition") && object instanceof String) {
            object = FlatTableHeaderUI.parseSortIconPosition((String)object);
        }
        FlatTableHeaderUI flatTableHeaderUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatTableHeaderUI, flatTableHeaderUI.header, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.equals("sortIconPosition")) {
            switch (this.sortIconPosition) {
                default: {
                    return "right";
                }
                case 2: {
                    return "left";
                }
                case 1: {
                    return "top";
                }
                case 3: 
            }
            return "bottom";
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private static int parseSortIconPosition(String string) {
        if (string == null) {
            string = "";
        }
        int n = -1;
        switch (string.hashCode()) {
            case 108511772: {
                if (!string.equals("right")) break;
                n = 1;
                break;
            }
            case 3317767: {
                if (!string.equals("left")) break;
                n = 2;
                break;
            }
            case 115029: {
                if (!string.equals("top")) break;
                n = 3;
                break;
            }
            case -1383228885: {
                if (!string.equals("bottom")) break;
                n = 4;
            }
        }
        switch (n) {
            default: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: 
        }
        return 3;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new FlatMouseInputHandler();
    }

    @Override
    public int getRolloverColumn() {
        return super.getRolloverColumn();
    }

    @Override
    protected void rolloverColumnUpdated(int n, int n2) {
        this.header.repaint(this.header.getHeaderRect(n));
        this.header.repaint(this.header.getHeaderRect(n2));
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        FlatTableHeaderUI.fixDraggedAndResizingColumns(this.header);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel.getColumnCount() <= 0) {
            return;
        }
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += tableColumnModel.getColumn(i).getWidth();
        }
        if (n2 < this.header.getWidth()) {
            TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
            int n3 = this.isSystemDefaultRenderer(tableCellRenderer);
            if (n3 == 0 && this.header.getTable() != null) {
                Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), "", false, false, -1, 0);
                n3 = this.isSystemDefaultRenderer(component) ? 1 : 0;
            }
            if (n3 != 0) {
                n3 = jComponent.getWidth() - n2;
                n = this.header.getComponentOrientation().isLeftToRight() ? jComponent.getWidth() - n3 : 0;
                this.paintBottomSeparator(graphics, jComponent, n, n3);
            }
        }
        super.paint(graphics, jComponent);
    }

    private boolean isSystemDefaultRenderer(Object object) {
        return ((String)(object = object.getClass().getName())).equals("sun.swing.table.DefaultTableCellHeaderRenderer") || ((String)object).equals("sun.swing.FilePane$AlignableTableHeaderRenderer");
    }

    protected void paintBottomSeparator(Graphics graphics, JComponent jComponent, int n, int n2) {
        float f = UIScale.scale(1.0f);
        graphics = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics);
            graphics.setColor(this.bottomSeparatorColor);
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(n, (float)jComponent.getHeight() - f, n2, f));
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent serializable) {
        serializable = super.getPreferredSize((JComponent)serializable);
        if (((Dimension)serializable).height > 0) {
            ((Dimension)serializable).height = Math.max(((Dimension)serializable).height, UIScale.scale(this.height));
        }
        return serializable;
    }

    static void fixDraggedAndResizingColumns(JTableHeader jTableHeader) {
        if (jTableHeader == null) {
            return;
        }
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn != null && !FlatTableHeaderUI.isValidColumn(jTableHeader.getColumnModel(), tableColumn)) {
            jTableHeader.setDraggedColumn(null);
        }
        if ((tableColumn = jTableHeader.getResizingColumn()) != null && !FlatTableHeaderUI.isValidColumn(jTableHeader.getColumnModel(), tableColumn)) {
            jTableHeader.setResizingColumn(null);
        }
    }

    private static boolean isValidColumn(TableColumnModel tableColumnModel, TableColumn tableColumn) {
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return true;
        }
        return false;
    }

    protected class FlatMouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        Cursor oldCursor;

        protected FlatMouseInputHandler() {
            super(FlatTableHeaderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            JTable jTable;
            if (this.oldCursor != null) {
                FlatTableHeaderUI.this.header.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
            super.mouseMoved(mouseEvent);
            if (FlatTableHeaderUI.this.header.isEnabled() && (jTable = FlatTableHeaderUI.this.header.getTable()) != null && jTable.getAutoResizeMode() != 0 && FlatTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11) && (n = FlatTableHeaderUI.this.header.columnAtPoint(mouseEvent.getPoint())) >= 0 && n == FlatTableHeaderUI.this.header.getColumnModel().getColumnCount() - 1) {
                Rectangle rectangle = FlatTableHeaderUI.this.header.getHeaderRect(n);
                rectangle.grow(-3, 0);
                if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    boolean bl;
                    boolean bl2 = bl = mouseEvent.getX() >= rectangle.x + rectangle.width / 2;
                    if (!FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                        boolean bl3 = bl = !bl;
                    }
                    if (bl) {
                        this.oldCursor = FlatTableHeaderUI.this.header.getCursor();
                        FlatTableHeaderUI.this.header.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
    }

    private class FlatTableHeaderCellRendererPane
    extends CellRendererPane {
        private final Icon ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        private final Icon descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");

        @Override
        public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
            boolean bl2;
            if (!(component instanceof JLabel)) {
                super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
                return;
            }
            JLabel jLabel = (JLabel)component;
            Color color = null;
            Color color2 = null;
            boolean bl3 = false;
            Object object = null;
            int n5 = -1;
            Object object2 = FlatTableHeaderUI.this.header.getDraggedColumn();
            Color color3 = null;
            Color color4 = null;
            if (object2 != null && FlatTableHeaderUI.this.header.getTable().convertColumnIndexToView(((TableColumn)object2).getModelIndex()) == this.getColumn(n - FlatTableHeaderUI.this.header.getDraggedDistance(), n3)) {
                color3 = FlatTableHeaderUI.this.pressedBackground;
                color4 = FlatTableHeaderUI.this.pressedForeground;
            } else if (FlatTableHeaderUI.this.getRolloverColumn() >= 0 && FlatTableHeaderUI.this.getRolloverColumn() == this.getColumn(n, n3)) {
                color3 = FlatTableHeaderUI.this.hoverBackground;
                color4 = FlatTableHeaderUI.this.hoverForeground;
            }
            if (color3 != null) {
                color = jLabel.getBackground();
                bl3 = jLabel.isOpaque();
                jLabel.setBackground(FlatUIUtils.deriveColor(color3, FlatTableHeaderUI.this.header.getBackground()));
                jLabel.setOpaque(true);
            }
            if (color4 != null) {
                color2 = jLabel.getForeground();
                jLabel.setForeground(FlatUIUtils.deriveColor(color4, FlatTableHeaderUI.this.header.getForeground()));
            }
            if (bl2 = (object2 = jLabel.getIcon()) != null && (object2 == this.ascendingSortIcon || object2 == this.descendingSortIcon)) {
                if (FlatTableHeaderUI.this.sortIconPosition == 2) {
                    n5 = jLabel.getHorizontalTextPosition();
                    jLabel.setHorizontalTextPosition(4);
                } else if (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3) {
                    object = object2;
                    jLabel.setIcon(null);
                }
            }
            super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
            if (bl2 && (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3)) {
                int n6 = n + (n3 - object2.getIconWidth()) / 2;
                n = FlatTableHeaderUI.this.sortIconPosition == 1 ? n2 + UIScale.scale(1) : n2 + FlatTableHeaderUI.this.height - object2.getIconHeight() - 1 - (int)(1.0f * UIScale.getUserScaleFactor());
                object2.paintIcon(component, graphics, n6, n);
            }
            if (color3 != null) {
                jLabel.setBackground(color);
                jLabel.setOpaque(bl3);
            }
            if (color4 != null) {
                jLabel.setForeground(color2);
            }
            if (object != null) {
                jLabel.setIcon((Icon)object);
            }
            if (n5 >= 0) {
                jLabel.setHorizontalTextPosition(n5);
            }
        }

        private int getColumn(int n, int n2) {
            TableColumnModel tableColumnModel = FlatTableHeaderUI.this.header.getColumnModel();
            int n3 = tableColumnModel.getColumnCount();
            boolean bl = FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            int n4 = bl ? 0 : this.getWidthInRightToLef();
            for (int i = 0; i < n3; ++i) {
                int n5 = tableColumnModel.getColumn(i).getWidth();
                if (n == n4 - (bl ? 0 : n5) && n2 == n5) {
                    return i;
                }
                n4 += bl ? n5 : -n5;
            }
            return -1;
        }

        private int getWidthInRightToLef() {
            JTable jTable = FlatTableHeaderUI.this.header.getTable();
            if (jTable != null && jTable.getAutoResizeMode() != 0) {
                return jTable.getWidth();
            }
            return FlatTableHeaderUI.this.header.getWidth();
        }
    }
}

