/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class FlatTreeUI
extends BasicTreeUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionBorderColor;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected boolean wideSelection;
    @FlatStylingSupport.Styleable
    protected boolean showCellFocusIndicator;
    protected boolean showDefaultIcons;
    @FlatStylingSupport.Styleable(dot=true)
    public String iconArrowType;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconExpandedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconCollapsedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconLeafColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconClosedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconOpenColor;
    @FlatStylingSupport.Styleable
    protected boolean paintSelection = true;
    private Icon defaultLeafIcon;
    private Icon defaultClosedIcon;
    private Icon defaultOpenIcon;
    private boolean paintLines;
    private Color defaultCellNonSelectionBackground;
    private Color defaultSelectionBackground;
    private Color defaultSelectionForeground;
    private Color defaultSelectionBorderColor;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTreeUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.tree, "Tree.border");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("Tree.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("Tree.selectionInactiveForeground");
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.selectionInsets = UIManager.getInsets("Tree.selectionInsets");
        this.selectionArc = UIManager.getInt("Tree.selectionArc");
        this.wideSelection = UIManager.getBoolean("Tree.wideSelection");
        this.showCellFocusIndicator = UIManager.getBoolean("Tree.showCellFocusIndicator");
        this.showDefaultIcons = UIManager.getBoolean("Tree.showDefaultIcons");
        this.defaultLeafIcon = UIManager.getIcon("Tree.leafIcon");
        this.defaultClosedIcon = UIManager.getIcon("Tree.closedIcon");
        this.defaultOpenIcon = UIManager.getIcon("Tree.openIcon");
        this.paintLines = UIManager.getBoolean("Tree.paintLines");
        this.defaultCellNonSelectionBackground = UIManager.getColor("Tree.textBackground");
        this.defaultSelectionBackground = this.selectionBackground;
        this.defaultSelectionForeground = this.selectionForeground;
        this.defaultSelectionBorderColor = this.selectionBorderColor;
        int n = FlatUIUtils.getUIInt("Tree.rowHeight", 16);
        if (n > 0) {
            LookAndFeel.installProperty(this.tree, "rowHeight", UIScale.scale(n));
        }
        FlatTreeUI flatTreeUI = this;
        flatTreeUI.setLeftChildIndent(UIScale.scale(flatTreeUI.getLeftChildIndent()));
        FlatTreeUI flatTreeUI2 = this;
        flatTreeUI2.setRightChildIndent(UIScale.scale(flatTreeUI2.getRightChildIndent()));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.tree);
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.selectionBorderColor = null;
        this.defaultLeafIcon = null;
        this.defaultClosedIcon = null;
        this.defaultOpenIcon = null;
        this.defaultCellNonSelectionBackground = null;
        this.defaultSelectionBackground = null;
        this.defaultSelectionForeground = null;
        this.defaultSelectionBorderColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void updateRenderer() {
        DefaultTreeCellRenderer defaultTreeCellRenderer;
        super.updateRenderer();
        if (!this.showDefaultIcons && this.currentCellRenderer instanceof DefaultTreeCellRenderer && (defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.currentCellRenderer).getLeafIcon() == this.defaultLeafIcon && defaultTreeCellRenderer.getClosedIcon() == this.defaultClosedIcon && defaultTreeCellRenderer.getOpenIcon() == this.defaultOpenIcon) {
            defaultTreeCellRenderer.setLeafIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setOpenIcon(null);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new BasicTreeUI.MouseHandler(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                1 v0 = this;
                super.mousePressed(v0.handleWideMouseEvent(mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                1 v0 = this;
                super.mouseReleased(v0.handleWideMouseEvent(mouseEvent));
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                1 v0 = this;
                super.mouseDragged(v0.handleWideMouseEvent(mouseEvent));
            }

            private MouseEvent handleWideMouseEvent(MouseEvent mouseEvent) {
                if (!FlatTreeUI.this.isWideSelection() || !FlatTreeUI.this.tree.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
                    return mouseEvent;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Serializable serializable = FlatTreeUI.this.getClosestPathForLocation(FlatTreeUI.this.tree, n, n2);
                if (serializable == null || FlatTreeUI.this.isLocationInExpandControl(serializable, n, n2)) {
                    return mouseEvent;
                }
                serializable = FlatTreeUI.this.getPathBounds(FlatTreeUI.this.tree, (TreePath)serializable);
                if (serializable == null || n2 < ((Rectangle)serializable).y || n2 >= ((Rectangle)serializable).y + ((Rectangle)serializable).height) {
                    return mouseEvent;
                }
                int n3 = ((Rectangle)serializable).x;
                n2 = Math.max(n3, Math.min(n, n3 + ((Rectangle)serializable).width - 1));
                if (n2 == n) {
                    return mouseEvent;
                }
                return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), n2, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            if (propertyChangeEvent.getSource() == this.tree) {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "JTree.wideSelection": 
                    case "JTree.paintSelection": {
                        this.tree.repaint();
                        return;
                    }
                    case "dropLocation": {
                        if (!this.isWideSelection()) break;
                        propertyChangeListener = (JTree.DropLocation)propertyChangeEvent.getOldValue();
                        this.repaintWideDropLocation((JTree.DropLocation)((Object)propertyChangeListener));
                        FlatTreeUI flatTreeUI = this;
                        flatTreeUI.repaintWideDropLocation(flatTreeUI.tree.getDropLocation());
                        return;
                    }
                    case "FlatLaf.style": 
                    case "FlatLaf.styleClass": {
                        this.installStyle();
                        this.tree.revalidate();
                        this.tree.repaint();
                        return;
                    }
                    case "enabled": {
                        if (this.showDefaultIcons || !(this.currentCellRenderer instanceof DefaultTreeCellRenderer) || this.currentCellRenderer.getClass() == DefaultTreeCellRenderer.class || this.treeState == null) break;
                        this.treeState.invalidateSizes();
                        this.updateSize();
                    }
                }
            }
        };
    }

    private void repaintWideDropLocation(JTree.DropLocation object) {
        if (object == null || this.isDropLine((JTree.DropLocation)object)) {
            return;
        }
        if ((object = this.tree.getPathBounds(((JTree.DropLocation)object).getPath())) != null) {
            this.tree.repaint(0, ((Rectangle)object).y, this.tree.getWidth(), ((Rectangle)object).height);
        }
    }

    @Override
    protected TreeSelectionListener createTreeSelectionListener() {
        TreeSelectionListener treeSelectionListener = super.createTreeSelectionListener();
        return treeSelectionEvent -> {
            treeSelectionListener.valueChanged(treeSelectionEvent);
            if (this.useUnitedRoundedSelection() && this.tree.getSelectionCount() > 1 && (treeSelectionListener = treeSelectionEvent.getPaths()) != null) {
                if (((TreePath[])treeSelectionListener).length > 4) {
                    this.tree.repaint();
                    return;
                }
                int n = (int)Math.ceil(UIScale.scale((float)this.selectionArc / 2.0f));
                for (Serializable serializable : treeSelectionListener) {
                    FlatTreeUI flatTreeUI = this;
                    if ((serializable = flatTreeUI.getPathBounds(flatTreeUI.tree, (TreePath)serializable)) == null) continue;
                    this.tree.repaint(((Rectangle)serializable).x, ((Rectangle)serializable).y - n, ((Rectangle)serializable).width, ((Rectangle)serializable).height + (n << 1));
                }
            }
        };
    }

    @Override
    public Rectangle getPathBounds(JTree jTree, TreePath serializable) {
        if ((serializable = super.getPathBounds(jTree, (TreePath)serializable)) != null && this.isWideSelection() && UIManager.getBoolean("FlatLaf.experimental.tree.widePathForLocation") && StackUtils.wasInvokedFrom(JTree.class.getName(), "getPathForLocation", 5)) {
            ((Rectangle)serializable).x = 0;
            ((Rectangle)serializable).width = jTree.getWidth();
        }
        return serializable;
    }

    protected void installStyle() {
        try {
            FlatTreeUI flatTreeUI = this;
            flatTreeUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatTreeUI.tree, "Tree"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if ("rowHeight".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        FlatTreeUI flatTreeUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatTreeUI, flatTreeUI.tree, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paint(Graphics graphics, JComponent serializable) {
        if (this.treeState == null) {
            return;
        }
        serializable = graphics.getClipBounds();
        FlatTreeUI flatTreeUI = this;
        TreePath treePath = flatTreeUI.getClosestPathForLocation(flatTreeUI.tree, 0, ((Rectangle)serializable).y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        if (enumeration != null) {
            Iterator iterator;
            Object[] objectArray;
            Serializable serializable2;
            ArrayList<Runnable> arrayList;
            Insets insets = this.tree.getInsets();
            HashSet<Serializable> hashSet = this.paintLines ? new HashSet<Serializable>() : null;
            ArrayList<Runnable> arrayList2 = this.paintLines ? new ArrayList<Runnable>() : null;
            ArrayList<Runnable> arrayList3 = arrayList = this.paintLines ? new ArrayList<Runnable>() : null;
            if (this.paintLines) {
                for (serializable2 = treePath.getParentPath(); serializable2 != null; serializable2 = ((TreePath)serializable2).getParentPath()) {
                    hashSet.add(serializable2);
                }
            }
            serializable2 = new Rectangle();
            boolean bl = this.isRootVisible();
            int n = this.treeState.getRowForPath(treePath);
            boolean bl2 = this.tree.getComponentOrientation().isLeftToRight();
            int n2 = this.tree.getWidth();
            while (enumeration.hasMoreElements() && (objectArray = enumeration.nextElement()) != null && (iterator = this.treeState.getBounds((TreePath)objectArray, (Rectangle)serializable2)) != null) {
                Serializable serializable3;
                ((Rectangle)((Object)iterator)).x = bl2 ? (((Rectangle)((Object)iterator)).x += insets.left) : n2 - insets.right - (((Rectangle)((Object)iterator)).x + ((Rectangle)((Object)iterator)).width);
                ((Rectangle)((Object)iterator)).y += insets.top;
                boolean bl3 = this.treeModel.isLeaf(objectArray.getLastPathComponent());
                boolean bl4 = bl3 ? false : this.treeState.getExpandedState((TreePath)objectArray);
                boolean bl5 = bl3 ? false : this.tree.hasBeenExpanded((TreePath)objectArray);
                this.paintRow(graphics, (Rectangle)serializable, insets, (Rectangle)((Object)iterator), (TreePath)objectArray, n, bl4, bl5, bl3);
                if (this.paintLines) {
                    serializable3 = objectArray.getParentPath();
                    if (serializable3 != null) {
                        hashSet.add(serializable3);
                    }
                    if (serializable3 != null || bl && n == 0) {
                        Rectangle rectangle = new Rectangle((Rectangle)((Object)iterator));
                        int n3 = n;
                        arrayList2.add(() -> this.lambda$paint$2(graphics, (Rectangle)serializable, insets, rectangle, (TreePath)objectArray, n3, bl4, bl5, bl3));
                    }
                }
                if (this.shouldPaintExpandControl((TreePath)objectArray, n, bl4, bl5, bl3)) {
                    if (this.paintLines) {
                        serializable3 = new Rectangle((Rectangle)((Object)iterator));
                        int n4 = n;
                        arrayList.add(() -> this.lambda$paint$3(graphics, (Rectangle)serializable, insets, (Rectangle)serializable3, (TreePath)objectArray, n4, bl4, bl5, bl3));
                    } else {
                        this.paintExpandControl(graphics, (Rectangle)serializable, insets, (Rectangle)((Object)iterator), (TreePath)objectArray, n, bl4, bl5, bl3);
                    }
                }
                if (((Rectangle)((Object)iterator)).y + ((Rectangle)((Object)iterator)).height >= ((Rectangle)serializable).y + ((Rectangle)serializable).height) break;
                ++n;
            }
            if (this.paintLines) {
                objectArray = FlatUIUtils.setRenderingHints(graphics);
                for (Runnable runnable : arrayList2) {
                    runnable.run();
                }
                graphics.setColor(Color.green);
                for (TreePath treePath2 : hashSet) {
                    this.paintVerticalPartOfLeg(graphics, (Rectangle)serializable, insets, treePath2);
                }
                if (objectArray != null) {
                    FlatUIUtils.resetRenderingHints(graphics, objectArray);
                }
                for (Runnable runnable : arrayList) {
                    runnable.run();
                }
            }
        }
        this.paintDropLine(graphics);
        this.rendererPane.removeAll();
    }

    @Override
    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath serializable, int n, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable2;
        Color color;
        boolean bl4;
        boolean bl5;
        boolean bl6 = this.editingComponent != null && this.editingRow == n;
        boolean bl7 = this.tree.isRowSelected(n);
        bl2 = this.isDropRow(n);
        boolean bl8 = bl5 = (bl7 || bl2) && this.isPaintSelection();
        if (bl6) {
            if (bl7 && this.isWideSelection()) {
                Color color2 = graphics.getColor();
                graphics.setColor(this.selectionInactiveBackground);
                this.paintWideSelection(graphics, rectangle2, n);
                graphics.setColor(color2);
            }
            return;
        }
        bl6 = FlatUIUtils.isPermanentFocusOwner(this.tree);
        boolean bl9 = bl4 = bl6 && n == this.getLeadSelectionRow();
        if (!bl6 && bl7 && this.tree.getParent() instanceof CellRendererPane) {
            bl6 = FlatUIUtils.isPermanentFocusOwner(this.tree.getParent().getParent());
        }
        serializable = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, serializable.getLastPathComponent(), bl7, bl, bl3, n, bl4);
        Color color3 = null;
        if (bl7 && !bl6 && !bl2) {
            color3 = this.setRendererBackgroundSelectionColor((Component)serializable, this.selectionInactiveBackground);
            this.setRendererForeground((Component)serializable, this.selectionInactiveForeground);
        } else if (bl7) {
            if (this.selectionBackground != this.defaultSelectionBackground) {
                color3 = this.setRendererBackgroundSelectionColor((Component)serializable, this.selectionBackground);
            }
            if (this.selectionForeground != this.defaultSelectionForeground) {
                this.setRendererForeground((Component)serializable, this.selectionForeground);
            }
        }
        Color color4 = null;
        if (bl7 && bl6 && (!this.showCellFocusIndicator || this.tree.getMinSelectionRow() == this.tree.getMaxSelectionRow())) {
            color4 = this.setRendererBorderSelectionColor((Component)serializable, null);
        } else if (bl6 && this.selectionBorderColor != this.defaultSelectionBorderColor) {
            color4 = this.setRendererBorderSelectionColor((Component)serializable, this.selectionBorderColor);
        }
        if (bl5) {
            Color color5 = graphics.getColor();
            graphics.setColor(bl2 ? UIManager.getColor("Tree.dropCellBackground") : (serializable instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)serializable).getBackgroundSelectionColor() : (bl6 ? this.selectionBackground : this.selectionInactiveBackground)));
            if (this.isWideSelection()) {
                this.paintWideSelection(graphics, rectangle2, n);
            } else {
                this.paintCellBackground(graphics, (Component)serializable, rectangle2, n, true);
            }
            graphics.setColor(color5);
        } else if (serializable instanceof DefaultTreeCellRenderer && (color = (serializable2 = (DefaultTreeCellRenderer)serializable).getBackgroundNonSelectionColor()) != null && !color.equals(this.defaultCellNonSelectionBackground)) {
            serializable2 = graphics.getColor();
            graphics.setColor(color);
            this.paintCellBackground(graphics, (Component)serializable, rectangle2, n, false);
            graphics.setColor((Color)serializable2);
        }
        this.rendererPane.paintComponent(graphics, (Component)serializable, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
        if (color3 != null) {
            ((DefaultTreeCellRenderer)serializable).setBackgroundSelectionColor(color3);
        }
        if (color4 != null) {
            ((DefaultTreeCellRenderer)serializable).setBorderSelectionColor(color4);
        }
    }

    private Color setRendererBackgroundSelectionColor(Component component, Color color) {
        Color color2 = null;
        if (component instanceof DefaultTreeCellRenderer) {
            if (((DefaultTreeCellRenderer)(component = (DefaultTreeCellRenderer)component)).getBackgroundSelectionColor() == this.defaultSelectionBackground) {
                color2 = ((DefaultTreeCellRenderer)component).getBackgroundSelectionColor();
                ((DefaultTreeCellRenderer)component).setBackgroundSelectionColor(color);
            }
        } else if (component.getBackground() == this.defaultSelectionBackground) {
            component.setBackground(color);
        }
        return color2;
    }

    private void setRendererForeground(Component component, Color color) {
        if (component.getForeground() == this.defaultSelectionForeground) {
            component.setForeground(color);
        }
    }

    private Color setRendererBorderSelectionColor(Component component, Color color) {
        Color color2 = null;
        if (component instanceof DefaultTreeCellRenderer && ((DefaultTreeCellRenderer)(component = (DefaultTreeCellRenderer)component)).getBorderSelectionColor() == this.defaultSelectionBorderColor) {
            color2 = ((DefaultTreeCellRenderer)component).getBorderSelectionColor();
            ((DefaultTreeCellRenderer)component).setBorderSelectionColor(color);
        }
        return color2;
    }

    private void paintWideSelection(Graphics graphics, Rectangle rectangle, int n) {
        float f;
        float f2 = f = UIScale.scale((float)this.selectionArc / 2.0f);
        if (this.useUnitedRoundedSelection()) {
            if (n > 0 && this.tree.isRowSelected(n - 1)) {
                f2 = 0.0f;
            }
            if (n < this.tree.getRowCount() - 1 && this.tree.isRowSelected(n + 1)) {
                f = 0.0f;
            }
        }
        float f3 = f2;
        float f4 = f;
        FlatUIUtils.paintSelection((Graphics2D)graphics, 0, rectangle.y, this.tree.getWidth(), rectangle.height, UIScale.scale(this.selectionInsets), f3, f3, f4, f4, 0);
    }

    private void paintCellBackground(Graphics graphics, Component component, Rectangle rectangle, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        if (component instanceof JLabel) {
            Icon icon = (component = (JLabel)component).isEnabled() ? ((JLabel)component).getIcon() : ((JLabel)component).getDisabledIcon();
            n3 = icon != null && ((JLabel)component).getText() != null ? icon.getIconWidth() + Math.max(((JLabel)component).getIconTextGap() - 1, 0) : 0;
            int n4 = n2 = component.getComponentOrientation().isLeftToRight() ? n3 : 0;
        }
        if (bl) {
            float f;
            float f2 = f = UIScale.scale((float)this.selectionArc / 2.0f);
            float f3 = f;
            float f4 = f;
            if (this.useUnitedRoundedSelection()) {
                Rectangle rectangle2;
                if (n > 0 && this.tree.isRowSelected(n - 1)) {
                    FlatTreeUI flatTreeUI = this;
                    rectangle2 = flatTreeUI.getPathBounds(flatTreeUI.tree, this.tree.getPathForRow(n - 1));
                    f4 = Math.min(f4, (float)(rectangle2.x - rectangle.x));
                    f3 = Math.min(f3, (float)(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width)));
                }
                if (n < this.tree.getRowCount() - 1 && this.tree.isRowSelected(n + 1)) {
                    FlatTreeUI flatTreeUI = this;
                    rectangle2 = flatTreeUI.getPathBounds(flatTreeUI.tree, this.tree.getPathForRow(n + 1));
                    f2 = Math.min(f2, (float)(rectangle2.x - rectangle.x));
                    f = Math.min(f, (float)(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width)));
                }
            }
            FlatUIUtils.paintSelection((Graphics2D)graphics, rectangle.x + n2, rectangle.y, rectangle.width - n3, rectangle.height, UIScale.scale(this.selectionInsets), f4, f3, f2, f, 0);
            return;
        }
        graphics.fillRect(rectangle.x + n2, rectangle.y, rectangle.width - n3, rectangle.height);
    }

    private boolean useUnitedRoundedSelection() {
        return this.selectionArc > 0 && (this.selectionInsets == null || this.selectionInsets.top == 0 && this.selectionInsets.bottom == 0);
    }

    @Override
    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        ((Graphics2D)graphics).fill(new Rectangle2D.Float(n, n2, UIScale.scale(1.0f), n3 - n2));
    }

    @Override
    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        ((Graphics2D)graphics).fill(new Rectangle2D.Float(n2, n, n3 - n2, UIScale.scale(1.0f)));
    }

    private boolean isDropRow(int n) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.tree.getRowForPath(dropLocation.getPath()) == n;
    }

    @Override
    protected Rectangle getDropLineRect(JTree.DropLocation object) {
        object = super.getDropLineRect((JTree.DropLocation)object);
        if (this.isWideSelection()) {
            return new Rectangle(0, ((Rectangle)object).y, this.tree.getWidth(), ((Rectangle)object).height);
        }
        return object;
    }

    protected boolean isWideSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.wideSelection", this.wideSelection);
    }

    protected boolean isPaintSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.paintSelection", this.paintSelection);
    }

    private /* synthetic */ void lambda$paint$3(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
    }

    private /* synthetic */ void lambda$paint$2(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
    }
}

