/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/CookieDateParser;", "", "<init>", "()V", "T", "", "source", "name", "field", "", "checkFieldNotNull", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "", "requirement", "Lkotlin/Function0;", "msg", "checkRequirement", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "Lio/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "ktor-http"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String string, String string2, T t2) {
        if (t2 == null) {
            throw new InvalidCookieDateException(string, "Could not find " + string2);
        }
    }

    private final void checkRequirement(String string, boolean bl, Function0<String> function0) {
        if (!bl) {
            throw new InvalidCookieDateException(string, (String)function0.invoke());
        }
    }

    public final GMTDate parse(String string) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringLexer stringLexer = new StringLexer(string);
        CookieDateBuilder cookieDateBuilder = new CookieDateBuilder();
        stringLexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$0));
        while (stringLexer.getHasRemaining()) {
            if (!stringLexer.test((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$1))) continue;
            object2 = stringLexer;
            int n = ((StringLexer)object2).getIndex();
            StringLexer stringLexer2 = object2;
            stringLexer2.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$3$lambda$2));
            Intrinsics.checkNotNullExpressionValue((Object)((StringLexer)object2).getSource().substring(n, ((StringLexer)object2).getIndex()), (String)"");
            CookieUtilsKt.handleToken(cookieDateBuilder, (String)object);
            stringLexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$4));
        }
        object = cookieDateBuilder.getYear();
        object2 = new IntRange(70, 99);
        if (object != null && object2.contains(((Integer)object).intValue())) {
            CookieDateBuilder cookieDateBuilder2 = cookieDateBuilder;
            Integer n = cookieDateBuilder2.getYear();
            Intrinsics.checkNotNull((Object)n);
            cookieDateBuilder2.setYear(n + 1900);
        } else {
            object2 = new IntRange(0, 69);
            if (object != null && object2.contains(((Integer)object).intValue())) {
                CookieDateBuilder cookieDateBuilder3 = cookieDateBuilder;
                Integer n = cookieDateBuilder3.getYear();
                Intrinsics.checkNotNull((Object)n);
                cookieDateBuilder3.setYear(n + 2000);
            }
        }
        this.checkFieldNotNull(string, "day-of-month", cookieDateBuilder.getDayOfMonth());
        this.checkFieldNotNull(string, "month", cookieDateBuilder.getMonth());
        this.checkFieldNotNull(string, "year", cookieDateBuilder.getYear());
        this.checkFieldNotNull(string, "time", cookieDateBuilder.getHours());
        this.checkFieldNotNull(string, "time", cookieDateBuilder.getMinutes());
        this.checkFieldNotNull(string, "time", cookieDateBuilder.getSeconds());
        object = new IntRange(1, 31);
        object2 = cookieDateBuilder.getDayOfMonth();
        this.checkRequirement(string, object2 != null && object.contains(((Integer)object2).intValue()), (Function0<String>)((Function0)CookieDateParser::parse$lambda$5));
        Integer n = cookieDateBuilder.getYear();
        Intrinsics.checkNotNull((Object)n);
        this.checkRequirement(string, n >= 1601, (Function0<String>)((Function0)CookieDateParser::parse$lambda$6));
        Integer n2 = cookieDateBuilder.getHours();
        Intrinsics.checkNotNull((Object)n2);
        this.checkRequirement(string, n2 <= 23, (Function0<String>)((Function0)CookieDateParser::parse$lambda$7));
        Integer n3 = cookieDateBuilder.getMinutes();
        Intrinsics.checkNotNull((Object)n3);
        this.checkRequirement(string, n3 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$8));
        Integer n4 = cookieDateBuilder.getSeconds();
        Intrinsics.checkNotNull((Object)n4);
        this.checkRequirement(string, n4 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$9));
        return cookieDateBuilder.build();
    }

    private static final boolean parse$lambda$0(char c) {
        return CookieUtilsKt.isDelimiter(c);
    }

    private static final boolean parse$lambda$1(char c) {
        return CookieUtilsKt.isNonDelimiter(c);
    }

    private static final boolean parse$lambda$3$lambda$2(char c) {
        return CookieUtilsKt.isNonDelimiter(c);
    }

    private static final boolean parse$lambda$4(char c) {
        return CookieUtilsKt.isDelimiter(c);
    }

    private static final String parse$lambda$5() {
        return "day-of-month not in [1,31]";
    }

    private static final String parse$lambda$6() {
        return "year >= 1601";
    }

    private static final String parse$lambda$7() {
        return "hours > 23";
    }

    private static final String parse$lambda$8() {
        return "minutes > 59";
    }

    private static final String parse$lambda$9() {
        return "seconds > 59";
    }
}

