/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateParser;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateParser;
import io.ktor.util.date.InvalidDateStringException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0000*\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\t\u001a\u00020\u0000*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\n\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"", "Lio/ktor/util/date/GMTDate;", "fromHttpToGmtDate", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "fromCookieToGmtDate", "toHttpDate", "(Lio/ktor/util/date/GMTDate;)Ljava/lang/String;", "", "length", "padZero", "(II)Ljava/lang/String;", "", "HTTP_DATE_FORMATS", "Ljava/util/List;", "ktor-http"})
public final class DateUtilsKt {
    private static final List<String> HTTP_DATE_FORMATS;

    public static final GMTDate fromHttpToGmtDate(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        for (String string3 : HTTP_DATE_FORMATS) {
            try {
                string3 = new GMTDateParser(string3);
                return string3.parse(string);
            }
            catch (InvalidDateStringException invalidDateStringException) {
            }
        }
        throw new IllegalStateException(("Failed to parse date: " + string2).toString());
    }

    public static final GMTDate fromCookieToGmtDate(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        try {
            CookieDateParser cookieDateParser = new CookieDateParser();
            return cookieDateParser.parse(string);
        }
        catch (InvalidCookieDateException invalidCookieDateException) {
            return DateUtilsKt.fromHttpToGmtDate(string);
        }
    }

    public static final String toHttpDate(GMTDate gMTDate) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)gMTDate, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(gMTDate.getDayOfWeek().getValue() + ", ");
        stringBuilder2.append(DateUtilsKt.padZero(gMTDate.getDayOfMonth(), 2) + ' ');
        stringBuilder2.append(gMTDate.getMonth().getValue() + ' ');
        stringBuilder2.append(DateUtilsKt.padZero(gMTDate.getYear(), 4));
        stringBuilder2.append(" " + DateUtilsKt.padZero(gMTDate.getHours(), 2) + ':' + DateUtilsKt.padZero(gMTDate.getMinutes(), 2) + ':' + DateUtilsKt.padZero(gMTDate.getSeconds(), 2) + ' ');
        stringBuilder2.append("GMT");
        return stringBuilder.toString();
    }

    private static final String padZero(int n, int n2) {
        return StringsKt.padStart((String)String.valueOf(n), (int)n2, (char)'0');
    }

    static {
        Object[] objectArray = new String[11];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "***, dd MMM YYYY hh:mm:ss zzz";
        objectArray2[1] = "****, dd-MMM-YYYY hh:mm:ss zzz";
        objectArray2[2] = "*** MMM d hh:mm:ss YYYY";
        objectArray2[3] = "***, dd-MMM-YYYY hh:mm:ss zzz";
        objectArray2[4] = "***, dd-MMM-YYYY hh-mm-ss zzz";
        objectArray2[5] = "***, dd MMM YYYY hh:mm:ss zzz";
        objectArray2[6] = "*** dd-MMM-YYYY hh:mm:ss zzz";
        objectArray2[7] = "*** dd MMM YYYY hh:mm:ss zzz";
        objectArray2[8] = "*** dd-MMM-YYYY hh-mm-ss zzz";
        objectArray2[9] = "***,dd-MMM-YYYY hh:mm:ss zzz";
        objectArray2[10] = "*** MMM d YYYY hh:mm:ss zzz";
        HTTP_DATE_FORMATS = CollectionsKt.listOf((Object[])objectArray2);
    }
}

