/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\t0\u0005H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"", "rangeSpec", "Lio/ktor/http/RangesSpecifier;", "parseRangesSpecifier", "(Ljava/lang/String;)Lio/ktor/http/RangesSpecifier;", "", "Lio/ktor/http/ContentRange;", "", "contentLength", "Lkotlin/ranges/LongRange;", "toLongRanges", "(Ljava/util/List;J)Ljava/util/List;", "mergeRangesKeepOrder", "(Ljava/util/List;)Ljava/util/List;", "ktor-http"})
public final class RangesKt {
    public static final RangesSpecifier parseRangesSpecifier(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        try {
            String string = object;
            object = "=";
            int n = StringsKt.indexOf$default((CharSequence)string, (String)object, (int)0, (boolean)false, (int)6, null);
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string.substring(n + ((String)object).length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            object = TuplesKt.to((Object)string2, (Object)string3);
            string = (String)object.component1();
            object = (String)object.component2();
            char[] cArray = new char[1];
            Object object2 = cArray;
            cArray[0] = 44;
            Iterable iterable = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])object2, (boolean)false, (int)0, (int)6, null);
            object2 = iterable;
            object = iterable;
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                ContentRange contentRange;
                Object object3 = object.next();
                object3 = (String)object3;
                char[] cArray2 = object2;
                if (StringsKt.startsWith$default(object3, (String)"-", (boolean)false, (int)2, null)) {
                    contentRange = new ContentRange.Suffix(Long.parseLong(StringsKt.removePrefix(object3, (CharSequence)"-")));
                } else {
                    Pair pair;
                    String string4 = "-";
                    int n2 = StringsKt.indexOf$default((CharSequence)((CharSequence)object3), (String)string4, (int)0, (boolean)false, (int)6, null);
                    if (n2 == -1) {
                        pair = TuplesKt.to((Object)"", (Object)"");
                    } else {
                        String string5 = ((String)object3).substring(0, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                        String string6 = ((String)object3).substring(n2 + string4.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                        pair = TuplesKt.to((Object)string5, (Object)string6);
                    }
                    string4 = pair;
                    object3 = (String)pair.component1();
                    string4 = (String)string4.component2();
                    contentRange = ((CharSequence)string4).length() > 0 ? (ContentRange)new ContentRange.Bounded(Long.parseLong((String)object3), Long.parseLong(string4)) : (ContentRange)new ContentRange.TailFrom(Long.parseLong((String)object3));
                }
                cArray2.add(contentRange);
            }
            object = (List)object2;
            if (object.isEmpty() || ((CharSequence)string).length() == 0) {
                return null;
            }
            RangesSpecifier rangesSpecifier = new RangesSpecifier(string, (List<? extends ContentRange>)object);
            object2 = rangesSpecifier;
            if (RangesSpecifier.isValid$default(rangesSpecifier, null, 1, null)) {
                return object2;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final List<LongRange> toLongRanges(List<? extends ContentRange> iterable, long l) {
        ContentRange contentRange;
        Object object;
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        iterable = iterable;
        Iterator iterator = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            LongRange longRange;
            object = iterator.next();
            contentRange = (ContentRange)object;
            Iterable<ContentRange> iterable2 = iterable;
            object = contentRange;
            if (object instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)contentRange).getFrom(), kotlin.ranges.RangesKt.coerceAtMost((long)((ContentRange.Bounded)contentRange).getTo(), (long)(l - 1L)));
            } else if (object instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until((long)((ContentRange.TailFrom)contentRange).getFrom(), (long)l);
            } else if (object instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until((long)kotlin.ranges.RangesKt.coerceAtLeast((long)(l - ((ContentRange.Suffix)contentRange).getLastCount()), (long)0L), (long)l);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            iterable2.add((ContentRange)longRange);
        }
        iterable = iterable;
        iterator = iterable;
        iterable = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            contentRange = (LongRange)object;
            if (contentRange.isEmpty()) continue;
            iterable.add(object);
        }
        return iterable;
    }

    public static final List<LongRange> mergeRangesKeepOrder(List<LongRange> list) {
        LongRange longRange;
        Object object;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Object object2 = (LongRange[])list;
        object2 = CollectionsKt.sortedWith((Iterable)object2, (Comparator)new Comparator(){

            public final int compare(T object, T object2) {
                LongRange longRange = (LongRange)object;
                object = longRange;
                object = (LongRange)object2;
                object2 = longRange.getFirst();
                return ComparisonsKt.compareValues(object2, (Comparable)Long.valueOf(object.getFirst()));
            }
        });
        Object object3 = object = new ArrayList(list.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object = (LongRange)object;
            object2 = object3;
            if (((ArrayList)object2).isEmpty()) {
                ((ArrayList)object2).add(object);
            } else if (((LongRange)CollectionsKt.last((List)((List)object2))).getLast() < object.getFirst() - 1L) {
                ((ArrayList)object2).add(object);
            } else {
                longRange = (LongRange)CollectionsKt.last((List)((List)object2));
                Object object4 = object2;
                ((ArrayList)object4).set(CollectionsKt.getLastIndex((List)((List)object4)), new LongRange(longRange.getFirst(), Math.max(longRange.getLast(), object.getLast())));
            }
            object3 = object2;
        }
        object = object3;
        object2 = new LongRange[list.size()];
        Iterator iterator2 = ((ArrayList)object).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"");
        object = iterator2;
        block1: while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"");
            longRange = (LongRange)e;
            int n = ((Collection)list).size();
            for (int i = 0; i < n; ++i) {
                if (!io.ktor.util.RangesKt.contains((LongRange)longRange, (LongRange)list.get(i))) continue;
                object2[i] = longRange;
                continue block1;
            }
        }
        return ArraysKt.filterNotNull((Object[])object2);
    }
}

