/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangeUnits;
import io.ktor.http.RangesKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ#\u0010\u000e\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\"\u0004\b\u0000\u0010\u001c*\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010\u001bJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b \u0010!J*\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u001a\u0010%\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010\u001bR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010+\u001a\u0004\b,\u0010!\u00a8\u0006-"}, d2={"Lio/ktor/http/RangesSpecifier;", "", "", "unit", "", "Lio/ktor/http/ContentRange;", "ranges", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Lio/ktor/http/RangeUnits;", "(Lio/ktor/http/RangeUnits;Ljava/util/List;)V", "Lkotlin/Function1;", "", "rangeUnitPredicate", "isValid", "(Lkotlin/jvm/functions/Function1;)Z", "", "length", "", "maxRangeCount", "Lkotlin/ranges/LongRange;", "merge", "(JI)Ljava/util/List;", "(J)Ljava/util/List;", "mergeToSingle", "(J)Lkotlin/ranges/LongRange;", "toString", "()Ljava/lang/String;", "T", "toList", "(Ljava/lang/Object;)Ljava/util/List;", "component1", "component2", "()Ljava/util/List;", "copy", "(Ljava/lang/String;Ljava/util/List;)Lio/ktor/http/RangesSpecifier;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getUnit", "Ljava/util/List;", "getRanges", "ktor-http"})
public final class RangesSpecifier {
    private final String unit;
    private final List<ContentRange> ranges;

    public RangesSpecifier(String string, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.unit = string;
        this.ranges = list;
        if (!(!((Collection)this.ranges).isEmpty())) {
            string = "It should be at least one range";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RangesSpecifier(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RangeUnits.Bytes.getUnitToken();
        }
        this(string, (List<? extends ContentRange>)list);
    }

    public final String getUnit() {
        return this.unit;
    }

    public final List<ContentRange> getRanges() {
        return this.ranges;
    }

    public RangesSpecifier(RangeUnits rangeUnits, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)((Object)rangeUnits), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this(rangeUnits.getUnitToken(), list);
    }

    public final boolean isValid(Function1<? super String, Boolean> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        if (((Boolean)object.invoke((Object)this.unit)).booleanValue()) {
            boolean bl;
            object = this.ranges;
            if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    boolean bl2;
                    Object object2 = object.next();
                    object2 = (ContentRange)object2;
                    ContentRange contentRange = object2;
                    if (object2 instanceof ContentRange.Bounded) {
                        bl2 = ((ContentRange.Bounded)object2).getFrom() < 0L || ((ContentRange.Bounded)object2).getTo() < ((ContentRange.Bounded)object2).getFrom();
                    } else if (contentRange instanceof ContentRange.TailFrom) {
                        bl2 = ((ContentRange.TailFrom)object2).getFrom() < 0L;
                    } else if (contentRange instanceof ContentRange.Suffix) {
                        bl2 = ((ContentRange.Suffix)object2).getLastCount() < 0L;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (!bl2) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean isValid$default(RangesSpecifier rangesSpecifier, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = RangesSpecifier::isValid$lambda$1;
        }
        return rangesSpecifier.isValid((Function1<? super String, Boolean>)function1);
    }

    public final List<LongRange> merge(long l, int n) {
        if (this.ranges.size() > n) {
            RangesSpecifier rangesSpecifier = this;
            return rangesSpecifier.toList(rangesSpecifier.mergeToSingle(l));
        }
        return this.merge(l);
    }

    public static /* synthetic */ List merge$default(RangesSpecifier rangesSpecifier, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return rangesSpecifier.merge(l, n);
    }

    public final List<LongRange> merge(long l) {
        return RangesKt.mergeRangesKeepOrder(RangesKt.toLongRanges(this.ranges, l));
    }

    public final LongRange mergeToSingle(long l) {
        Object v1;
        Object object;
        Object v0;
        List<Object> list = RangesKt.toLongRanges(this.ranges, l);
        if (list.isEmpty()) {
            return null;
        }
        Object object2 = list;
        if (!(object2 = object2.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object2.next();
            if (!object2.hasNext()) {
                v0 = e;
            } else {
                LongRange longRange = (LongRange)e;
                long l2 = longRange.getFirst();
                do {
                    LongRange longRange2;
                    long l3;
                    if (l2 <= (l3 = (longRange2 = (LongRange)(object = object2.next())).getFirst())) continue;
                    e = object;
                    l2 = l3;
                } while (object2.hasNext());
                v0 = e;
            }
        }
        Intrinsics.checkNotNull(v0);
        long l4 = ((LongRange)v0).getFirst();
        object2 = list;
        Iterator iterator = object2.iterator();
        if (!iterator.hasNext()) {
            v1 = null;
        } else {
            object = iterator.next();
            if (!iterator.hasNext()) {
                v1 = object;
            } else {
                LongRange longRange = (LongRange)object;
                long l5 = longRange.getLast();
                do {
                    LongRange longRange3;
                    long l6;
                    if (l5 >= (l6 = (longRange3 = (LongRange)(list = iterator.next())).getLast())) continue;
                    object = list;
                    l5 = l6;
                } while (iterator.hasNext());
                v1 = object;
            }
        }
        Intrinsics.checkNotNull(v1);
        long l7 = kotlin.ranges.RangesKt.coerceAtMost((long)((LongRange)v1).getLast(), (long)(l - 1L));
        return new LongRange(l4, l7);
    }

    public final String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.ranges, (CharSequence)",", (CharSequence)(this.unit + '='), null, (int)0, null, null, (int)60, null);
    }

    private final <T> List<T> toList(T t2) {
        T t3 = t2;
        if (t3 == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf(t3);
    }

    public final String component1() {
        return this.unit;
    }

    public final List<ContentRange> component2() {
        return this.ranges;
    }

    public final RangesSpecifier copy(String string, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        return new RangesSpecifier(string, list);
    }

    public static /* synthetic */ RangesSpecifier copy$default(RangesSpecifier rangesSpecifier, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = rangesSpecifier.unit;
        }
        if ((n & 2) != 0) {
            list = rangesSpecifier.ranges;
        }
        return rangesSpecifier.copy(string, list);
    }

    public final int hashCode() {
        int n = this.unit.hashCode();
        n = n * 31 + ((Object)this.ranges).hashCode();
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RangesSpecifier)) {
            return false;
        }
        object = (RangesSpecifier)object;
        if (!Intrinsics.areEqual((Object)this.unit, (Object)((RangesSpecifier)object).unit)) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, ((RangesSpecifier)object).ranges);
    }

    private static final boolean isValid$lambda$1(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return Intrinsics.areEqual((Object)string, (Object)RangeUnits.Bytes.getUnitToken());
    }
}

