/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.skottie;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;
import org.jetbrains.skia.skottie.Animation;
import org.jetbrains.skia.skottie.AnimationBuilderFlag;
import org.jetbrains.skia.skottie.AnimationBuilderKt;
import org.jetbrains.skia.skottie.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0013\b\u0000\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/skia/skottie/AnimationBuilder;", "Lorg/jetbrains/skia/impl/Managed;", "()V", "builderFlags", "", "Lorg/jetbrains/skia/skottie/AnimationBuilderFlag;", "([Lorg/jetbrains/skia/skottie/AnimationBuilderFlag;)V", "ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(J)V", "buildFromData", "Lorg/jetbrains/skia/skottie/Animation;", "data", "Lorg/jetbrains/skia/Data;", "buildFromString", "", "setFontManager", "fontMgr", "Lorg/jetbrains/skia/FontMgr;", "setLogger", "logger", "Lorg/jetbrains/skia/skottie/Logger;", "Companion", "_FinalizerHolder", "skiko"})
public final class AnimationBuilder
extends Managed {
    public static final Companion Companion = new Companion(null);

    public AnimationBuilder(long l) {
        super(l, _FinalizerHolder.INSTANCE.getPTR(), false, 4, null);
    }

    public AnimationBuilder() {
        AnimationBuilderFlag[] animationBuilderFlagArray = new AnimationBuilderFlag[]{};
        this(Arrays.copyOf(animationBuilderFlagArray, animationBuilderFlagArray.length));
    }

    public AnimationBuilder(AnimationBuilderFlag ... animationBuilderFlagArray) {
        Intrinsics.checkNotNullParameter((Object)animationBuilderFlagArray, (String)"");
        this(AnimationBuilderKt.access$AnimationBuilder_nMake(Companion._flagsToInt$skiko(Arrays.copyOf(animationBuilderFlagArray, animationBuilderFlagArray.length))));
        Stats.INSTANCE.onNativeCall();
    }

    public final AnimationBuilder setFontManager(FontMgr fontMgr) {
        AnimationBuilder animationBuilder;
        try {
            Stats.INSTANCE.onNativeCall();
            AnimationBuilderKt.access$_nSetFontManager(this.get_ptr$skiko(), NativeKt.getPtr(fontMgr));
            animationBuilder = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(fontMgr);
        }
        return animationBuilder;
    }

    public final AnimationBuilder setLogger(Logger logger) {
        AnimationBuilder animationBuilder;
        try {
            Stats.INSTANCE.onNativeCall();
            AnimationBuilderKt.access$_nSetLogger(this.get_ptr$skiko(), NativeKt.getPtr(logger));
            animationBuilder = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(logger);
        }
        return animationBuilder;
    }

    public final Animation buildFromString(String string) {
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            Stats.INSTANCE.onNativeCall();
            InteropScope interopScope = theScope.INSTANCE;
            long l = AnimationBuilderKt.access$_nBuildFromString(this.get_ptr$skiko(), interopScope.toInterop(string));
            if (!(l != Native.Companion.getNullPointer())) {
                String string2 = "Failed to create Animation from string: \"" + string + '\"';
                throw new IllegalArgumentException(string2.toString());
            }
            animation = new Animation(l);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return animation;
    }

    public final Animation buildFromData(Data data) {
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        try {
            Stats.INSTANCE.onNativeCall();
            long l = AnimationBuilderKt.access$_nBuildFromData(this.get_ptr$skiko(), NativeKt.getPtr(data));
            if (!(l != Native.Companion.getNullPointer())) {
                String string = "Failed to create Animation from data";
                throw new IllegalArgumentException(string.toString());
            }
            animation = new Animation(l);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(data);
            Native_jvmKt.reachabilityBarrier(this);
        }
        return animation;
    }

    static {
        Library.Companion.staticLoad();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/skia/skottie/AnimationBuilder$Companion;", "", "()V", "_flagsToInt", "", "builderFlags", "", "Lorg/jetbrains/skia/skottie/AnimationBuilderFlag;", "_flagsToInt$skiko", "([Lorg/jetbrains/skia/skottie/AnimationBuilderFlag;)I", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final int _flagsToInt$skiko(AnimationBuilderFlag ... animationBuilderFlagArray) {
            Intrinsics.checkNotNullParameter((Object)animationBuilderFlagArray, (String)"");
            int n = 0;
            for (AnimationBuilderFlag animationBuilderFlag : animationBuilderFlagArray) {
                n |= animationBuilderFlag.get_flag();
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/skia/skottie/AnimationBuilder$_FinalizerHolder;", "", "()V", "PTR", "", "Lorg/jetbrains/skia/impl/NativePointer;", "getPTR", "()J", "skiko"})
    private static final class _FinalizerHolder {
        public static final _FinalizerHolder INSTANCE = new _FinalizerHolder();
        private static final long PTR = AnimationBuilderKt.access$AnimationBuilder_nGetFinalizer();

        private _FinalizerHolder() {
        }

        public final long getPTR() {
            return PTR;
        }
    }
}

