/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\u0013\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "tableName", "", "checkName", "checkOp", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCheckName", "()Ljava/lang/String;", "getCheckOp", "checkPart", "getCheckPart$exposed_core", "getTableName", "cannotAlterCheckConstraint", "", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "getCannotAlterCheckConstraint", "(Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;)Z", "component1", "component2", "component3", "copy", "createStatement", "", "dropStatement", "equals", "other", "", "hashCode", "", "modifyStatement", "toString", "Companion", "exposed-core"})
public final class CheckConstraint
implements DdlAware {
    public static final Companion Companion = new Companion(null);
    private final String tableName;
    private final String checkName;
    private final String checkOp;
    private final String checkPart;

    public CheckConstraint(String string, String string2, String string3) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        this.tableName = string;
        this.checkName = string2;
        this.checkOp = string3;
        this.checkPart = "CONSTRAINT " + this.checkName + " CHECK (" + this.checkOp + ')';
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getCheckName() {
        return this.checkName;
    }

    public final String getCheckOp() {
        return this.checkOp;
    }

    public final String getCheckPart$exposed_core() {
        return this.checkPart;
    }

    private final boolean getCannotAlterCheckConstraint(DatabaseDialect databaseDialect) {
        block4: {
            block3: {
                if (databaseDialect instanceof SQLiteDialect) break block3;
                MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
                boolean bl = mysqlDialect != null ? !mysqlDialect.isMysql8$exposed_core() : false;
                if (!bl) break block4;
            }
            return true;
        }
        return false;
    }

    @Override
    public final List<String> createStatement() {
        if (this.getCannotAlterCheckConstraint(DatabaseDialectKt.getCurrentDialect())) {
            SQLLogKt.getExposedLogger().warn("Creation of CHECK constraints is not currently supported by " + DatabaseDialectKt.getCurrentDialect().getName());
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " ADD " + this.checkPart));
    }

    @Override
    public final List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    public final List<String> dropStatement() {
        if (this.getCannotAlterCheckConstraint(DatabaseDialectKt.getCurrentDialect())) {
            SQLLogKt.getExposedLogger().warn("Deletion of CHECK constraints is not currently supported by " + DatabaseDialectKt.getCurrentDialect().getName());
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " DROP CONSTRAINT " + this.checkName));
    }

    public final String component1() {
        return this.tableName;
    }

    public final String component2() {
        return this.checkName;
    }

    public final String component3() {
        return this.checkOp;
    }

    public final CheckConstraint copy(String string, String string2, String string3) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        return new CheckConstraint(string, string2, string3);
    }

    public static /* synthetic */ CheckConstraint copy$default(CheckConstraint checkConstraint, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = checkConstraint.tableName;
        }
        if ((n & 2) != 0) {
            string2 = checkConstraint.checkName;
        }
        if ((n & 4) != 0) {
            string3 = checkConstraint.checkOp;
        }
        return checkConstraint.copy(string, string2, string3);
    }

    public final String toString() {
        return "CheckConstraint(tableName=" + this.tableName + ", checkName=" + this.checkName + ", checkOp=" + this.checkOp + ')';
    }

    public final int hashCode() {
        int n = this.tableName.hashCode();
        n = n * 31 + this.checkName.hashCode();
        n = n * 31 + this.checkOp.hashCode();
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CheckConstraint)) {
            return false;
        }
        object = (CheckConstraint)object;
        if (!Intrinsics.areEqual((Object)this.tableName, (Object)((CheckConstraint)object).tableName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.checkName, (Object)((CheckConstraint)object).checkName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checkOp, (Object)((CheckConstraint)object).checkOp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint$Companion;", "", "()V", "from", "Lorg/jetbrains/exposed/sql/CheckConstraint;", "table", "Lorg/jetbrains/exposed/sql/Table;", "name", "", "op", "Lorg/jetbrains/exposed/sql/Op;", "", "from$exposed_core", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final CheckConstraint from$exposed_core(Table object, String string, Op<Boolean> object2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter(object2, (String)"");
            if (!(!StringsKt.isBlank((CharSequence)string))) {
                String string2 = "Check constraint name cannot be blank";
                throw new IllegalArgumentException(string2.toString());
            }
            Transaction transaction2 = TransactionManager.Companion.current();
            IdentifierManagerApi identifierManagerApi = transaction2.getDb().getIdentifierManager();
            object = transaction2.identity((Table)object);
            object2 = StringsKt.replace$default((String)((Expression)object2).toString(), (String)((String)object + '.'), (String)"", (boolean)false, (int)4, null);
            return new CheckConstraint((String)object, identifierManagerApi.cutIfNecessaryAndQuote(string), (String)object2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

