/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bJ&\u0010\u0017\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u00180\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J6\u0010 \u001a\u00020!\"\u0004\b\u0000\u0010\"\"\n\b\u0001\u0010#*\u0004\u0018\u0001H\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016J\u0019\u0010'\u001a\u00020(*\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010*R9\u0010\u0005\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+\u00b2\u0006\u0014\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0-X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/exposed/sql/statements/BatchUpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "table", "Lorg/jetbrains/exposed/dao/id/IdTable;", "(Lorg/jetbrains/exposed/dao/id/IdTable;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "", "Lorg/jetbrains/exposed/sql/Column;", "", "getData", "()Ljava/util/ArrayList;", "firstDataSet", "", "getFirstDataSet", "()Ljava/util/List;", "getTable", "()Lorg/jetbrains/exposed/dao/id/IdTable;", "addBatch", "", "id", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "", "update", "", "T", "S", "column", "value", "Lorg/jetbrains/exposed/sql/Expression;", "executeInternal", "", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed-core", "different", ""})
public class BatchUpdateStatement
extends UpdateStatement {
    private final IdTable<?> table;
    private final ArrayList<Pair<EntityID<?>, Map<Column<?>, Object>>> data;

    public BatchUpdateStatement(IdTable<?> idTable) {
        Intrinsics.checkNotNullParameter(idTable, (String)"");
        super(idTable, null, null, 4, null);
        this.table = idTable;
        this.data = new ArrayList();
    }

    public final IdTable<?> getTable() {
        return this.table;
    }

    public final ArrayList<Pair<EntityID<?>, Map<Column<?>, Object>>> getData() {
        return this.data;
    }

    @Override
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList((Map)((Map)((Pair)CollectionsKt.first((List)this.data)).getSecond()));
    }

    public final void addBatch(EntityID<?> entityID) {
        Intrinsics.checkNotNullParameter(entityID, (String)"");
        Pair pair = (Pair)CollectionsKt.lastOrNull((List)this.data);
        Lazy lazy = LazyKt.lazy((Function0)new Function0<Set<? extends Column<?>>>(this, pair){
            final /* synthetic */ BatchUpdateStatement this$0;
            final /* synthetic */ Pair<EntityID<?>, Map<Column<?>, Object>> $lastBatch;
            {
                this.this$0 = batchUpdateStatement;
                this.$lastBatch = pair;
                super(0);
            }

            public final Set<Column<?>> invoke() {
                Set<K> set = (Set<K>)((Object)((UpdateStatement)this.this$0).getFirstDataSet());
                Object object = set;
                set = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)set, (int)10));
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = object.next();
                    object2 = (Pair)object2;
                    Set<K> set2 = set;
                    set2.add((Column)object2.getFirst());
                }
                object = CollectionsKt.toSet((Iterable)((List)((Object)set)));
                Pair<EntityID<?>, Map<Column<?>, Object>> pair = this.$lastBatch;
                Intrinsics.checkNotNull(pair);
                set = ((Map)pair.getSecond()).keySet();
                return SetsKt.plus((Set)SetsKt.minus((Set)object, (Iterable)set), (Iterable)SetsKt.minus(set, (Iterable)((Iterable)object)));
            }
        });
        if (this.data.size() > 1 && !((Collection)BatchUpdateStatement.addBatch$lambda$0(lazy)).isEmpty()) {
            throw new BatchDataInconsistentException("Some values missing for batch update. Different columns: " + BatchUpdateStatement.addBatch$lambda$0(lazy));
        }
        if (!((Collection)this.data).isEmpty()) {
            int n = this.data.size() - 1;
            Pair pair2 = pair;
            Intrinsics.checkNotNull((Object)pair2);
            this.data.set(n, Pair.copy$default((Pair)pair2, null, (Object)MapsKt.toMap(this.getValues()), (int)1, null));
            this.getValues().clear();
            this.setHasBatchedValues(true);
        }
        this.data.add(TuplesKt.to(entityID, this.getValues()));
    }

    public <T, S extends T> Void update(Column<T> column, Expression<S> expression) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(expression, (String)"");
        throw new IllegalStateException("Expressions unsupported in batch update".toString());
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return super.prepareSQL(transaction2, bl) + " WHERE " + transaction2.identity(this.table.getId()) + " = ?";
    }

    @Override
    public Integer executeInternal(PreparedStatementApi preparedStatementApi, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return this.data.size() == 1 ? preparedStatementApi.executeUpdate() : CollectionsKt.sumOfInt((Iterable)preparedStatementApi.executeBatch());
    }

    @Override
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        Iterable iterable = this.data;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (Pair)object2;
            Iterable iterable2 = iterable;
            EntityID entityID = (EntityID)object2.component1();
            object2 = (Map)object2.component2();
            Iterable iterable3 = ((UpdateStatement)this).getFirstDataSet();
            Object object3 = iterable3;
            iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            object3 = object3.iterator();
            while (object3.hasNext()) {
                Object object4 = object3.next();
                object4 = (Pair)object4;
                Iterable iterable4 = iterable3;
                iterable4.add(TuplesKt.to(((ExpressionWithColumnType)((Column)object4.getFirst())).getColumnType(), object2.get(object4.getFirst())));
            }
            iterable2.add(CollectionsKt.plus((Collection)((List)iterable3), (Object)TuplesKt.to(((ExpressionWithColumnType)this.table.getId()).getColumnType(), (Object)entityID)));
        }
        return (List)iterable;
    }

    private static final Set<Column<?>> addBatch$lambda$0(Lazy<? extends Set<? extends Column<?>>> lazy) {
        return (Set)lazy.getValue();
    }
}

