/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.ArrayColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0014\u0010\u0010\u001a\u00020\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "blobType", "byteType", "dateTimeType", "floatType", "hexToDb", "hexString", "integerAutoincType", "jsonBType", "longAutoincType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/sql/Expression;", "ulongAutoincType", "ulongType", "uuidToDB", "", "value", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public final class PostgreSQLDataTypeProvider
extends DataTypeProvider {
    public static final PostgreSQLDataTypeProvider INSTANCE = new PostgreSQLDataTypeProvider();

    private PostgreSQLDataTypeProvider() {
    }

    @Override
    public final String byteType() {
        return "SMALLINT";
    }

    @Override
    public final String floatType() {
        return "REAL";
    }

    @Override
    public final String ulongType() {
        return "BIGINT";
    }

    @Override
    public final String integerAutoincType() {
        return "SERIAL";
    }

    @Override
    public final String longAutoincType() {
        return "BIGSERIAL";
    }

    @Override
    public final String ulongAutoincType() {
        return "BIGSERIAL";
    }

    @Override
    public final String uuidType() {
        return "uuid";
    }

    @Override
    public final String binaryType() {
        return "bytea";
    }

    @Override
    public final String binaryType(int n) {
        SQLLogKt.getExposedLogger().warn("The length of the binary column is not required.");
        return ((DataTypeProvider)this).binaryType();
    }

    @Override
    public final String blobType() {
        return "bytea";
    }

    @Override
    public final Object uuidToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        return uUID;
    }

    @Override
    public final String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public final String jsonBType() {
        return "JSONB";
    }

    @Override
    public final String processForDefaultValue(Expression<?> object) {
        String string;
        Object object2;
        Intrinsics.checkNotNullParameter(object, (String)"");
        if (object instanceof LiteralOp && ((ExpressionWithColumnType)((LiteralOp)object)).getColumnType() instanceof JsonColumnMarker && ((object2 = DatabaseDialectKt.getCurrentDialect()) instanceof H2Dialect ? (H2Dialect)object2 : null) == null) {
            object2 = ((JsonColumnMarker)((Object)((ExpressionWithColumnType)((LiteralOp)object)).getColumnType())).getUsesBinaryFormat() ? "::jsonb" : "::json";
            return super.processForDefaultValue((Expression<?>)object) + (String)object2;
        }
        if (object instanceof LiteralOp && ((ExpressionWithColumnType)((LiteralOp)object)).getColumnType() instanceof BlobColumnType && ((BlobColumnType)((ExpressionWithColumnType)((LiteralOp)object)).getColumnType()).getUseObjectIdentifier() && ((object2 = DatabaseDialectKt.getCurrentDialect()) instanceof H2Dialect ? (H2Dialect)object2 : null) == null) {
            return "lo_from_bytea(0, " + super.processForDefaultValue((Expression<?>)object) + " :: bytea)";
        }
        if (object instanceof LiteralOp && ((ExpressionWithColumnType)((LiteralOp)object)).getColumnType() instanceof ArrayColumnType) {
            object2 = super.processForDefaultValue((Expression<?>)object);
            String string2 = object2;
            String string3 = object2;
            string = !Intrinsics.areEqual((Object)object2, (Object)"ARRAY[]") ? string2 : null;
            if (string == null) {
                String string4 = ((ArrayColumnType)((ExpressionWithColumnType)((LiteralOp)object)).getColumnType()).getDelegateType().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                object = string4;
                return (String)object2 + "::" + (String)object + "[]";
            }
        } else {
            string = super.processForDefaultValue((Expression<?>)object);
        }
        return string;
    }

    @Override
    public final String hexToDb(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "E'\\\\x" + string + '\'';
    }
}

