/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeadersImpl;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(DefaultHttpHeaders.nameValidator(true), DefaultHttpHeaders.valueValidator(true));
    }

    @Deprecated
    public DefaultHttpHeaders(boolean bl) {
        this(DefaultHttpHeaders.nameValidator(bl), DefaultHttpHeaders.valueValidator(bl));
    }

    protected DefaultHttpHeaders(boolean bl, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        this(nameValidator, DefaultHttpHeaders.valueValidator(bl));
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        this(nameValidator, valueValidator, 16);
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int n) {
        this((DefaultHeaders<CharSequence, CharSequence, ?>)new DefaultHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, (ValueConverter)HeaderValueConverter.INSTANCE, nameValidator, n, valueValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> defaultHeaders) {
        this.headers = defaultHeaders;
    }

    public Headers<CharSequence, CharSequence, ?> unwrap() {
        return this.headers;
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        this.headers.addObject((Object)string, object);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        this.headers.addObject((Object)charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        this.headers.addObject((Object)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.addObject((Object)charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence charSequence, int n) {
        this.headers.addInt((Object)charSequence, n);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence charSequence, short s) {
        this.headers.addShort((Object)charSequence, s);
        return this;
    }

    @Override
    public HttpHeaders remove(String string) {
        this.headers.remove((Object)string);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        this.headers.remove((Object)charSequence);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        this.headers.setObject((Object)string, object);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        this.headers.setObject((Object)charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        this.headers.setObject((Object)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.setObject((Object)charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n) {
        this.headers.setInt((Object)charSequence, n);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence charSequence, short s) {
        this.headers.setShort((Object)charSequence, s);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String string) {
        return ((HttpHeaders)this).get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        return HeadersUtils.getAsString(this.headers, (Object)charSequence);
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        return this.headers.getInt((Object)charSequence);
    }

    @Override
    public int getInt(CharSequence charSequence, int n) {
        return this.headers.getInt((Object)charSequence, n);
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        return this.headers.getShort((Object)charSequence);
    }

    @Override
    public short getShort(CharSequence charSequence, short s) {
        return this.headers.getShort((Object)charSequence, s);
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        return this.headers.getTimeMillis((Object)charSequence);
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l) {
        return this.headers.getTimeMillis((Object)charSequence, l);
    }

    @Override
    public List<String> getAll(String string) {
        return ((HttpHeaders)this).getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this.headers, (Object)charSequence);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.headers.size());
        for (Map.Entry<String, String> entry : this) {
            arrayList.add(entry);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence object) {
        object = ((HttpHeaders)this).valueCharSequenceIterator((CharSequence)object);
        return new Iterator<String>((Iterator)object){
            final /* synthetic */ Iterator val$itr;
            {
                this.val$itr = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$itr.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)this.val$itr.next()).toString();
            }

            @Override
            public void remove() {
                this.val$itr.remove();
            }
        };
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.headers.valueIterator((Object)charSequence);
    }

    @Override
    public boolean contains(String string) {
        return ((HttpHeaders)this).contains((CharSequence)string);
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.headers.contains((Object)charSequence);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String string, String string2, boolean bl) {
        return ((HttpHeaders)this).contains((CharSequence)string, (CharSequence)string2, bl);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return this.headers.contains((Object)charSequence, (Object)charSequence2, bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)object).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.ValueValidator<CharSequence> valueValidator(boolean bl) {
        if (bl) {
            return DefaultHttpHeadersFactory.headersFactory().getValueValidator();
        }
        return DefaultHttpHeadersFactory.headersFactory().withValidation(false).getValueValidator();
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean bl) {
        if (bl) {
            return DefaultHttpHeadersFactory.headersFactory().getNameValidator();
        }
        return DefaultHttpHeadersFactory.headersFactory().withNameValidation(false).getNameValidator();
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        public CharSequence convertObject(Object object) {
            if (object instanceof CharSequence) {
                return (CharSequence)object;
            }
            if (object instanceof Date) {
                return DateFormatter.format((Date)((Date)object));
            }
            if (object instanceof Calendar) {
                return DateFormatter.format((Date)((Calendar)object).getTime());
            }
            return object.toString();
        }
    }
}

