/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class HttpClientUpgradeHandler
extends HttpObjectAggregator
implements ChannelOutboundHandler {
    private final SourceCodec sourceCodec;
    private final UpgradeCodec upgradeCodec;
    private UpgradeEvent currentUpgradeEvent;

    public HttpClientUpgradeHandler(SourceCodec sourceCodec, UpgradeCodec upgradeCodec, int n) {
        super(n);
        this.sourceCodec = (SourceCodec)ObjectUtil.checkNotNull((Object)sourceCodec, (String)"sourceCodec");
        this.upgradeCodec = (UpgradeCodec)ObjectUtil.checkNotNull((Object)upgradeCodec, (String)"upgradeCodec");
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof HttpRequest) || this.currentUpgradeEvent == UpgradeEvent.UPGRADE_SUCCESSFUL) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        if (this.currentUpgradeEvent == UpgradeEvent.UPGRADE_ISSUED) {
            ReferenceCountUtil.release((Object)object);
            channelPromise.setFailure((Throwable)new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
            return;
        }
        this.currentUpgradeEvent = UpgradeEvent.UPGRADE_ISSUED;
        this.setUpgradeRequestHeaders(channelHandlerContext, (HttpRequest)object);
        channelHandlerContext.write(object, channelPromise);
        channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_ISSUED);
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        FullHttpResponse fullHttpResponse = null;
        try {
            Object object;
            if (this.currentUpgradeEvent != UpgradeEvent.UPGRADE_ISSUED) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (httpObject instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((object = (HttpResponse)httpObject).status())) {
                this.currentUpgradeEvent = null;
                channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_REJECTED);
                HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
                channelHandlerContext.fireChannelRead((Object)httpObject);
                return;
            }
            if (httpObject instanceof FullHttpResponse) {
                fullHttpResponse = (FullHttpResponse)httpObject;
                fullHttpResponse.retain();
                list.add(fullHttpResponse);
            } else {
                super.decode(channelHandlerContext, (Object)httpObject, list);
                if (list.isEmpty()) {
                    return;
                }
                assert (list.size() == 1);
                fullHttpResponse = (FullHttpResponse)list.get(0);
            }
            object = fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
            if (object != null && !AsciiString.contentEqualsIgnoreCase((CharSequence)this.upgradeCodec.protocol(), (CharSequence)object)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + object);
            }
            this.sourceCodec.prepareUpgradeFrom(channelHandlerContext);
            this.upgradeCodec.upgradeTo(channelHandlerContext, fullHttpResponse);
            this.currentUpgradeEvent = UpgradeEvent.UPGRADE_SUCCESSFUL;
            channelHandlerContext.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            fullHttpResponse.release();
            list.clear();
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
            return;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(fullHttpResponse);
            channelHandlerContext.fireExceptionCaught(throwable);
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
            return;
        }
    }

    private static void removeThisHandler(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().remove(channelHandlerContext.name());
    }

    private void setUpgradeRequestHeaders(ChannelHandlerContext object, HttpRequest httpRequest) {
        httpRequest.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgradeCodec.protocol());
        Object object2 = new LinkedHashSet<CharSequence>(2);
        object2.addAll(this.upgradeCodec.setUpgradeHeaders((ChannelHandlerContext)object, httpRequest));
        object = new StringBuilder();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            CharSequence charSequence = (CharSequence)object2.next();
            ((StringBuilder)object).append(charSequence);
            ((StringBuilder)object).append(',');
        }
        ((StringBuilder)object).append((CharSequence)HttpHeaderValues.UPGRADE);
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)((StringBuilder)object).toString());
    }

    public static interface UpgradeCodec {
        public CharSequence protocol();

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpResponse var2);
    }

    public static interface SourceCodec {
        public void prepareUpgradeFrom(ChannelHandlerContext var1);

        public void upgradeFrom(ChannelHandlerContext var1);
    }

    public static enum UpgradeEvent {
        UPGRADE_ISSUED,
        UPGRADE_SUCCESSFUL,
        UPGRADE_REJECTED;

    }
}

