/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieEncoder;
import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    private ServerCookieEncoder(boolean bl) {
        super(bl);
    }

    public final String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public final String encode(Cookie cookie) {
        Object object = ((Cookie)ObjectUtil.checkNotNull((Object)cookie, (String)"cookie")).name();
        String string = cookie.value() != null ? cookie.value() : "";
        this.validateCookie((String)object, string);
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, (String)object, string);
        } else {
            CookieUtil.add(stringBuilder, (String)object, string);
        }
        if (cookie.maxAge() != Long.MIN_VALUE) {
            CookieUtil.add(stringBuilder, "Max-Age", cookie.maxAge());
            object = new Date(cookie.maxAge() * 1000L + System.currentTimeMillis());
            stringBuilder.append("Expires");
            stringBuilder.append('=');
            DateFormatter.append((Date)object, (StringBuilder)stringBuilder);
            stringBuilder.append(';');
            stringBuilder.append(' ');
        }
        if (cookie.path() != null) {
            CookieUtil.add(stringBuilder, "Path", cookie.path());
        }
        if (cookie.domain() != null) {
            CookieUtil.add(stringBuilder, "Domain", cookie.domain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(stringBuilder, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(stringBuilder, "HTTPOnly");
        }
        if (cookie instanceof DefaultCookie) {
            object = (DefaultCookie)cookie;
            if (((DefaultCookie)object).sameSite() != null) {
                CookieUtil.add(stringBuilder, "SameSite", ((DefaultCookie)object).sameSite().name());
            }
            if (((DefaultCookie)object).isPartitioned()) {
                CookieUtil.add(stringBuilder, "Partitioned");
            }
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    private static List<String> dedup(List<String> list, Map<String, Integer> map) {
        int n;
        boolean[] blArray = new boolean[list.size()];
        Object object = map.values().iterator();
        while (object.hasNext()) {
            n = object.next();
            blArray[n] = true;
        }
        object = new ArrayList(map.size());
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            object.add(list.get(n));
        }
        return object;
    }

    public final List<String> encode(Cookie ... cookieArray) {
        if (((Cookie[])ObjectUtil.checkNotNull((Object)cookieArray, (String)"cookies")).length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
        HashMap<String, Integer> hashMap = this.strict && cookieArray.length > 1 ? new HashMap<String, Integer>() : null;
        boolean bl = false;
        for (int i = 0; i < cookieArray.length; ++i) {
            Cookie cookie = cookieArray[i];
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl |= hashMap.put(cookie.name(), i) != null;
        }
        if (bl) {
            return ServerCookieEncoder.dedup(arrayList, hashMap);
        }
        return arrayList;
    }

    public final List<String> encode(Collection<? extends Cookie> object) {
        if (((Collection)ObjectUtil.checkNotNull(object, (String)"cookies")).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        HashMap<String, Integer> hashMap = this.strict && object.size() > 1 ? new HashMap<String, Integer>() : null;
        int n = 0;
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            Cookie cookie = (Cookie)object.next();
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl |= hashMap.put(cookie.name(), n++) != null;
        }
        if (bl) {
            return ServerCookieEncoder.dedup(arrayList, hashMap);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public final List<String> encode(Iterable<? extends Cookie> var1_1) {
        if (!(var1_1 = ((Iterable)ObjectUtil.checkNotNull(var1_1, (String)"cookies")).iterator()).hasNext()) {
            return Collections.emptyList();
        }
        var2_2 = new ArrayList<String>();
        var3_3 = (Cookie)var1_1.next();
        var4_5 = this.strict != false && var1_1.hasNext() != false ? new HashMap<String, Integer>() : null;
        var5_6 = 0;
        var2_2.add(this.encode(var3_3));
        if (var4_5 == null) ** GOTO lbl-1000
        ++var5_6;
        if (var4_5.put(var3_3.name(), 0) != null) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var3_4 = false;
        }
        while (var1_1.hasNext()) {
            var6_7 = (Cookie)var1_1.next();
            var2_2.add(this.encode(var6_7));
            if (var4_5 == null) continue;
            var3_4 |= var4_5.put(var6_7.name(), var5_6++) != null;
        }
        if (var3_4) {
            return ServerCookieEncoder.dedup(var2_2, var4_5);
        }
        return var2_2;
    }
}

