/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8Validator;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameDecoder
extends ByteToMessageDecoder
implements WebSocketFrameDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameDecoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private final WebSocketDecoderConfig config;
    private int fragmentedFramesCount;
    private boolean frameFinalFlag;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private int mask;
    private int framePayloadLen1;
    private boolean receivedClosingHandshake;
    private State state = State.READING_FIRST;

    public WebSocket08FrameDecoder(boolean bl, boolean bl2, int n) {
        this(bl, bl2, n, false);
    }

    public WebSocket08FrameDecoder(boolean bl, boolean bl2, int n, boolean bl3) {
        this(WebSocketDecoderConfig.newBuilder().expectMaskedFrames(bl).allowExtensions(bl2).maxFramePayloadLength(n).allowMaskMismatch(bl3).build());
    }

    public WebSocket08FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.config = (WebSocketDecoderConfig)ObjectUtil.checkNotNull((Object)webSocketDecoderConfig, (String)"decoderConfig");
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        switch (this.state) {
            case READING_FIRST: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                this.framePayloadLength = 0L;
                byte by = byteBuf.readByte();
                this.frameFinalFlag = (by & 0x80) != 0;
                this.frameRsv = (by & 0x70) >> 4;
                this.frameOpcode = by & 0xF;
                if (logger.isTraceEnabled()) {
                    logger.trace("Decoding WebSocket Frame opCode={}", (Object)this.frameOpcode);
                }
                this.state = State.READING_SECOND;
            }
            case READING_SECOND: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                byte by = byteBuf.readByte();
                this.frameMasked = (by & 0x80) != 0;
                this.framePayloadLen1 = by & 0x7F;
                if (this.frameRsv != 0 && !this.config.allowExtensions()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    return;
                }
                if (!this.config.allowMaskMismatch() && this.config.expectMaskedFrames() != this.frameMasked) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "received a frame that is not masked as expected");
                    return;
                }
                if (this.frameOpcode > 7) {
                    if (!this.frameFinalFlag) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "fragmented control frame");
                        return;
                    }
                    if (this.framePayloadLen1 > 125) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame with payload length > 125 octets");
                        return;
                    }
                    if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.frameOpcode == 8 && this.framePayloadLen1 == 1) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received close control frame with payload len 1");
                        return;
                    }
                } else {
                    if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "data frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received continuation data frame outside fragmented message");
                        return;
                    }
                    if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received non-continuation data frame while inside fragmented message");
                        return;
                    }
                }
                this.state = State.READING_SIZE;
            }
            case READING_SIZE: {
                if (this.framePayloadLen1 == 126) {
                    if (byteBuf.readableBytes() < 2) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readUnsignedShort();
                    if (this.framePayloadLength < 126L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else if (this.framePayloadLen1 == 127) {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readLong();
                    if (this.framePayloadLength < 0L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (negative length)");
                        return;
                    }
                    if (this.framePayloadLength < 65536L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else {
                    this.framePayloadLength = this.framePayloadLen1;
                }
                if (this.framePayloadLength > (long)this.config.maxFramePayloadLength()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.MESSAGE_TOO_BIG, "Max frame length of " + this.config.maxFramePayloadLength() + " has been exceeded.");
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Decoding WebSocket Frame length={}", (Object)this.framePayloadLength);
                }
                this.state = State.MASKING_KEY;
            }
            case MASKING_KEY: {
                if (this.frameMasked) {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.mask = byteBuf.readInt();
                }
                this.state = State.PAYLOAD;
            }
            case PAYLOAD: {
                if ((long)byteBuf.readableBytes() < this.framePayloadLength) {
                    return;
                }
                ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
                try {
                    if (this.framePayloadLength > 0L) {
                        byteBuf2 = ByteBufUtil.readBytes((ByteBufAllocator)channelHandlerContext.alloc(), (ByteBuf)byteBuf, (int)WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength));
                    }
                    this.state = State.READING_FIRST;
                    if (this.frameMasked & this.framePayloadLength > 0L) {
                        this.unmask(byteBuf2);
                    }
                    if (this.frameOpcode == 9) {
                        list.add((Object)new PingWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 10) {
                        list.add((Object)new PongWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 8) {
                        this.receivedClosingHandshake = true;
                        this.checkCloseFrameBody(channelHandlerContext, byteBuf2);
                        list.add((Object)new CloseWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    this.fragmentedFramesCount = this.frameFinalFlag ? 0 : ++this.fragmentedFramesCount;
                    if (this.frameOpcode == 1) {
                        list.add((Object)new TextWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 2) {
                        list.add((Object)new BinaryWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 0) {
                        list.add((Object)new ContinuationWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    throw new UnsupportedOperationException("Cannot decode web socket frame with opcode: " + this.frameOpcode);
                }
                catch (Throwable throwable) {
                    if (byteBuf2 != null) {
                        byteBuf2.release();
                    }
                    throw throwable;
                }
            }
            case CORRUPT: {
                if (byteBuf.isReadable()) {
                    byteBuf.readByte();
                }
                return;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private void unmask(ByteBuf byteBuf) {
        int n;
        int n2 = byteBuf.writerIndex();
        ByteOrder byteOrder = byteBuf.order();
        int n3 = this.mask;
        long l = (long)n3 & 0xFFFFFFFFL;
        l |= l << 32;
        int n4 = n2 - 7;
        for (n = byteBuf.readerIndex(); n < n4; n += 8) {
            byteBuf.setLong(n, byteBuf.getLong(n) ^ l);
        }
        if (n < n2 - 3) {
            byteBuf.setInt(n, byteBuf.getInt(n) ^ (int)l);
            n += 4;
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            n3 = Integer.reverseBytes(n3);
        }
        n4 = 0;
        while (n < n2) {
            byteBuf.setByte(n, byteBuf.getByte(n) ^ WebSocketUtil.byteAtIndex(n3, n4++ & 3));
            ++n;
        }
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.PROTOCOL_ERROR, string);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, WebSocketCloseStatus webSocketCloseStatus, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, new CorruptedWebSocketFrameException(webSocketCloseStatus, string));
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf object, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        this.state = State.CORRUPT;
        int n = object.readableBytes();
        if (n > 0) {
            object.skipBytes(n);
        }
        if (channelHandlerContext.channel().isActive() && this.config.closeOnProtocolViolation()) {
            if (this.receivedClosingHandshake) {
                object = Unpooled.EMPTY_BUFFER;
            } else {
                object = corruptedWebSocketFrameException.closeStatus();
                String string = corruptedWebSocketFrameException.getMessage();
                if (string == null) {
                    string = object.reasonText();
                }
                object = new CloseWebSocketFrame((WebSocketCloseStatus)object, string);
            }
            channelHandlerContext.writeAndFlush(object).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    private static int toFrameLength(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new TooLongFrameException("frame length exceeds 2147483647: " + l);
        }
        return (int)l;
    }

    protected void checkCloseFrameBody(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        if (byteBuf.readableBytes() < 2) {
            this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "Invalid close frame body");
        }
        ByteBuf byteBuf2 = byteBuf;
        short s = byteBuf2.getShort(byteBuf2.readerIndex());
        if (!WebSocketCloseStatus.isValidStatusCode(s)) {
            this.protocolViolation(channelHandlerContext, byteBuf, "Invalid close frame getStatus code: " + s);
        }
        if (byteBuf.readableBytes() > 2) {
            try {
                ByteBuf byteBuf3 = byteBuf;
                new Utf8Validator().check(byteBuf3, byteBuf3.readerIndex() + 2, byteBuf.readableBytes() - 2);
                return;
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, byteBuf, corruptedWebSocketFrameException);
            }
        }
    }

    static enum State {
        READING_FIRST,
        READING_SECOND,
        READING_SIZE,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

