/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketFrameAggregator
extends MessageAggregator<WebSocketFrame, WebSocketFrame, ContinuationWebSocketFrame, WebSocketFrame> {
    public WebSocketFrameAggregator(int n) {
        super(n);
    }

    protected boolean isStartMessage(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame;
    }

    protected boolean isContentMessage(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof ContinuationWebSocketFrame;
    }

    protected boolean isLastContentMessage(ContinuationWebSocketFrame continuationWebSocketFrame) {
        return this.isContentMessage(continuationWebSocketFrame) && continuationWebSocketFrame.isFinalFragment();
    }

    protected boolean isAggregated(WebSocketFrame webSocketFrame) {
        if (webSocketFrame.isFinalFragment()) {
            return !this.isContentMessage(webSocketFrame);
        }
        return !this.isStartMessage(webSocketFrame) && !this.isContentMessage(webSocketFrame);
    }

    protected boolean isContentLengthInvalid(WebSocketFrame webSocketFrame, int n) {
        return false;
    }

    protected Object newContinueResponse(WebSocketFrame webSocketFrame, int n, ChannelPipeline channelPipeline) {
        return null;
    }

    protected boolean closeAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    protected boolean ignoreContentAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    protected WebSocketFrame beginAggregation(WebSocketFrame webSocketFrame, ByteBuf byteBuf) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            return new TextWebSocketFrame(true, webSocketFrame.rsv(), byteBuf);
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return new BinaryWebSocketFrame(true, webSocketFrame.rsv(), byteBuf);
        }
        throw new Error();
    }
}

