/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame>
implements ChannelOutboundHandler {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean bl) {
        this(bl, null, 0L);
    }

    WebSocketProtocolHandler(boolean bl, WebSocketCloseStatus webSocketCloseStatus, long l) {
        this.dropPongFrames = bl;
        this.closeStatus = webSocketCloseStatus;
        this.forceCloseTimeoutMillis = l;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (webSocketFrame instanceof PingWebSocketFrame) {
            webSocketFrame.content().retain();
            channelHandlerContext.writeAndFlush((Object)new PongWebSocketFrame(webSocketFrame.content()));
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        if (webSocketFrame instanceof PongWebSocketFrame && this.dropPongFrames) {
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        list.add((Object)webSocketFrame.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    public void close(final ChannelHandlerContext channelHandlerContext, final ChannelPromise channelPromise) {
        if (this.closeStatus == null || !channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        if (this.closeSent == null) {
            this.write(channelHandlerContext, (Object)new CloseWebSocketFrame(this.closeStatus), channelHandlerContext.newPromise());
        }
        this.flush(channelHandlerContext);
        this.applyCloseSentTimeout(channelHandlerContext);
        this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                channelHandlerContext.close(channelPromise);
            }
        });
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.closeSent != null) {
            ReferenceCountUtil.release((Object)object);
            channelPromise.setFailure((Throwable)new ClosedChannelException());
            return;
        }
        if (object instanceof CloseWebSocketFrame) {
            this.closeSent(channelPromise.unvoid());
            channelHandlerContext.write(object).addListener((GenericFutureListener)new PromiseNotifier(false, new Promise[]{this.closeSent}));
            return;
        }
        channelHandlerContext.write(object, channelPromise);
    }

    void closeSent(ChannelPromise channelPromise) {
        this.closeSent = channelPromise;
    }

    private void applyCloseSentTimeout(ChannelHandlerContext channelHandlerContext) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        channelHandlerContext = channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WebSocketProtocolHandler.this.closeSent.isDone()) {
                    WebSocketProtocolHandler.this.closeSent.tryFailure((Throwable)WebSocketProtocolHandler.this.buildHandshakeException("send close frame timed out"));
                }
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener((Future)channelHandlerContext){
            final /* synthetic */ Future val$timeoutTask;
            {
                this.val$timeoutTask = future;
            }

            public void operationComplete(ChannelFuture channelFuture) {
                this.val$timeoutTask.cancel(false);
            }
        });
    }

    protected WebSocketHandshakeException buildHandshakeException(String string) {
        return new WebSocketHandshakeException(string);
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }
}

