/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketServerProtocolConfig serverConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;
    private boolean isWebSocketPath;

    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig webSocketServerProtocolConfig) {
        this.serverConfig = (WebSocketServerProtocolConfig)ObjectUtil.checkNotNull((Object)webSocketServerProtocolConfig, (String)"serverConfig");
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.handshakePromise = channelHandlerContext.newPromise();
    }

    public void channelRead(final ChannelHandlerContext channelHandlerContext, Object object) {
        HttpObject httpObject = (HttpObject)object;
        if (httpObject instanceof HttpRequest) {
            httpObject = (HttpRequest)httpObject;
            this.isWebSocketPath = this.isWebSocketPath((HttpRequest)httpObject);
            if (!this.isWebSocketPath) {
                channelHandlerContext.fireChannelRead(object);
                return;
            }
            try {
                object = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(channelHandlerContext.pipeline(), (HttpRequest)httpObject, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
                object = ((WebSocketServerHandshakerFactory)object).newHandshaker((HttpRequest)httpObject);
                final ChannelPromise channelPromise = this.handshakePromise;
                if (object == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channelHandlerContext.channel());
                }
                WebSocketServerProtocolHandler.setHandshaker(channelHandlerContext.channel(), (WebSocketServerHandshaker)object);
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
                ChannelFuture channelFuture = ((WebSocketServerHandshaker)object).handshake(channelHandlerContext.channel(), (HttpRequest)httpObject);
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener((HttpRequest)httpObject, (WebSocketServerHandshaker)object){
                    final /* synthetic */ HttpRequest val$req;
                    final /* synthetic */ WebSocketServerHandshaker val$handshaker;
                    {
                        this.val$req = httpRequest;
                        this.val$handshaker = webSocketServerHandshaker;
                    }

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            channelPromise.tryFailure(channelFuture.cause());
                            channelHandlerContext.fireExceptionCaught(channelFuture.cause());
                            return;
                        }
                        channelPromise.trySuccess();
                        channelHandlerContext.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
                        channelHandlerContext.fireUserEventTriggered((Object)new WebSocketServerProtocolHandler.HandshakeComplete(this.val$req.uri(), this.val$req.headers(), this.val$handshaker.selectedSubprotocol()));
                    }
                });
                this.applyHandshakeTimeout();
            }
            finally {
                ReferenceCountUtil.release((Object)httpObject);
            }
        } else {
            if (!this.isWebSocketPath) {
                channelHandlerContext.fireChannelRead(object);
                return;
            }
            ReferenceCountUtil.release((Object)object);
        }
    }

    private boolean isWebSocketPath(HttpRequest object) {
        String string = this.serverConfig.websocketPath();
        object = object.uri();
        if (this.serverConfig.checkStartsWith()) {
            return ((String)object).startsWith(string) && ("/".equals(string) || this.checkNextUri((String)object, string));
        }
        return ((String)object).equals(string);
    }

    private boolean checkNextUri(String string, String string2) {
        int n = string2.length();
        if (string.length() > n) {
            char c = string.charAt(n);
            return c == '/' || c == '?';
        }
        return true;
    }

    private static void sendHttpResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponse httpResponse) {
        channelHandlerContext = channelHandlerContext.writeAndFlush((Object)httpResponse);
        if (!HttpUtil.isKeepAlive(httpRequest) || httpResponse.status().code() != 200) {
            channelHandlerContext.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline object, HttpRequest httpRequest, String string) {
        String string2 = "ws";
        if (object.get(SslHandler.class) != null) {
            string2 = "wss";
        }
        object = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
        return string2 + "://" + (String)object + string;
    }

    private void applyHandshakeTimeout() {
        final ChannelPromise channelPromise = this.handshakePromise;
        long l = this.serverConfig.handshakeTimeoutMillis();
        if (l <= 0L || channelPromise.isDone()) {
            return;
        }
        ScheduledFuture scheduledFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!channelPromise.isDone() && channelPromise.tryFailure((Throwable)new WebSocketServerHandshakeException("handshake timed out"))) {
                    WebSocketServerProtocolHandshakeHandler.this.ctx.flush().fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT).close();
                }
            }
        }, l, TimeUnit.MILLISECONDS);
        channelPromise.addListener((GenericFutureListener)new FutureListener<Void>((Future)scheduledFuture){
            final /* synthetic */ Future val$timeoutFuture;
            {
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Void> future) {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }
}

