/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new FastThreadLocal<MessageDigest>(){

        protected final MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("MD5 not supported on this platform - Outdated?");
            }
        }
    };
    private static final FastThreadLocal<MessageDigest> SHA1 = new FastThreadLocal<MessageDigest>(){

        protected final MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("SHA-1 not supported on this platform - Outdated?");
            }
        }
    };

    static byte[] md5(byte[] byArray) {
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] byArray) {
        return WebSocketUtil.digest(SHA1, byArray);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> object, byte[] byArray) {
        object = (MessageDigest)object.get();
        ((MessageDigest)object).reset();
        return ((MessageDigest)object).digest(byArray);
    }

    static String base64(byte[] object) {
        if (PlatformDependent.javaVersion() >= 8) {
            return java.util.Base64.getEncoder().encodeToString((byte[])object);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])object);
        try {
            ByteBuf byteBuf2 = Base64.encode((ByteBuf)byteBuf);
            try {
                object = byteBuf2.toString(CharsetUtil.UTF_8);
            }
            finally {
                byteBuf2.release();
            }
        }
        finally {
            byteBuf.release();
        }
        return object;
    }

    static byte[] randomBytes(int n) {
        byte[] byArray = new byte[n];
        PlatformDependent.threadLocalRandom().nextBytes(byArray);
        return byArray;
    }

    static int randomNumber(int n, int n2) {
        assert (n < n2);
        double d = PlatformDependent.threadLocalRandom().nextDouble();
        return (int)((double)n + d * (double)(n2 - n));
    }

    static int byteAtIndex(int n, int n2) {
        return n >> 8 * (3 - n2) & 0xFF;
    }

    private WebSocketUtil() {
    }
}

