/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebSocketClientExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketClientExtensionHandshaker> extensionHandshakers;

    public WebSocketClientExtensionHandler(WebSocketClientExtensionHandshaker ... webSocketClientExtensionHandshakerArray) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty((Object[])webSocketClientExtensionHandshakerArray, (String)"extensionHandshakers"));
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade(((HttpRequest)object).headers())) {
            HttpRequest httpRequest = (HttpRequest)object;
            String string = httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker webSocketClientExtensionHandshaker : this.extensionHandshakers) {
                arrayList.add(webSocketClientExtensionHandshaker.newRequestData());
            }
            String string2 = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(string, arrayList);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)string2);
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        Object object2;
        if (object instanceof HttpResponse && WebSocketExtensionUtil.isWebsocketUpgrade((object2 = (HttpResponse)object).headers())) {
            if ((object2 = object2.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
                Object object3;
                Object object4;
                Iterator iterator = WebSocketExtensionUtil.extractExtensions((String)object2);
                ArrayList<Object> arrayList = new ArrayList<Object>(iterator.size());
                int n = 0;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object5 = (WebSocketExtensionData)iterator.next();
                    object4 = this.extensionHandshakers.iterator();
                    for (object3 = null; object3 == null && object4.hasNext(); object3 = object3.handshakeExtension((WebSocketExtensionData)object5)) {
                        object3 = (WebSocketClientExtensionHandshaker)object4.next();
                    }
                    if (object3 != null && (object3.rsv() & n) == 0) {
                        n |= object3.rsv();
                        arrayList.add(object3);
                        continue;
                    }
                    throw new CodecException("invalid WebSocket Extension handshake for \"" + (String)object2 + '\"');
                }
                for (Object object5 : arrayList) {
                    object4 = object5.newExtensionDecoder();
                    object3 = object5.newExtensionEncoder();
                    channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), object4.getClass().getName(), (ChannelHandler)object4);
                    channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), object3.getClass().getName(), (ChannelHandler)object3);
                }
            }
            channelHandlerContext.pipeline().remove(channelHandlerContext.name());
        }
        super.channelRead(channelHandlerContext, object);
    }
}

