/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateEncoder;

class PerFrameDeflateEncoder
extends DeflateEncoder {
    PerFrameDeflateEncoder(int n, int n2, boolean bl) {
        super(n, n2, bl, WebSocketExtensionFilter.NEVER_SKIP);
    }

    PerFrameDeflateEncoder(int n, int n2, boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        super(n, n2, bl, webSocketExtensionFilter);
    }

    public boolean acceptOutboundMessage(Object object) {
        if (!super.acceptOutboundMessage(object)) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)((Object)object);
        if (this.extensionEncoderFilter().mustSkip(webSocketFrame)) {
            return false;
        }
        return (object instanceof TextWebSocketFrame || object instanceof BinaryWebSocketFrame || object instanceof ContinuationWebSocketFrame) && webSocketFrame.content().readableBytes() > 0 && (webSocketFrame.rsv() & 4) == 0;
    }

    @Override
    protected int rsv(WebSocketFrame webSocketFrame) {
        return webSocketFrame.rsv() | 4;
    }

    @Override
    protected boolean removeFrameTail(WebSocketFrame webSocketFrame) {
        return true;
    }
}

