/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.converters.ConversionService;
import io.ktor.util.converters.ConversionServiceJvmKt;
import io.ktor.util.converters.DataConversionException;
import io.ktor.util.reflect.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00072\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/ktor/util/converters/DefaultConversionService;", "Lio/ktor/util/converters/ConversionService;", "<init>", "()V", "", "value", "", "", "toValues", "(Ljava/lang/Object;)Ljava/util/List;", "values", "Lio/ktor/util/reflect/TypeInfo;", "type", "fromValues", "(Ljava/util/List;Lio/ktor/util/reflect/TypeInfo;)Ljava/lang/Object;", "Lkotlin/reflect/KClass;", "klass", "fromValue", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "convertPrimitives", "(Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/Object;", "typeName", "", "throwConversionException", "(Ljava/lang/String;)Ljava/lang/Void;", "ktor-utils"})
public final class DefaultConversionService
implements ConversionService {
    public static final DefaultConversionService INSTANCE = new DefaultConversionService();

    private DefaultConversionService() {
    }

    @Override
    public final List<String> toValues(Object iterator2) {
        if (iterator2 == null) {
            return CollectionsKt.emptyList();
        }
        Object object = ConversionServiceJvmKt.platformDefaultToValues(iterator2);
        if (object != null) {
            return object;
        }
        if (iterator2 instanceof Iterable) {
            object = (Iterable)((Object)iterator2);
            iterator2 = object;
            object = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object2 = iterator2.next();
                object2 = INSTANCE.toValues(object2);
                CollectionsKt.addAll((Collection)object, object2);
            }
            return (List)object;
        }
        object = Reflection.getOrCreateKotlinClass(iterator2.getClass());
        if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) || Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            return CollectionsKt.listOf((Object)iterator2.toString());
        }
        throw new DataConversionException("Class " + object + " is not supported in default data conversion service");
    }

    @Override
    public final Object fromValues(List<String> object, TypeInfo object2) {
        Object object3;
        Object object4;
        KClass kClass;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        if (object.isEmpty()) {
            return null;
        }
        if ((Intrinsics.areEqual(((TypeInfo)object2).getType(), (Object)Reflection.getOrCreateKotlinClass(List.class)) || Intrinsics.areEqual(((TypeInfo)object2).getType(), (Object)Reflection.getOrCreateKotlinClass(List.class))) && (kClass = (object4 = (object3 = ((TypeInfo)object2).getKotlinType()) != null && (object3 = object3.getArguments()) != null && (object3 = (KTypeProjection)CollectionsKt.single((List)object3)) != null && (object3 = object3.getType()) != null ? object3.getClassifier() : null) instanceof KClass ? (KClass)object4 : null) != null) {
            object4 = (Iterable)object;
            object = object4;
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                object4 = object.next();
                object4 = (String)object4;
                Object object5 = object2;
                object5.add(INSTANCE.fromValue((String)object4, kClass));
            }
            return (List)object2;
        }
        if (object.isEmpty()) {
            throw new DataConversionException("There are no values when trying to construct single value " + object2);
        }
        if (object.size() > 1) {
            throw new DataConversionException("There are multiple values when trying to construct single value " + object2);
        }
        return this.fromValue((String)CollectionsKt.single(object), ((TypeInfo)object2).getType());
    }

    public final Object fromValue(String object, KClass<?> kClass) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        Object object2 = this.convertPrimitives(kClass, (String)object);
        if (object2 != null) {
            return object2;
        }
        if ((object = ConversionServiceJvmKt.platformDefaultFromValues((String)object, kClass)) != null) {
            return object;
        }
        this.throwConversionException(kClass.toString());
        throw new KotlinNothingValueException();
    }

    private final Object convertPrimitives(KClass<?> kClass, String string) {
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            return Integer.parseInt(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            return Double.parseDouble(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            return Long.parseLong(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            return Short.parseShort(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            return Character.valueOf(StringsKt.single((CharSequence)string));
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            return Boolean.parseBoolean(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            return string;
        }
        return null;
    }

    private final Void throwConversionException(String string) {
        throw new DataConversionException("Type " + string + " is not supported in default data conversion service");
    }
}

